/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.core.CoreBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.SavingRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileDocumentManager
implements SavingRequestor {
    @NotNull
    public static FileDocumentManager getInstance() {
        return (FileDocumentManager)ApplicationManager.getApplication().getService(FileDocumentManager.class);
    }

    @Nullable
    public abstract Document getDocument(@NotNull VirtualFile var1);

    @Nullable
    public abstract Document getCachedDocument(@NotNull VirtualFile var1);

    @Nullable
    public abstract VirtualFile getFile(@NotNull Document var1);

    public abstract void saveAllDocuments();

    public abstract void saveDocuments(@NotNull Predicate<Document> var1);

    public abstract void saveDocument(@NotNull Document var1);

    public abstract void saveDocumentAsIs(@NotNull Document var1);

    public abstract Document @NotNull [] getUnsavedDocuments();

    public abstract boolean isDocumentUnsaved(@NotNull Document var1);

    public abstract boolean isFileModified(@NotNull VirtualFile var1);

    public abstract boolean isPartialPreviewOfALargeFile(@NotNull Document var1);

    public abstract void reloadFromDisk(@NotNull Document var1);

    @NotNull
    public abstract String getLineSeparator(@Nullable VirtualFile var1, @Nullable Project var2);

    public abstract boolean requestWriting(@NotNull Document var1, @Nullable Project var2);

    @NotNull
    public WriteAccessStatus requestWritingStatus(@NotNull Document document, @Nullable Project project) {
        return this.requestWriting(document, project) ? WriteAccessStatus.WRITABLE : WriteAccessStatus.NON_WRITABLE;
    }

    public static boolean fileForDocumentCheckedOutSuccessfully(@NotNull Document document, @NotNull Project project) {
        return FileDocumentManager.getInstance().requestWriting(document, project);
    }

    public abstract void reloadFiles(VirtualFile ... var1);

    @ApiStatus.Internal
    public void reloadBinaryFiles() {
    }

    public static class WriteAccessStatus {
        public static final WriteAccessStatus NON_WRITABLE = new WriteAccessStatus(false);
        public static final WriteAccessStatus WRITABLE = new WriteAccessStatus(true);
        private final boolean myWithWriteAccess;
        @NotNull
        private final String myReadOnlyMessage;

        private WriteAccessStatus(boolean withWriteAccess) {
            this.myWithWriteAccess = withWriteAccess;
            this.myReadOnlyMessage = withWriteAccess ? "" : CoreBundle.message("editing.read.only.file.hint", new Object[0]);
        }

        public WriteAccessStatus(@NotNull String readOnlyMessage) {
            this.myWithWriteAccess = false;
            this.myReadOnlyMessage = readOnlyMessage;
        }

        public boolean hasWriteAccess() {
            return this.myWithWriteAccess;
        }

        @NotNull
        public String getReadOnlyMessage() {
            return this.myReadOnlyMessage;
        }
    }
}

