/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FileSaverDescriptor
extends FileChooserDescriptor
implements Cloneable {
    private final List<String> extensions;

    public FileSaverDescriptor(@NlsContexts.DialogTitle @NotNull String title, @NlsContexts.Label @NotNull String description, String ... extensions) {
        super(true, true, true, true, false, false);
        this.setTitle(title);
        this.setDescription(description);
        this.extensions = Arrays.asList(extensions);
    }

    @Override
    public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
        return this.extensions.isEmpty() || file.isDirectory() ? super.isFileVisible(file, showHiddenFiles) : this.extensions.contains(file.getExtension());
    }

    public String[] getFileExtensions() {
        return ArrayUtilRt.toStringArray(this.extensions);
    }
}

