/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileChooser {
    private static final Logger LOG = Logger.getInstance(FileChooser.class);

    private FileChooser() {
    }

    public static VirtualFile @NotNull [] chooseFiles(@NotNull FileChooserDescriptor descriptor, @Nullable Project project, @Nullable VirtualFile toSelect) {
        return FileChooser.chooseFiles(descriptor, null, project, toSelect);
    }

    public static VirtualFile @NotNull [] chooseFiles(@NotNull FileChooserDescriptor descriptor, @Nullable Component parent, @Nullable Project project, @Nullable VirtualFile toSelect) {
        FileChooserDialog chooser = FileChooserFactory.getInstance().createFileChooser(descriptor, project, parent);
        return chooser.choose(project, toSelect);
    }

    @Nullable
    public static VirtualFile chooseFile(@NotNull FileChooserDescriptor descriptor, @Nullable Project project, @Nullable VirtualFile toSelect) {
        return FileChooser.chooseFile(descriptor, null, project, toSelect);
    }

    @Nullable
    public static VirtualFile chooseFile(@NotNull FileChooserDescriptor descriptor, @Nullable Component parent, @Nullable Project project, @Nullable VirtualFile toSelect) {
        Component parentComponent = parent == null ? KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() : parent;
        LOG.assertTrue(!descriptor.isChooseMultiple());
        return (VirtualFile)ArrayUtil.getFirstElement((Object[])FileChooser.chooseFiles(descriptor, parentComponent, project, toSelect));
    }

    public static void chooseFiles(@NotNull FileChooserDescriptor descriptor, @Nullable Project project, @Nullable VirtualFile toSelect, @NotNull Consumer<? super List<VirtualFile>> callback) {
        FileChooser.chooseFiles(descriptor, project, null, toSelect, callback);
    }

    public static void chooseFiles(@NotNull FileChooserDescriptor descriptor, @Nullable Project project, @Nullable Component parent, @Nullable VirtualFile toSelect, @NotNull Consumer<? super List<VirtualFile>> callback) {
        Component parentComponent = parent == null ? WindowManager.getInstance().suggestParentWindow(project) : parent;
        FileChooserFactory factory = FileChooserFactory.getInstance();
        PathChooserDialog pathChooser = factory.createPathChooser(descriptor, project, parentComponent);
        pathChooser.choose(toSelect, callback);
    }

    public static void chooseFile(@NotNull FileChooserDescriptor descriptor, @Nullable Project project, @Nullable VirtualFile toSelect, @NotNull Consumer<? super VirtualFile> callback) {
        FileChooser.chooseFile(descriptor, project, null, toSelect, callback);
    }

    public static void chooseFile(@NotNull FileChooserDescriptor descriptor, @Nullable Project project, @Nullable Component parent, @Nullable VirtualFile toSelect, @NotNull Consumer<? super VirtualFile> callback) {
        LOG.assertTrue(!descriptor.isChooseMultiple());
        FileChooser.chooseFiles(descriptor, project, parent, toSelect, (Consumer<? super List<VirtualFile>>)((Consumer)files -> callback.consume(files.get(0))));
    }

    public static interface FileChooserConsumer
    extends Consumer<List<VirtualFile>> {
        public void cancelled();
    }
}

