/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.settings;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExternalProjectSettings
implements Comparable<ExternalProjectSettings>,
Cloneable {
    private static final Logger LOG = Logger.getInstance(ExternalProjectSettings.class);
    private String myExternalProjectPath;
    @Nullable
    private Set<String> myModules = new HashSet<String>();
    private boolean myUseQualifiedModuleNames = true;
    @Deprecated
    private boolean myCreateEmptyContentRootDirectories;

    @NotNull
    public Set<String> getModules() {
        return this.myModules == null ? Collections.emptySet() : this.myModules;
    }

    public void setModules(@Nullable Set<String> modules) {
        this.myModules = modules;
    }

    public void setupNewProjectDefault() {
        this.myUseQualifiedModuleNames = true;
    }

    public String getExternalProjectPath() {
        return this.myExternalProjectPath;
    }

    public void setExternalProjectPath(@NotNull String externalProjectPath) {
        this.myExternalProjectPath = externalProjectPath;
    }

    @Transient
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public boolean isUseAutoImport() {
        return true;
    }

    @Transient
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public void setUseAutoImport(boolean useAutoImport) {
        LOG.warn(new Throwable("Auto-import cannot be disabled"));
    }

    @Deprecated
    public boolean isCreateEmptyContentRootDirectories() {
        return this.myCreateEmptyContentRootDirectories;
    }

    @Deprecated
    public void setCreateEmptyContentRootDirectories(boolean createEmptyContentRootDirectories) {
        this.myCreateEmptyContentRootDirectories = createEmptyContentRootDirectories;
    }

    public boolean isUseQualifiedModuleNames() {
        return this.myUseQualifiedModuleNames;
    }

    public void setUseQualifiedModuleNames(boolean useQualifiedModuleNames) {
        this.myUseQualifiedModuleNames = useQualifiedModuleNames;
    }

    @Override
    public int compareTo(@NotNull ExternalProjectSettings that) {
        return Comparing.compare((Comparable)((Object)this.myExternalProjectPath), (Comparable)((Object)that.myExternalProjectPath));
    }

    public int hashCode() {
        return this.myExternalProjectPath != null ? this.myExternalProjectPath.hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalProjectSettings that = (ExternalProjectSettings)o;
        return this.myExternalProjectPath == null ? that.myExternalProjectPath == null : this.myExternalProjectPath.equals(that.myExternalProjectPath);
    }

    public String toString() {
        return this.myExternalProjectPath;
    }

    @NotNull
    public abstract ExternalProjectSettings clone();

    protected void copyTo(@NotNull ExternalProjectSettings receiver) {
        receiver.myExternalProjectPath = this.myExternalProjectPath;
        receiver.myModules = this.myModules != null ? new HashSet<String>(this.myModules) : new HashSet();
        receiver.myCreateEmptyContentRootDirectories = this.myCreateEmptyContentRootDirectories;
        receiver.myUseQualifiedModuleNames = this.myUseQualifiedModuleNames;
    }
}

