/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListenerAdapter;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListenerEx;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalSystemSettings<SS extends AbstractExternalSystemSettings<SS, PS, L>, PS extends ExternalProjectSettings, L extends ExternalSystemSettingsListener<PS>>
implements Disposable {
    @NotNull
    private final AtomicNullableLazyValue<ExternalSystemManager<?, ?, ?, ?, ?>> myManager;
    @NotNull
    private final Topic<L> myChangesTopic;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<String, PS> myLinkedProjectsSettings = new HashMap<String, PS>();
    @NotNull
    private final Map<String, PS> myLinkedProjectsSettingsView = Collections.unmodifiableMap(this.myLinkedProjectsSettings);

    protected AbstractExternalSystemSettings(@NotNull Topic<L> topic, @NotNull Project project) {
        this.myChangesTopic = topic;
        this.myProject = project;
        this.myManager = AtomicNullableLazyValue.createValue(this::deduceManager);
    }

    public void dispose() {
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    private ExternalSystemManager<?, ?, ?, ?, ?> deduceManager() {
        return ExternalSystemApiUtil.getAllManagers().stream().filter(it -> this.equals(it.getSettingsProvider().fun((Object)this.myProject))).findFirst().orElse(null);
    }

    public boolean showSelectiveImportDialogOnInitialImport() {
        return SystemProperties.is((String)"external.system.show.selective.import.dialog");
    }

    public void subscribe(@NotNull ExternalSystemSettingsListener<PS> listener2, @NotNull Disposable parentDisposable) {
        this.subscribe(listener2);
    }

    @Deprecated
    public abstract void subscribe(@NotNull ExternalSystemSettingsListener<PS> var1);

    protected void doSubscribe(@NotNull L listener2, @NotNull Disposable parentDisposable) {
        MessageBus messageBus = this.myProject.getMessageBus();
        MessageBusConnection connection = messageBus.connect(parentDisposable);
        connection.subscribe(this.getChangesTopic(), listener2);
    }

    public void copyFrom(@NotNull SS settings) {
        for (ExternalProjectSettings projectSettings : ((AbstractExternalSystemSettings)settings).getLinkedProjectsSettings()) {
            this.myLinkedProjectsSettings.put(projectSettings.getExternalProjectPath(), projectSettings);
        }
        this.copyExtraSettingsFrom(settings);
    }

    protected abstract void copyExtraSettingsFrom(@NotNull SS var1);

    @NotNull
    public Collection<PS> getLinkedProjectsSettings() {
        return this.myLinkedProjectsSettingsView.values();
    }

    @Nullable
    public PS getLinkedProjectSettings(@NotNull String linkedProjectPath) {
        ExternalProjectSettings ps = (ExternalProjectSettings)this.myLinkedProjectsSettings.get(linkedProjectPath);
        if (ps == null) {
            for (ExternalProjectSettings ps1 : this.myLinkedProjectsSettings.values()) {
                for (String modulePath : ps1.getModules()) {
                    if (!linkedProjectPath.equals(modulePath)) continue;
                    return (PS)ps1;
                }
            }
        }
        if (ps == null) {
            ps = (ExternalProjectSettings)this.myLinkedProjectsSettings.get(FileUtil.toSystemIndependentName((String)linkedProjectPath));
        }
        return (PS)ps;
    }

    public void linkProject(@NotNull PS settings) throws IllegalArgumentException {
        PS existing = this.getLinkedProjectSettings(((ExternalProjectSettings)settings).getExternalProjectPath());
        if (existing != null) {
            throw new IllegalArgumentException(String.format("Can't link project '%s'. Reason: it's already linked to the IDE project", ((ExternalProjectSettings)settings).getExternalProjectPath()));
        }
        this.myLinkedProjectsSettings.put(((ExternalProjectSettings)settings).getExternalProjectPath(), settings);
        this.onProjectsLinked(Collections.singleton(settings));
    }

    public boolean unlinkExternalProject(@NotNull String linkedProjectPath) {
        ExternalProjectSettings removed = (ExternalProjectSettings)this.myLinkedProjectsSettings.remove(linkedProjectPath);
        if (removed == null) {
            return false;
        }
        this.onProjectsUnlinked(Collections.singleton(linkedProjectPath));
        return true;
    }

    public void setLinkedProjectsSettings(@NotNull Collection<? extends PS> settings) {
        this.setLinkedProjectsSettings(settings, new ExternalSystemSettingsListenerAdapter<PS>(){

            @Override
            public void onProjectsLinked(@NotNull Collection<PS> settings) {
                AbstractExternalSystemSettings.this.onProjectsLinked(settings);
            }

            @Override
            public void onProjectsUnlinked(@NotNull Set<String> linkedProjectPaths) {
                AbstractExternalSystemSettings.this.onProjectsUnlinked(linkedProjectPaths);
            }
        });
    }

    private void setLinkedProjectsSettings(@NotNull Collection<? extends PS> settings, @NotNull ExternalSystemSettingsListener<PS> listener2) {
        settings = ContainerUtil.filter(settings, ps -> ps.getExternalProjectPath() != null);
        ArrayList<ExternalProjectSettings> added = new ArrayList<ExternalProjectSettings>();
        HashMap<String, PS> removed = new HashMap<String, PS>(this.myLinkedProjectsSettings);
        this.myLinkedProjectsSettings.clear();
        for (ExternalProjectSettings current : settings) {
            this.myLinkedProjectsSettings.put(current.getExternalProjectPath(), current);
        }
        for (ExternalProjectSettings current : settings) {
            ExternalProjectSettings old = (ExternalProjectSettings)removed.remove(current.getExternalProjectPath());
            if (old == null) {
                added.add(current);
                continue;
            }
            this.checkSettings(old, current);
        }
        if (!added.isEmpty()) {
            listener2.onProjectsLinked(added);
        }
        if (!removed.isEmpty()) {
            listener2.onProjectsUnlinked(removed.keySet());
        }
    }

    protected abstract void checkSettings(@NotNull PS var1, @NotNull PS var2);

    @NotNull
    public Topic<L> getChangesTopic() {
        return this.myChangesTopic;
    }

    @NotNull
    public L getPublisher() {
        return (L)((ExternalSystemSettingsListener)this.myProject.getMessageBus().syncPublisher(this.myChangesTopic));
    }

    protected void fillState(@NotNull State<PS> state) {
        state.setLinkedExternalProjectsSettings(new TreeSet<PS>(this.myLinkedProjectsSettings.values()));
    }

    protected void loadState(@NotNull State<PS> state) {
        Set<PS> settings = state.getLinkedExternalProjectsSettings();
        if (settings != null) {
            this.setLinkedProjectsSettings(settings, new ExternalSystemSettingsListenerAdapter<PS>(){

                @Override
                public void onProjectsLinked(@NotNull Collection<PS> settings) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        AbstractExternalSystemSettings.this.onProjectsLinked(settings);
                        AbstractExternalSystemSettings.this.onProjectsLoaded(settings);
                    }, AbstractExternalSystemSettings.this.myProject.getDisposed());
                }

                @Override
                public void onProjectsUnlinked(@NotNull Set<String> linkedProjectPaths) {
                    ApplicationManager.getApplication().invokeLater(() -> AbstractExternalSystemSettings.this.onProjectsUnlinked(linkedProjectPaths), AbstractExternalSystemSettings.this.myProject.getDisposed());
                }
            });
        }
    }

    private void onProjectsLoaded(@NotNull Collection<PS> settings) {
        this.getPublisher().onProjectsLoaded(settings);
        ExternalSystemManager manager = (ExternalSystemManager)this.myManager.getValue();
        if (manager != null) {
            ExternalSystemSettingsListenerEx.Companion.onProjectsLoaded(this.myProject, manager, settings);
        }
    }

    private void onProjectsLinked(@NotNull Collection<PS> settings) {
        this.getPublisher().onProjectsLinked(settings);
        ExternalSystemManager manager = (ExternalSystemManager)this.myManager.getValue();
        if (manager != null) {
            ExternalSystemSettingsListenerEx.Companion.onProjectsLinked(this.myProject, manager, settings);
        }
    }

    private void onProjectsUnlinked(@NotNull Set<String> linkedProjectPaths) {
        this.getPublisher().onProjectsUnlinked(linkedProjectPaths);
        ExternalSystemManager manager = (ExternalSystemManager)this.myManager.getValue();
        if (manager != null) {
            ExternalSystemSettingsListenerEx.Companion.onProjectsUnlinked(this.myProject, manager, linkedProjectPaths);
        }
    }

    public static interface State<S> {
        public Set<S> getLinkedExternalProjectsSettings();

        public void setLinkedExternalProjectsSettings(Set<S> var1);
    }
}

