/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.textarea.TextComponentEditor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.MathUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Producer;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorModificationUtil {
    private static final Key<ReadOnlyHint> READ_ONLY_VIEW_HINT_KEY = Key.create((String)"READ_ONLY_VIEW_HINT_KEY");

    private EditorModificationUtil() {
    }

    public static void deleteSelectedText(Editor editor) {
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            return;
        }
        int selectionStart = selectionModel.getSelectionStart();
        int selectionEnd = selectionModel.getSelectionEnd();
        VisualPosition selectionStartPosition = selectionModel.getSelectionStartPosition();
        if (editor.isColumnMode() && editor.getCaretModel().supportsMultipleCarets() && selectionStartPosition != null) {
            editor.getCaretModel().moveToVisualPosition(selectionStartPosition);
        } else {
            editor.getCaretModel().moveToOffset(selectionStart);
        }
        selectionModel.removeSelection();
        editor.getDocument().deleteString(selectionStart, selectionEnd);
        EditorModificationUtil.scrollToCaret(editor);
    }

    public static void deleteSelectedTextForAllCarets(@NotNull Editor editor) {
        editor.getCaretModel().runForEachCaret(__ -> EditorModificationUtil.deleteSelectedText(editor));
    }

    public static void zeroWidthBlockSelectionAtCaretColumn(Editor editor, int startLine, int endLine) {
        int caretColumn = editor.getCaretModel().getLogicalPosition().column;
        editor.getSelectionModel().setBlockSelection(new LogicalPosition(startLine, caretColumn), new LogicalPosition(endLine, caretColumn));
    }

    public static void insertStringAtCaret(Editor editor, @NotNull String s) {
        EditorModificationUtil.insertStringAtCaret(editor, s, false, true);
    }

    public static int insertStringAtCaret(Editor editor, @NotNull String s, boolean toProcessOverwriteMode) {
        return EditorModificationUtil.insertStringAtCaret(editor, s, toProcessOverwriteMode, s.length());
    }

    public static int insertStringAtCaret(Editor editor, @NotNull String s, boolean toProcessOverwriteMode, boolean toMoveCaret) {
        return EditorModificationUtil.insertStringAtCaret(editor, s, toProcessOverwriteMode, toMoveCaret, s.length());
    }

    public static int insertStringAtCaret(Editor editor, @NotNull String s, boolean toProcessOverwriteMode, int caretShift) {
        return EditorModificationUtil.insertStringAtCaret(editor, s, toProcessOverwriteMode, true, caretShift);
    }

    public static int insertStringAtCaret(Editor editor, @NotNull String s, boolean toProcessOverwriteMode, boolean toMoveCaret, int caretShift) {
        int result = EditorModificationUtil.insertStringAtCaretNoScrolling(editor, s, toProcessOverwriteMode, toMoveCaret, caretShift);
        if (toMoveCaret) {
            EditorModificationUtil.scrollToCaret(editor);
        }
        return result;
    }

    private static int insertStringAtCaretNoScrolling(Editor editor, @NotNull String s, boolean toProcessOverwriteMode, boolean toMoveCaret, int caretShift) {
        String filler;
        editor.getSoftWrapModel().beforeDocumentChangeAtCaret();
        int oldOffset = editor.getSelectionModel().getSelectionStart();
        String string = filler = editor.getSelectionModel().hasSelection() ? "" : EditorModificationUtil.calcStringToFillVirtualSpace(editor);
        if (filler.length() > 0) {
            s = filler + s;
        }
        Document document = editor.getDocument();
        SelectionModel selectionModel = editor.getSelectionModel();
        if (editor.isInsertMode() || !toProcessOverwriteMode) {
            if (selectionModel.hasSelection()) {
                document.replaceString(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd(), s);
            } else {
                document.insertString(oldOffset, s);
            }
        } else {
            EditorModificationUtil.deleteSelectedText(editor);
            int lineNumber = editor.getCaretModel().getLogicalPosition().line;
            if (lineNumber >= document.getLineCount()) {
                return EditorModificationUtil.insertStringAtCaretNoScrolling(editor, s, false, toMoveCaret, s.length());
            }
            int endOffset = document.getLineEndOffset(lineNumber);
            document.replaceString(oldOffset, Math.min(endOffset, oldOffset + s.length()), s);
        }
        int offset = oldOffset + filler.length() + caretShift;
        if (toMoveCaret) {
            editor.getCaretModel().moveToVisualPosition(editor.offsetToVisualPosition(offset, false, true));
            selectionModel.removeSelection();
        } else if (editor.getCaretModel().getOffset() != oldOffset) {
            editor.getCaretModel().moveToOffset(oldOffset);
        }
        return offset;
    }

    public static void pasteTransferableAsBlock(Editor editor, @Nullable Supplier<? extends Transferable> producer) {
        Transferable content = EditorModificationUtil.getTransferable(producer);
        if (content == null) {
            return;
        }
        String text = EditorModificationUtil.getStringContent(content);
        if (text == null) {
            return;
        }
        int caretLine = editor.getCaretModel().getLogicalPosition().line;
        LogicalPosition caretToRestore = editor.getCaretModel().getLogicalPosition();
        String[] lines = LineTokenizer.tokenize((char[])text.toCharArray(), (boolean)false);
        int longestLineLength = 0;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            longestLineLength = Math.max(longestLineLength, line.length());
            editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(caretLine + i, caretToRestore.column));
            EditorModificationUtil.insertStringAtCaret(editor, line, false, true);
        }
        caretToRestore = new LogicalPosition(caretLine, caretToRestore.column + longestLineLength);
        editor.getCaretModel().moveToLogicalPosition(caretToRestore);
        EditorModificationUtil.zeroWidthBlockSelectionAtCaretColumn(editor, caretLine, caretLine);
    }

    @Nullable
    public static Transferable getContentsToPasteToEditor(@Nullable Producer<? extends Transferable> producer) {
        if (producer == null) {
            CopyPasteManager manager = CopyPasteManager.getInstance();
            return manager.areDataFlavorsAvailable(DataFlavor.stringFlavor) ? manager.getContents() : null;
        }
        return (Transferable)producer.produce();
    }

    @Nullable
    public static String getStringContent(@NotNull Transferable content) {
        RawText raw = RawText.fromTransferable(content);
        if (raw != null) {
            return raw.rawText;
        }
        try {
            return (String)content.getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException | IOException exception) {
            return null;
        }
    }

    private static Transferable getTransferable(Supplier<? extends Transferable> producer) {
        Transferable content = null;
        if (producer != null) {
            content = producer.get();
        } else {
            CopyPasteManager manager = CopyPasteManager.getInstance();
            if (manager.areDataFlavorsAvailable(DataFlavor.stringFlavor)) {
                content = manager.getContents();
            }
        }
        return content;
    }

    public static int calcAfterLineEnd(Editor editor) {
        Document document = editor.getDocument();
        CaretModel caretModel = editor.getCaretModel();
        LogicalPosition logicalPosition = caretModel.getLogicalPosition();
        int lineNumber = logicalPosition.line;
        int columnNumber = logicalPosition.column;
        if (lineNumber >= document.getLineCount()) {
            return columnNumber;
        }
        int caretOffset = caretModel.getOffset();
        int anchorLineEndOffset = document.getLineEndOffset(lineNumber);
        List<? extends SoftWrap> softWraps = editor.getSoftWrapModel().getSoftWrapsForLine(logicalPosition.line);
        for (SoftWrap softWrap : softWraps) {
            boolean visuallyBeforeSoftWrap;
            if (!editor.getSoftWrapModel().isVisible(softWrap)) continue;
            int softWrapOffset = softWrap.getStart();
            if (softWrapOffset == caretOffset) {
                VisualPosition position = editor.offsetToVisualPosition(caretOffset - 1);
                VisualPosition visualCaret = caretModel.getVisualPosition();
                if (position.line == visualCaret.line) {
                    return visualCaret.column - position.column - 1;
                }
            }
            if (softWrapOffset > caretOffset) {
                anchorLineEndOffset = softWrapOffset;
                break;
            }
            if (softWrapOffset != caretOffset || !(visuallyBeforeSoftWrap = caretModel.getVisualPosition().line < editor.offsetToVisualPosition((int)caretOffset).line)) continue;
            anchorLineEndOffset = softWrapOffset;
            break;
        }
        int lineEndColumnNumber = editor.offsetToLogicalPosition((int)anchorLineEndOffset).column;
        return columnNumber - lineEndColumnNumber;
    }

    public static String calcStringToFillVirtualSpace(Editor editor) {
        int afterLineEnd = EditorModificationUtil.calcAfterLineEnd(editor);
        if (afterLineEnd > 0) {
            return EditorModificationUtil.calcStringToFillVirtualSpace(editor, afterLineEnd);
        }
        return "";
    }

    public static String calcStringToFillVirtualSpace(Editor editor, int afterLineEnd) {
        boolean atLineStart;
        Project project = editor.getProject();
        StringBuilder buf = new StringBuilder();
        Document doc = editor.getDocument();
        int caretOffset = editor.getCaretModel().getOffset();
        boolean bl = atLineStart = caretOffset >= doc.getTextLength() || doc.getLineStartOffset(doc.getLineNumber(caretOffset)) == caretOffset;
        if (atLineStart && project != null) {
            String properIndent;
            int offset = editor.getCaretModel().getOffset();
            PsiDocumentManager.getInstance(project).commitDocument(doc);
            String string = properIndent = offset >= doc.getTextLength() ? "" : CodeStyleFacade.getInstance(project).getLineIndent(doc, offset);
            if (properIndent != null) {
                int tabSize = editor.getSettings().getTabSize(project);
                for (int i = 0; i < properIndent.length(); ++i) {
                    if (properIndent.charAt(i) == ' ') {
                        --afterLineEnd;
                    } else if (properIndent.charAt(i) == '\t') {
                        if (afterLineEnd < tabSize) break;
                        afterLineEnd -= tabSize;
                    }
                    buf.append(properIndent.charAt(i));
                    if (afterLineEnd != 0) {
                        continue;
                    }
                    break;
                }
            } else {
                EditorSettings editorSettings = editor.getSettings();
                boolean useTab = editorSettings.isUseTabCharacter(editor.getProject());
                if (useTab) {
                    int tabSize = editorSettings.getTabSize(project);
                    while (afterLineEnd >= tabSize) {
                        buf.append('\t');
                        afterLineEnd -= tabSize;
                    }
                }
            }
        }
        for (int i = 0; i < afterLineEnd; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }

    public static void typeInStringAtCaretHonorMultipleCarets(Editor editor, @NotNull String str) {
        EditorModificationUtil.typeInStringAtCaretHonorMultipleCarets(editor, str, true, str.length());
    }

    public static void typeInStringAtCaretHonorMultipleCarets(Editor editor, @NotNull String str, int caretShift) {
        EditorModificationUtil.typeInStringAtCaretHonorMultipleCarets(editor, str, true, caretShift);
    }

    public static void typeInStringAtCaretHonorMultipleCarets(Editor editor, @NotNull String str, boolean toProcessOverwriteMode) {
        EditorModificationUtil.typeInStringAtCaretHonorMultipleCarets(editor, str, toProcessOverwriteMode, str.length());
    }

    public static void typeInStringAtCaretHonorMultipleCarets(Editor editor, @NotNull String str, boolean toProcessOverwriteMode, int caretShift) throws ReadOnlyFragmentModificationException {
        editor.getCaretModel().runForEachCaret(__ -> EditorModificationUtil.insertStringAtCaretNoScrolling(editor, str, toProcessOverwriteMode, true, caretShift));
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    public static void moveAllCaretsRelatively(@NotNull Editor editor, int caretShift) {
        editor.getCaretModel().runForEachCaret(caret -> caret.moveToOffset(caret.getOffset() + caretShift));
    }

    public static void moveCaretRelatively(@NotNull Editor editor, int caretShift) {
        CaretModel caretModel = editor.getCaretModel();
        caretModel.moveToOffset(caretModel.getOffset() + caretShift);
    }

    public static void scrollToCaret(@NotNull Editor editor) {
        if (editor.getCaretModel().getCurrentCaret() == editor.getCaretModel().getPrimaryCaret()) {
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    @NotNull
    public static List<CaretState> calcBlockSelectionState(@NotNull Editor editor, @NotNull LogicalPosition blockStart, @NotNull LogicalPosition blockEnd) {
        int startLine = MathUtil.clamp((int)blockStart.line, (int)0, (int)(editor.getDocument().getLineCount() - 1));
        int endLine = MathUtil.clamp((int)blockEnd.line, (int)0, (int)(editor.getDocument().getLineCount() - 1));
        int step = endLine < startLine ? -1 : 1;
        int count = 1 + Math.abs(endLine - startLine);
        LinkedList<CaretState> caretStates = new LinkedList<CaretState>();
        boolean hasSelection = false;
        int line = startLine;
        int i = 0;
        while (i < count) {
            int startColumn = blockStart.column;
            int endColumn = blockEnd.column;
            int lineEndOffset = editor.getDocument().getLineEndOffset(line);
            LogicalPosition lineEndPosition = editor.offsetToLogicalPosition(lineEndOffset);
            int lineWidth = lineEndPosition.column;
            if (startColumn > lineWidth && endColumn > lineWidth && !editor.isColumnMode()) {
                LogicalPosition caretPos = new LogicalPosition(line, Math.min(startColumn, endColumn));
                caretStates.add(new CaretState(caretPos, lineEndPosition, lineEndPosition));
            } else {
                LogicalPosition startPos = new LogicalPosition(line, editor.isColumnMode() ? startColumn : Math.min(startColumn, lineWidth));
                LogicalPosition endPos = new LogicalPosition(line, editor.isColumnMode() ? endColumn : Math.min(endColumn, lineWidth));
                int startOffset = editor.logicalPositionToOffset(startPos);
                int endOffset = editor.logicalPositionToOffset(endPos);
                caretStates.add(new CaretState(endPos, startPos, endPos));
                hasSelection |= startOffset != endOffset;
            }
            ++i;
            line += step;
        }
        if (hasSelection && !editor.isColumnMode()) {
            Iterator caretStateIterator = caretStates.iterator();
            while (caretStateIterator.hasNext()) {
                CaretState state = (CaretState)caretStateIterator.next();
                if (!state.getSelectionStart().equals(state.getSelectionEnd())) continue;
                caretStateIterator.remove();
            }
        }
        return caretStates;
    }

    public static boolean requestWriting(@NotNull Editor editor) {
        FileDocumentManager.WriteAccessStatus writeAccess = FileDocumentManager.getInstance().requestWritingStatus(editor.getDocument(), editor.getProject());
        if (!writeAccess.hasWriteAccess()) {
            HintManager.getInstance().showInformationHint(editor, writeAccess.getReadOnlyMessage());
            return false;
        }
        return true;
    }

    public static boolean checkModificationAllowed(Editor editor) {
        if (!editor.isViewer()) {
            return true;
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment() || editor instanceof TextComponentEditor) {
            return false;
        }
        ReadOnlyHint hint = (ReadOnlyHint)ObjectUtils.chooseNotNull((Object)READ_ONLY_VIEW_HINT_KEY.get((UserDataHolder)editor), (Object)new ReadOnlyHint(EditorBundle.message("editing.viewer.hint", new Object[0]), null));
        HintManager.getInstance().showInformationHint(editor, hint.message, hint.linkListener);
        return false;
    }

    public static void setReadOnlyHint(@NotNull Editor editor, @Nullable String message) {
        EditorModificationUtil.setReadOnlyHint(editor, message, null);
    }

    public static void setReadOnlyHint(@NotNull Editor editor, @Nullable String message, @Nullable HyperlinkListener linkListener) {
        editor.putUserData(READ_ONLY_VIEW_HINT_KEY, message != null ? new ReadOnlyHint(message, linkListener) : null);
    }

    private static class ReadOnlyHint {
        @NotNull
        public final String message;
        @Nullable
        public final HyperlinkListener linkListener;

        private ReadOnlyHint(@NotNull String message, @Nullable HyperlinkListener linkListener) {
            this.message = message;
            this.linkListener = linkListener;
        }
    }
}

