/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorFactory {
    public static EditorFactory getInstance() {
        return (EditorFactory)ApplicationManager.getApplication().getService(EditorFactory.class);
    }

    @NotNull
    public abstract Document createDocument(@NotNull CharSequence var1);

    @NotNull
    public abstract Document createDocument(char @NotNull [] var1);

    public abstract Editor createEditor(@NotNull Document var1);

    public abstract Editor createViewer(@NotNull Document var1);

    public abstract Editor createEditor(@NotNull Document var1, @Nullable Project var2);

    public abstract Editor createEditor(@NotNull Document var1, @Nullable Project var2, @NotNull EditorKind var3);

    public abstract Editor createEditor(@NotNull Document var1, Project var2, @NotNull FileType var3, boolean var4);

    public abstract Editor createEditor(@NotNull Document var1, Project var2, @NotNull VirtualFile var3, boolean var4);

    public abstract Editor createEditor(@NotNull Document var1, Project var2, @NotNull VirtualFile var3, boolean var4, @NotNull EditorKind var5);

    public abstract Editor createViewer(@NotNull Document var1, @Nullable Project var2);

    public abstract Editor createViewer(@NotNull Document var1, @Nullable Project var2, @NotNull EditorKind var3);

    public abstract void releaseEditor(@NotNull Editor var1);

    @NotNull
    public abstract Stream<Editor> editors(@NotNull Document var1, @Nullable Project var2);

    @NotNull
    public final Stream<Editor> editors(@NotNull Document document) {
        return this.editors(document, null);
    }

    public final Editor @NotNull [] getEditors(@NotNull Document document, @Nullable Project project) {
        return (Editor[])this.editors(document, project).toArray(Editor[]::new);
    }

    public final Editor @NotNull [] getEditors(@NotNull Document document) {
        return this.getEditors(document, null);
    }

    public abstract Editor @NotNull [] getAllEditors();

    @Deprecated
    public abstract void addEditorFactoryListener(@NotNull EditorFactoryListener var1);

    public abstract void addEditorFactoryListener(@NotNull EditorFactoryListener var1, @NotNull Disposable var2);

    @Deprecated
    public abstract void removeEditorFactoryListener(@NotNull EditorFactoryListener var1);

    @NotNull
    public abstract EditorEventMulticaster getEventMulticaster();

    public abstract void refreshAllEditors();
}

