/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandEvent
extends EventObject {
    private final Runnable myCommand;
    private final Project myProject;
    private final String myCommandName;
    private final Object myCommandGroupId;
    private final UndoConfirmationPolicy myUndoConfirmationPolicy;
    private final boolean myShouldRecordActionForActiveDocument;
    private final Document myDocument;

    public CommandEvent(@NotNull CommandProcessor processor, @NotNull Runnable command, Project project, @NotNull UndoConfirmationPolicy undoConfirmationPolicy) {
        this(processor, command, null, null, project, undoConfirmationPolicy);
    }

    public CommandEvent(@NotNull CommandProcessor processor, @NotNull Runnable command, String commandName, Object commandGroupId, Project project, @NotNull UndoConfirmationPolicy undoConfirmationPolicy) {
        this(processor, command, commandName, commandGroupId, project, undoConfirmationPolicy, true, null);
    }

    public CommandEvent(@NotNull CommandProcessor processor, @NotNull Runnable command, String commandName, Object commandGroupId, Project project, @NotNull UndoConfirmationPolicy undoConfirmationPolicy, boolean shouldRecordActionForActiveDocument, Document document) {
        super(processor);
        this.myCommand = command;
        this.myCommandName = commandName;
        this.myCommandGroupId = commandGroupId;
        this.myProject = project;
        this.myUndoConfirmationPolicy = undoConfirmationPolicy;
        this.myShouldRecordActionForActiveDocument = shouldRecordActionForActiveDocument;
        this.myDocument = document;
    }

    @NotNull
    public CommandProcessor getCommandProcessor() {
        return (CommandProcessor)this.getSource();
    }

    @NotNull
    public Runnable getCommand() {
        return this.myCommand;
    }

    public Project getProject() {
        return this.myProject;
    }

    public String getCommandName() {
        return this.myCommandName;
    }

    public Object getCommandGroupId() {
        return this.myCommandGroupId;
    }

    @NotNull
    public UndoConfirmationPolicy getUndoConfirmationPolicy() {
        return this.myUndoConfirmationPolicy;
    }

    public boolean shouldRecordActionForOriginalDocument() {
        return this.myShouldRecordActionForActiveDocument;
    }

    @Nullable
    public Document getDocument() {
        return this.myDocument;
    }
}

