/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Notifications {
    public static final Topic<Notifications> TOPIC = Topic.create((String)"Notifications", Notifications.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.NONE);
    public static final String SYSTEM_MESSAGES_GROUP_ID = "System Messages";

    default public void notify(@NotNull Notification notification) {
    }

    default public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType defaultDisplayType) {
    }

    default public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType defaultDisplayType, boolean shouldLog) {
    }

    default public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType defaultDisplayType, boolean shouldLog, boolean shouldReadAloud) {
    }

    public static final class Bus {
        @Deprecated
        public static void register(@NotNull String group_id, @NotNull NotificationDisplayType defaultDisplayType) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            SwingUtilities.invokeLater(() -> {
                Application app = ApplicationManager.getApplication();
                if (!app.isDisposed()) {
                    ((Notifications)app.getMessageBus().syncPublisher(TOPIC)).register(group_id, defaultDisplayType);
                }
            });
        }

        public static void notify(@NotNull Notification notification) {
            Bus.notify(notification, null);
        }

        public static void notify(@NotNull Notification notification, @Nullable Project project) {
            notification.assertHasTitleOrContent();
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                Bus.doNotify(notification, project);
            } else {
                UIUtil.invokeLaterIfNeeded(() -> Bus.doNotify(notification, project));
            }
        }

        private static void doNotify(Notification notification, @Nullable Project project) {
            if (project != null && !project.isDisposed() && !project.isDefault()) {
                ((Notifications)project.getMessageBus().syncPublisher(TOPIC)).notify(notification);
            } else {
                Application app = ApplicationManager.getApplication();
                if (!app.isDisposed()) {
                    ((Notifications)app.getMessageBus().syncPublisher(TOPIC)).notify(notification);
                }
            }
        }

        @ApiStatus.Experimental
        public static void notifyAndHide(@NotNull Notification notification) {
            Bus.notifyAndHide(notification, null);
        }

        @ApiStatus.Experimental
        public static void notifyAndHide(@NotNull Notification notification, @Nullable Project project) {
            Bus.notify(notification);
            Alarm alarm = new Alarm((Disposable)(project == null ? ApplicationManager.getApplication() : project));
            alarm.addRequest(() -> {
                notification.expire();
                Disposer.dispose((Disposable)alarm);
            }, 5000);
        }
    }
}

