/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.DependentLanguage;
import com.intellij.lang.InjectableLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.MetaLanguage;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LanguageUtil {
    public static final Comparator<Language> LANGUAGE_COMPARATOR = (o1, o2) -> StringUtil.naturalCompare((String)o1.getDisplayName(), (String)o2.getDisplayName());
    private static final Key<Collection<MetaLanguage>> MATCHING_LANGUAGES = Key.create((String)"language.matching");

    private LanguageUtil() {
    }

    @Nullable
    public static Language getLanguageForPsi(@NotNull Project project, @Nullable VirtualFile file) {
        Language language = LanguageUtil.getFileLanguage(file);
        if (language == null) {
            return null;
        }
        return LanguageSubstitutors.getInstance().substituteLanguage(language, file, project);
    }

    @Nullable
    public static Language getFileLanguage(@Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        Language l = file instanceof LightVirtualFile ? ((LightVirtualFile)file).getLanguage() : null;
        return l != null ? l : LanguageUtil.getFileTypeLanguage(file.getFileType());
    }

    @Nullable
    public static Language getFileTypeLanguage(@Nullable FileType fileType) {
        return fileType instanceof LanguageFileType ? ((LanguageFileType)fileType).getLanguage() : null;
    }

    @Nullable
    public static FileType getLanguageFileType(@Nullable Language language) {
        return language == null ? null : language.getAssociatedFileType();
    }

    public static ParserDefinition.SpaceRequirements canStickTokensTogetherByLexer(ASTNode left, ASTNode right, Lexer lexer) {
        String textStr = left.getText() + right.getText();
        lexer.start(textStr, 0, textStr.length());
        if (lexer.getTokenType() != left.getElementType()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        if (lexer.getTokenEnd() != left.getTextLength()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        lexer.advance();
        if (lexer.getTokenEnd() != textStr.length()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        if (lexer.getTokenType() != right.getElementType()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        return ParserDefinition.SpaceRequirements.MAY;
    }

    @NotNull
    public static Set<Language> getAllDerivedLanguages(@NotNull Language base) {
        HashSet<Language> result = new HashSet<Language>();
        LanguageUtil.getAllDerivedLanguages(base, result);
        return result;
    }

    private static void getAllDerivedLanguages(Language base, Set<? super Language> result) {
        result.add(base);
        for (Language dialect : base.getDialects()) {
            LanguageUtil.getAllDerivedLanguages(dialect, result);
        }
    }

    public static boolean isInTemplateLanguageFile(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        Language language = psiFile.getViewProvider().getBaseLanguage();
        return language instanceof TemplateLanguage;
    }

    public static boolean isInjectableLanguage(@NotNull Language language) {
        if (language == Language.ANY) {
            return false;
        }
        if (language.getID().startsWith("$")) {
            return false;
        }
        if (language instanceof InjectableLanguage) {
            return true;
        }
        if (language instanceof TemplateLanguage || language instanceof DependentLanguage) {
            return false;
        }
        return LanguageParserDefinitions.INSTANCE.forLanguage(language) != null;
    }

    public static boolean isFileLanguage(@NotNull Language language) {
        if (language instanceof DependentLanguage || language instanceof InjectableLanguage) {
            return false;
        }
        if (LanguageParserDefinitions.INSTANCE.forLanguage(language) == null) {
            return false;
        }
        LanguageFileType type = language.getAssociatedFileType();
        if (type == null || StringUtil.isEmpty((String)type.getDefaultExtension())) {
            return false;
        }
        return StringUtil.isNotEmpty((String)type.getDefaultExtension());
    }

    @NotNull
    public static List<Language> getFileLanguages() {
        LanguageParserDefinitions.INSTANCE.ensureValuesLoaded();
        ArrayList<Language> result = new ArrayList<Language>();
        for (Language language : Language.getRegisteredLanguages()) {
            if (!LanguageUtil.isFileLanguage(language)) continue;
            result.add(language);
        }
        result.sort(LANGUAGE_COMPARATOR);
        return result;
    }

    @NotNull
    public static Language getRootLanguage(@NotNull PsiElement element) {
        Language language;
        PsiFile containingFile = element.getContainingFile();
        FileViewProvider provider = containingFile.getViewProvider();
        Set<Language> languages = provider.getLanguages();
        if (languages.size() > 1 && languages.contains((Object)(language = containingFile.getLanguage()))) {
            return language;
        }
        return provider.getBaseLanguage();
    }

    @NotNull
    static Collection<MetaLanguage> matchingMetaLanguages(@NotNull Language language) {
        THashSet result;
        Collection cached = (Collection)language.getUserData(MATCHING_LANGUAGES);
        if (cached != null) {
            return cached;
        }
        if (!ApplicationManager.getApplication().getExtensionArea().hasExtensionPoint(MetaLanguage.EP_NAME)) {
            return Collections.emptyList();
        }
        if (language instanceof MetaLanguage) {
            result = Collections.emptySet();
        } else {
            result = new THashSet();
            MetaLanguage.EP_NAME.forEachExtensionSafe(arg_0 -> LanguageUtil.lambda$matchingMetaLanguages$1(language, (Set)result, arg_0));
        }
        return (Collection)language.putUserDataIfAbsent(MATCHING_LANGUAGES, result);
    }

    static void clearMatchingMetaLanguages(@NotNull Language language) {
        language.putUserData(MATCHING_LANGUAGES, null);
    }

    @NotNull
    static JBIterable<Language> hierarchy(@NotNull Language language) {
        return JBIterable.generate((Object)((Object)language), Language::getBaseLanguage);
    }

    private static /* synthetic */ void lambda$matchingMetaLanguages$1(Language language, Set result, MetaLanguage metaLanguage) {
        if (metaLanguage.matchesLanguage(language)) {
            result.add(metaLanguage);
        }
    }
}

