/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.util.CharTable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.AbstractList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FCTSBackedLighterAST
extends LighterAST {
    @NotNull
    private final FlyweightCapableTreeStructure<LighterASTNode> myTreeStructure;

    public FCTSBackedLighterAST(@NotNull CharTable charTable, @NotNull FlyweightCapableTreeStructure<LighterASTNode> treeStructure) {
        super(charTable);
        this.myTreeStructure = treeStructure;
    }

    @Override
    @NotNull
    public LighterASTNode getRoot() {
        return (LighterASTNode)this.myTreeStructure.getRoot();
    }

    @Override
    public LighterASTNode getParent(@NotNull LighterASTNode node) {
        return (LighterASTNode)this.myTreeStructure.getParent((Object)node);
    }

    @Override
    @NotNull
    public List<LighterASTNode> getChildren(@NotNull LighterASTNode parent) {
        Ref into = new Ref();
        int numKids = this.myTreeStructure.getChildren((Object)parent, into);
        if (numKids == 0) {
            return ContainerUtil.emptyList();
        }
        LighterASTNode[] elements = (LighterASTNode[])into.get();
        assert (elements != null) : this.myTreeStructure + " (" + parent + ")";
        return new LighterASTNodeList(numKids, elements);
    }

    private static class LighterASTNodeList
    extends AbstractList<LighterASTNode> {
        private final int mySize;
        private final LighterASTNode[] myElements;

        LighterASTNodeList(int size, LighterASTNode[] elements) {
            this.mySize = size;
            this.myElements = elements;
        }

        @Override
        public LighterASTNode get(int index) {
            if (index < 0 || index >= this.mySize) {
                throw new IndexOutOfBoundsException("index:" + index + " size:" + this.mySize);
            }
            return this.myElements[index];
        }

        @Override
        public int size() {
            return this.mySize;
        }
    }
}

