/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.errorTreeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ErrorTreeElementKind {
    INFO("INFO", IdeBundle.message("errortree.information", new Object[0]), AllIcons.General.Information),
    ERROR("ERROR", IdeBundle.message("errortree.error", new Object[0]), AllIcons.General.Error),
    WARNING("WARNING", IdeBundle.message("errortree.warning", new Object[0]), AllIcons.General.Warning),
    NOTE("NOTE", IdeBundle.message("errortree.note", new Object[0]), AllIcons.General.Note),
    GENERIC("GENERIC", "", null);

    private final String myText;
    private final String myPresentableText;
    private final Icon myIcon;

    private ErrorTreeElementKind(@Nullable String text, String presentableText, Icon icon) {
        this.myText = text;
        this.myPresentableText = presentableText;
        this.myIcon = icon;
    }

    public String toString() {
        return this.myText;
    }

    public String getPresentableText() {
        return this.myPresentableText;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @NotNull
    public static ErrorTreeElementKind convertMessageFromCompilerErrorType(int type) {
        switch (type) {
            case 4: {
                return ERROR;
            }
            case 5: {
                return WARNING;
            }
            case 3: {
                return INFO;
            }
            case 2: {
                return INFO;
            }
            case 1: {
                return GENERIC;
            }
            case 6: {
                return NOTE;
            }
        }
        return GENERIC;
    }
}

