/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.customization;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.IdeUrlTrackingParametersProvider;
import com.intellij.openapi.diagnostic.Logger;
import java.net.URISyntaxException;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;

public final class UtmIdeUrlTrackingParametersProvider
extends IdeUrlTrackingParametersProvider {
    private static final Logger LOG = Logger.getInstance(UtmIdeUrlTrackingParametersProvider.class);

    @Override
    @NotNull
    public String augmentUrl(@NotNull String originalUrl) {
        return this.augmentUrl(originalUrl, ApplicationInfo.getInstance().getBuild().getProductCode());
    }

    @Override
    @NotNull
    public String augmentUrl(@NotNull String originalUrl, String campaignId) {
        try {
            ApplicationInfo info = ApplicationInfo.getInstance();
            String productVersion = info.getMajorVersion() + "." + info.getMinorVersionMainPart();
            return new URIBuilder(originalUrl).addParameter("utm_source", "product").addParameter("utm_medium", "link").addParameter("utm_campaign", campaignId).addParameter("utm_content", productVersion).build().toString();
        }
        catch (URISyntaxException e) {
            LOG.warn(originalUrl, (Throwable)e);
            return originalUrl;
        }
    }
}

