/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ui.CommandLinePanel;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.options.CompositeSettingsBuilder;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.components.DropDownLink;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.WrapLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

public class FragmentedSettingsBuilder<Settings>
implements CompositeSettingsBuilder<Settings> {
    static final int TOP_INSET = 5;
    static final int GROUP_INSET = 20;
    private final JPanel myPanel = new JPanel(new GridBagLayout());
    private final GridBagConstraints myConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, (Insets)JBUI.insetsTop((int)5), 0, 0);
    private final Collection<SettingsEditorFragment<Settings, ?>> myFragments;
    private final SettingsEditorFragment<Settings, ?> myMain;
    private DropDownLink<String> myLinkLabel;

    FragmentedSettingsBuilder(Collection<SettingsEditorFragment<Settings, ?>> fragments, SettingsEditorFragment<Settings, ?> main) {
        this.myFragments = fragments;
        this.myMain = main;
    }

    @Override
    public Collection<SettingsEditor<Settings>> getEditors() {
        return new ArrayList<SettingsEditor<Settings>>(this.myFragments);
    }

    @Override
    public JComponent createCompoundEditor() {
        if (this.myMain == null) {
            this.myPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
            this.addLine(new JSeparator());
        }
        ArrayList fragments = new ArrayList(this.myFragments);
        List subGroups = ContainerUtil.filter(fragments, fragment -> !fragment.getChildren().isEmpty());
        fragments.removeAll(subGroups);
        fragments.sort(Comparator.comparingInt(SettingsEditorFragment::getCommandLinePosition));
        this.buildBeforeRun(fragments);
        this.addLine(this.buildHeader(fragments));
        if (this.myMain != null && this.myMain.component() != null) {
            this.addLine((Component)this.myMain.component());
        }
        this.buildCommandLinePanel(fragments);
        JPanel tagsPanel = new JPanel((LayoutManager)new WrapLayout(3, 0, 0));
        for (SettingsEditorFragment settingsEditorFragment : fragments) {
            JComponent component2 = settingsEditorFragment.getComponent();
            if (settingsEditorFragment.isTag()) {
                tagsPanel.add(component2);
                continue;
            }
            this.addLine(component2);
            if (settingsEditorFragment.getHintComponent() == null) continue;
            this.addLine(settingsEditorFragment.getHintComponent(), 0, FragmentedSettingsBuilder.getLeftInset(component2), 5);
        }
        this.addLine(tagsPanel, 15, -FragmentedSettingsBuilder.getLeftInset((JComponent)tagsPanel.getComponent(0)), 0);
        for (SettingsEditorFragment settingsEditorFragment : subGroups) {
            this.addLine(settingsEditorFragment.getComponent());
        }
        if (this.myMain == null) {
            this.myConstraints.weighty = 1.0;
            this.myPanel.add((Component)new JPanel(), this.myConstraints);
        }
        List panels = Arrays.stream(this.myPanel.getComponents()).filter(component -> component instanceof PanelWithAnchor).map(component -> (PanelWithAnchor)component).collect(Collectors.toList());
        UIUtil.mergeComponentsWithAnchor(panels);
        return this.myPanel;
    }

    private void addLine(Component component, int top, int left, int bottom) {
        this.myConstraints.insets = JBUI.insets((int)top, (int)left, (int)bottom, (int)0);
        this.myPanel.add(component, this.myConstraints.clone());
        ++this.myConstraints.gridy;
        this.myConstraints.insets = JBUI.insetsTop((int)top);
    }

    private void addLine(Component component) {
        this.addLine(component, 5, 0, 0);
    }

    private void buildBeforeRun(Collection<SettingsEditorFragment<Settings, ?>> fragments) {
        SettingsEditorFragment beforeRun = (SettingsEditorFragment)ContainerUtil.find(fragments, fragment -> fragment.getCommandLinePosition() == -2);
        if (beforeRun != null) {
            this.addLine(beforeRun.getComponent(), 5, 0, 10);
            fragments.remove(beforeRun);
        }
    }

    private JComponent buildHeader(Collection<SettingsEditorFragment<Settings, ?>> fragments) {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setBorder((Border)JBUI.Borders.empty((int)5, (int)0));
        SettingsEditorFragment label = (SettingsEditorFragment)ContainerUtil.find(fragments, fragment -> fragment.getCommandLinePosition() == -1);
        if (label != null) {
            panel2.add((Component)label.getComponent(), "West");
            fragments.remove(label);
        }
        if (this.myMain != null) {
            panel2.add((Component)SeparatorFactory.createSeparator(this.myMain.getGroup(), null), "Center");
        }
        this.myLinkLabel = new DropDownLink<String>(OptionsBundle.message(this.myMain == null ? "settings.editor.modify.options" : "settings.editor.modify", new Object[0]), (Function1<DropDownLink<String>, JBPopup>)((Function1)link -> this.showOptions()));
        this.myLinkLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        panel2.add(this.myLinkLabel, "East");
        return panel2;
    }

    private JBPopup showOptions() {
        List fragments = ContainerUtil.filter(this.myFragments, fragment -> fragment.getName() != null);
        DefaultActionGroup actionGroup = this.buildGroup(fragments);
        DataContext dataContext = DataManager.getInstance().getDataContext(this.myLinkLabel);
        return JBPopupFactory.getInstance().createActionGroupPopup(IdeBundle.message("popup.title.add.run.options", new Object[0]), actionGroup, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
    }

    @NotNull
    private DefaultActionGroup buildGroup(List<SettingsEditorFragment<Settings, ?>> fragments) {
        fragments.sort(Comparator.comparingInt(SettingsEditorFragment::getMenuPosition));
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        String group = null;
        for (SettingsEditorFragment<Settings, ?> fragment : fragments) {
            if (!Objects.equals(group, fragment.getGroup())) {
                group = fragment.getGroup();
                actionGroup.add(new Separator(group));
            }
            actionGroup.add(new ToggleFragmentAction(fragment));
            List<SettingsEditorFragment<Settings, ?>> children = fragment.getChildren();
            if (children.isEmpty()) continue;
            DefaultActionGroup childGroup = this.buildGroup(children);
            childGroup.setPopup(true);
            childGroup.getTemplatePresentation().setText(fragment.getChildrenGroupName());
            actionGroup.add(childGroup);
        }
        return actionGroup;
    }

    private void buildCommandLinePanel(Collection<SettingsEditorFragment<Settings, ?>> fragments) {
        List list = ContainerUtil.filter(fragments, fragment -> fragment.getCommandLinePosition() > 0);
        if (list.isEmpty()) {
            return;
        }
        fragments.removeAll(list);
        CommandLinePanel panel2 = new CommandLinePanel(list);
        for (SettingsEditorFragment fragment2 : list) {
            fragment2.addSettingsEditorListener(editor -> panel2.rebuildRows());
        }
        this.addLine(panel2, 5, -panel2.getLeftInset(), 10);
    }

    static int getLeftInset(JComponent component) {
        if (component.getBorder() != null) {
            return component.getBorder().getBorderInsets((Component)component).left;
        }
        JComponent wrapped = (JComponent)ContainerUtil.find((Object[])component.getComponents(), co -> co.isVisible());
        return wrapped != null ? FragmentedSettingsBuilder.getLeftInset(wrapped) : 0;
    }

    private static class ToggleFragmentAction
    extends ToggleAction {
        private final SettingsEditorFragment<?, ?> myFragment;

        private ToggleFragmentAction(SettingsEditorFragment<?, ?> fragment) {
            super(fragment.getName());
            this.myFragment = fragment;
        }

        @Override
        public boolean isSelected(@NotNull AnActionEvent e) {
            return this.myFragment.isSelected();
        }

        @Override
        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            this.myFragment.toggle(state);
        }
    }
}

