/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class TargetedCommandLine {
    @NotNull
    private final TargetValue<String> myExePath;
    @NotNull
    private final TargetValue<String> myWorkingDirectory;
    @NotNull
    private final TargetValue<String> myInputFilePath;
    @NotNull
    private final Charset myCharset;
    @NotNull
    private final List<TargetValue<String>> myParameters;
    @NotNull
    private final Map<String, TargetValue<String>> myEnvironment;

    public TargetedCommandLine(@NotNull TargetValue<String> exePath, @NotNull TargetValue<String> workingDirectory, @NotNull TargetValue<String> inputFilePath, @NotNull Charset charset, @NotNull List<TargetValue<String>> parameters, @NotNull Map<String, TargetValue<String>> environment) {
        this.myExePath = exePath;
        this.myWorkingDirectory = workingDirectory;
        this.myInputFilePath = inputFilePath;
        this.myCharset = charset;
        this.myParameters = parameters;
        this.myEnvironment = environment;
    }

    public String getCommandPresentation(@NotNull TargetEnvironment target) throws ExecutionException {
        String exePath = TargetedCommandLine.resolvePromise(this.myExePath.getTargetValue(), "exe path");
        if (exePath == null) {
            throw new ExecutionException("Resolved value for exe path is null");
        }
        ArrayList<String> parameters = new ArrayList<String>();
        for (TargetValue<String> parameter : this.myParameters) {
            parameters.add(TargetedCommandLine.resolvePromise(parameter.getTargetValue(), "parameter"));
        }
        return StringUtil.join((Collection)CommandLineUtil.toCommandLine((String)ParametersListUtil.escape((CharSequence)exePath), parameters, (Platform)target.getRemotePlatform().getPlatform()), (String)" ");
    }

    public List<String> collectCommandsSynchronously() throws ExecutionException {
        try {
            return this.collectCommands().blockingGet(0);
        }
        catch (java.util.concurrent.ExecutionException | TimeoutException e) {
            throw new ExecutionException("Couldn't collect commands", (Throwable)e);
        }
    }

    @NotNull
    public @NotNull Promise<@NotNull List<@NotNull String>> collectCommands() {
        ArrayList<Promise<Object>> promises = new ArrayList<Promise<Object>>(this.myParameters.size() + 1);
        promises.add(this.myExePath.getTargetValue().then(command -> {
            if (command == null) {
                throw new IllegalStateException("Resolved value for exe path is null");
            }
            return command;
        }));
        for (TargetValue<String> parameter : this.myParameters) {
            promises.add(parameter.getTargetValue());
        }
        return Promises.collectResults(promises);
    }

    @Nullable
    public String getWorkingDirectory() throws ExecutionException {
        return TargetedCommandLine.resolvePromise(this.myWorkingDirectory.getTargetValue(), "working directory");
    }

    @Nullable
    public String getInputFilePath() throws ExecutionException {
        return TargetedCommandLine.resolvePromise(this.myInputFilePath.getTargetValue(), "input file path");
    }

    @NotNull
    public Map<String, String> getEnvironmentVariables() throws ExecutionException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, TargetValue<String>> e : this.myEnvironment.entrySet()) {
            result.put(e.getKey(), TargetedCommandLine.resolvePromise(e.getValue().getTargetValue(), "environment variable " + e.getKey()));
        }
        return result;
    }

    @NotNull
    public Charset getCharset() {
        return this.myCharset;
    }

    @Nullable
    private static String resolvePromise(@NotNull Promise<String> promise, @NotNull String debugName) throws ExecutionException {
        try {
            return promise.blockingGet(0);
        }
        catch (java.util.concurrent.ExecutionException | TimeoutException e) {
            throw new ExecutionException("Couldn't resolve promise for " + debugName, (Throwable)e);
        }
    }
}

