/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="Push.Settings", storages={@Storage(value="$WORKSPACE_FILE$")})
public class PushSettings
implements PersistentStateComponent<State> {
    private State myState = new State();

    @Override
    @Nullable
    public State getState() {
        return this.myState;
    }

    @Override
    public void loadState(@NotNull State state) {
        this.myState = state;
    }

    public boolean containsForcePushTarget(@NotNull String remote, @NotNull String branch) {
        return ContainerUtil.exists(this.myState.FORCE_PUSH_TARGETS, info -> info.targetRemoteName.equals(remote) && info.targetBranchName.equals(branch));
    }

    public void addForcePushTarget(@NotNull String targetRemote, @NotNull String targetBranch) {
        List<ForcePushTargetInfo> targets = this.myState.FORCE_PUSH_TARGETS;
        if (!this.containsForcePushTarget(targetRemote, targetBranch)) {
            targets.add(new ForcePushTargetInfo(targetRemote, targetBranch));
            this.myState.FORCE_PUSH_TARGETS = targets;
        }
    }

    public boolean getShowDetailsInPushDialog() {
        return this.myState.SHOW_DETAILS_PANEL;
    }

    public void setShowDetailsInPushDialog(boolean value) {
        this.myState.SHOW_DETAILS_PANEL = value;
    }

    @Tag(value="force-push-target")
    private static class ForcePushTargetInfo {
        @Attribute(value="remote-path")
        public String targetRemoteName;
        @Attribute(value="branch")
        public String targetBranchName;

        ForcePushTargetInfo() {
            this("", "");
        }

        ForcePushTargetInfo(@NotNull String targetRemote, @NotNull String targetBranch) {
            this.targetRemoteName = targetRemote;
            this.targetBranchName = targetBranch;
        }
    }

    public static class State {
        @XCollection(propertyElementName="force-push-targets")
        public List<ForcePushTargetInfo> FORCE_PUSH_TARGETS = new ArrayList<ForcePushTargetInfo>();
        public boolean SHOW_DETAILS_PANEL = true;
    }
}

