/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.AbstractBundle;
import com.intellij.DynamicBundle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.diagnostic.PluginException;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.ResourceBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionEP
extends LanguageExtensionPoint<InspectionProfileEntry>
implements InspectionProfileEntry.DefaultNameProvider {
    private static final Logger LOG = Logger.getInstance(InspectionEP.class);
    public static final ExtensionPointName<InspectionEP> GLOBAL_INSPECTION = new ExtensionPointName("com.intellij.globalInspection");
    @Attribute(value="shortName")
    public String shortName;
    @Attribute(value="key")
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String key;
    @Attribute(value="bundle")
    public String bundle;
    @Attribute(value="displayName")
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String displayName;
    @Attribute(value="groupKey")
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String groupKey;
    @Attribute(value="groupBundle")
    public String groupBundle;
    @Attribute(value="groupName")
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String groupDisplayName;
    @Attribute(value="groupPath")
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String groupPath;
    @Attribute(value="enabledByDefault")
    public boolean enabledByDefault;
    @Attribute(value="applyToDialects")
    public boolean applyToDialects = true;
    @Attribute(value="cleanupTool")
    public boolean cleanupTool;
    @Attribute(value="level")
    public String level;
    @Attribute(value="hasStaticDescription")
    public boolean hasStaticDescription;
    @Attribute(value="presentation")
    public String presentation;
    @Attribute(value="isInternal")
    public boolean isInternal;

    @NonNls
    @NotNull
    public String getShortName() {
        if (this.implementationClass == null) {
            throw new IllegalArgumentException(this.toString());
        }
        return this.shortName != null ? this.shortName : InspectionProfileEntry.getShortName(StringUtil.getShortName((String)this.implementationClass));
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    public String getDisplayName() {
        return this.displayName != null ? this.displayName : this.getLocalizedString(this.bundle, this.key);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    public String getGroupDisplayName() {
        return this.groupDisplayName != null ? this.groupDisplayName : this.getLocalizedString(this.groupBundle, this.groupKey);
    }

    @Override
    @Nullable
    public String getGroupKey() {
        return this.groupKey;
    }

    protected InspectionEP() {
    }

    @NonInjectable
    public InspectionEP(@NotNull String implementationClass, @NotNull PluginDescriptor pluginDescriptor) {
        this.implementationClass = implementationClass;
        this.setPluginDescriptor(pluginDescriptor);
    }

    public String @Nullable [] getGroupPath() {
        String name = this.getGroupDisplayName();
        if (name == null) {
            return null;
        }
        if (this.groupPath == null) {
            return new String[]{name.isEmpty() ? InspectionProfileEntry.getGeneralGroupName() : name};
        }
        return (String[])ArrayUtil.append((Object[])this.groupPath.split(","), (Object)name);
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        if (this.level == null) {
            return HighlightDisplayLevel.WARNING;
        }
        HighlightDisplayLevel displayLevel = HighlightDisplayLevel.find(this.level);
        if (displayLevel == null) {
            LOG.error((Throwable)new PluginException("Can't find highlight display level: " + this.level + "; registered for: " + this.implementationClass + "; and short name: " + this.shortName, this.getPluginDescriptor().getPluginId()));
            return HighlightDisplayLevel.WARNING;
        }
        return displayLevel;
    }

    @Nullable
    private String getLocalizedString(@Nullable String bundleName, String key) {
        String baseName;
        String string = bundleName != null ? bundleName : (baseName = this.bundle == null ? this.getPluginDescriptor().getResourceBundleBaseName() : this.bundle);
        if (baseName == null || key == null) {
            if (bundleName != null) {
                LOG.warn(this.implementationClass);
            }
            return null;
        }
        ResourceBundle resourceBundle = DynamicBundle.INSTANCE.getResourceBundle(baseName, this.getPluginDescriptor().getPluginClassLoader());
        return AbstractBundle.message((ResourceBundle)resourceBundle, (String)key, (Object[])new Object[0]);
    }

    @NotNull
    public InspectionProfileEntry instantiateTool() {
        InspectionProfileEntry entry = (InspectionProfileEntry)this.createInstance(ApplicationManager.getApplication());
        entry.myNameProvider = this;
        return entry;
    }

    @Override
    public String getDefaultShortName() {
        return this.getShortName();
    }

    @Override
    public String getDefaultDisplayName() {
        return this.getDisplayName();
    }

    @Override
    public String getDefaultGroupDisplayName() {
        return this.getGroupDisplayName();
    }

    public String toString() {
        return "InspectionEP{shortName='" + this.shortName + '\'' + ", key='" + this.key + '\'' + ", bundle='" + this.bundle + '\'' + ", displayName='" + this.displayName + '\'' + ", groupKey='" + this.groupKey + '\'' + ", groupBundle='" + this.groupBundle + '\'' + ", groupDisplayName='" + this.groupDisplayName + '\'' + ", groupPath='" + this.groupPath + '\'' + ", enabledByDefault=" + this.enabledByDefault + ", applyToDialects=" + this.applyToDialects + ", cleanupTool=" + this.cleanupTool + ", level='" + this.level + '\'' + ", hasStaticDescription=" + this.hasStaticDescription + ", presentation='" + this.presentation + '\'' + ", isInternal=" + this.isInternal + ", getImplementationClassName()='" + this.getImplementationClassName() + "', language=" + this.language + '}';
    }
}

