/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.codeInsight.template.EverywhereContextType;
import com.intellij.codeInsight.template.TemplateActionContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.VolatileNullableLazyValue;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TemplateContextType {
    public static final ExtensionPointName<TemplateContextType> EP_NAME = ExtensionPointName.create((String)"com.intellij.liveTemplateContext");
    @NotNull
    private final String myContextId;
    @NotNull
    private final String myPresentableName;
    private final VolatileNullableLazyValue<TemplateContextType> myBaseContextType;

    protected TemplateContextType(@NotNull @NonNls String id, @NlsContexts.Label @NotNull String presentableName) {
        this(id, presentableName, EverywhereContextType.class);
    }

    protected TemplateContextType(@NotNull @NonNls String id, @NlsContexts.Label @NotNull String presentableName, @Nullable Class<? extends TemplateContextType> baseContextType) {
        this.myContextId = id;
        this.myPresentableName = presentableName;
        this.myBaseContextType = VolatileNullableLazyValue.createValue(() -> baseContextType == null ? null : (TemplateContextType)EP_NAME.findExtension(baseContextType));
    }

    @NotNull
    public String getPresentableName() {
        return this.myPresentableName;
    }

    @NotNull
    public String getContextId() {
        return this.myContextId;
    }

    @Deprecated
    public boolean isInContext(@NotNull PsiFile file, int offset) {
        throw new RuntimeException("Please, implement isInContext(TemplateActionContext) method and don't invoke this method directly");
    }

    public boolean isInContext(@NotNull TemplateActionContext templateActionContext) {
        return this.isInContext(templateActionContext.getFile(), templateActionContext.getStartOffset());
    }

    public boolean isExpandableFromEditor() {
        return true;
    }

    @Nullable
    public SyntaxHighlighter createHighlighter() {
        return null;
    }

    @Nullable
    public TemplateContextType getBaseContextType() {
        return (TemplateContextType)this.myBaseContextType.getValue();
    }

    @ApiStatus.Internal
    public void clearCachedBaseContextType() {
        this.myBaseContextType.drop();
    }

    public Document createDocument(CharSequence text, Project project) {
        return EditorFactory.getInstance().createDocument(text);
    }
}

