/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.psi.PsiElement;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigateAction<T extends PsiElement>
extends AnAction {
    private final LineMarkerInfo<T> myInfo;
    @Nullable
    private final String myOriginalActionId;

    public NavigateAction(@NotNull String text, @NotNull LineMarkerInfo<T> info, @Nullable String originalActionId) {
        super(text);
        this.myInfo = info;
        this.myOriginalActionId = originalActionId;
        if (originalActionId != null) {
            ShortcutSet set = ActionManager.getInstance().getAction(originalActionId).getShortcutSet();
            this.setShortcutSet(set);
        }
    }

    public NavigateAction(@NotNull LineMarkerInfo<T> info) {
        this.myInfo = info;
        this.myOriginalActionId = null;
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (this.myInfo.getNavigationHandler() != null) {
            MouseEvent mouseEvent = (MouseEvent)e.getInputEvent();
            T element = this.myInfo.getElement();
            if (element == null || !element.isValid()) {
                return;
            }
            this.myInfo.getNavigationHandler().navigate(mouseEvent, element);
        }
    }

    @NotNull
    public static <T extends PsiElement> LineMarkerInfo<T> setNavigateAction(@NotNull LineMarkerInfo<T> info, @NotNull String text, @Nullable String originalActionId) {
        return NavigateAction.setNavigateAction(info, text, originalActionId, null);
    }

    @NotNull
    public static <T extends PsiElement> LineMarkerInfo<T> setNavigateAction(@NotNull LineMarkerInfo<T> info, @NotNull String text, @Nullable String originalActionId, @Nullable Icon icon) {
        NavigateAction<T> action = new NavigateAction<T>(text, info, originalActionId);
        if (icon != null) {
            action.getTemplatePresentation().setIcon(icon);
        }
        info.setNavigateAction(action);
        return info;
    }

    @Nullable
    public String getOriginalActionId() {
        return this.myOriginalActionId;
    }
}

