/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.AbstractBundle;
import com.intellij.DynamicBundle;
import com.intellij.UtilBundle;
import com.intellij.openapi.util.SystemInfo;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public final class CommonBundle
extends DynamicBundle {
    private static final String BUNDLE = "messages.CommonBundle";
    private static final CommonBundle INSTANCE = new CommonBundle();

    private CommonBundle() {
        super(BUNDLE);
    }

    @NotNull
    public static String message(@NotNull @PropertyKey(resourceBundle="messages.CommonBundle") String key, Object ... params) {
        if (!INSTANCE.containsKey(key)) {
            return UtilBundle.message((String)key, (Object[])params);
        }
        return INSTANCE.getMessage(key, params);
    }

    public static Supplier<String> messagePointer(@NotNull @PropertyKey(resourceBundle="messages.CommonBundle") String key, Object ... params) {
        if (!INSTANCE.containsKey(key)) {
            return () -> UtilBundle.message((String)key, (Object[])params);
        }
        return INSTANCE.getLazyMessage(key, params);
    }

    @Deprecated
    @Contract(value="null, _, _, _ -> param3")
    public static String messageOrDefault(@Nullable ResourceBundle bundle, @NotNull String key, @Nullable String defaultValue, Object ... params) {
        return AbstractBundle.messageOrDefault((ResourceBundle)bundle, (String)key, (String)defaultValue, (Object[])params);
    }

    @Deprecated
    @Nls
    @NotNull
    public static String message(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params) {
        return AbstractBundle.message((ResourceBundle)bundle, (String)key, (Object[])params);
    }

    @Deprecated
    @Nullable
    public static String messageOfNull(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params) {
        return AbstractBundle.messageOrNull((ResourceBundle)bundle, (String)key, (Object[])params);
    }

    @NotNull
    public static String getCancelButtonText() {
        return CommonBundle.message("button.cancel", new Object[0]);
    }

    public static String getHelpButtonText() {
        return CommonBundle.message("button.help", new Object[0]);
    }

    public static String getErrorTitle() {
        return CommonBundle.message("title.error", new Object[0]);
    }

    @Deprecated
    public static String getWarningTitle() {
        return CommonBundle.message("title.warning", new Object[0]);
    }

    public static String getLoadingTreeNodeText() {
        return CommonBundle.message("tree.node.loading", new Object[0]);
    }

    public static String getOkButtonText() {
        return CommonBundle.message("button.ok", new Object[0]);
    }

    public static String getYesButtonText() {
        return CommonBundle.message("button.yes", new Object[0]);
    }

    public static String getNoButtonText() {
        return CommonBundle.message("button.no", new Object[0]);
    }

    public static String getContinueButtonText() {
        return CommonBundle.message("button.continue", new Object[0]);
    }

    public static String getYesForAllButtonText() {
        return CommonBundle.message("button.yes.for.all", new Object[0]);
    }

    public static String getCloseButtonText() {
        return CommonBundle.message("button.close", new Object[0]);
    }

    @Deprecated
    public static String getNoForAllButtonText() {
        return CommonBundle.message("button.no.for.all", new Object[0]);
    }

    public static String getApplyButtonText() {
        return CommonBundle.message("button.apply", new Object[0]);
    }

    public static String getAddButtonText() {
        return CommonBundle.message("button.add.a", new Object[0]);
    }

    public static String settingsTitle() {
        return SystemInfo.isMac ? CommonBundle.message("title.settings.mac", new Object[0]) : CommonBundle.message("title.settings", new Object[0]);
    }

    public static String settingsAction() {
        return SystemInfo.isMac ? CommonBundle.message("action.settings.mac", new Object[0]) : CommonBundle.message("action.settings", new Object[0]);
    }

    public static String settingsActionDescription() {
        return SystemInfo.isMac ? CommonBundle.message("action.settings.description.mac", new Object[0]) : CommonBundle.message("action.settings.description", new Object[0]);
    }

    public static String settingsActionPath() {
        return SystemInfo.isMac ? CommonBundle.message("action.settings.path.mac", new Object[0]) : CommonBundle.message("action.settings.path", new Object[0]);
    }
}

