/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.DummyLibraryProperties;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCommonCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinWithLibraryConfigurator;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollectorKt;
import org.jetbrains.kotlin.idea.framework.CustomLibraryDescriptorWithDeferredConfig;
import org.jetbrains.kotlin.idea.framework.ui.CreateLibraryDialog;
import org.jetbrains.kotlin.idea.framework.ui.FileUIUtils;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.idea.versions.LibraryJarDescriptor;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b&\u0018\u0000 62\u00020\u0001:\u000267BE\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001a\u0010 \u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\"\u001a\u0004\u0018\u00010#H\u0014J$\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0004J\u0006\u0010(\u001a\u00020%J\u001c\u0010)\u001a\u0004\u0018\u00010%2\u0006\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\u001aH\u0016J\u0014\u0010-\u001a\u0004\u0018\u00010%2\b\u0010,\u001a\u0004\u0018\u00010\u001aH\u0016J\u001e\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204J\u000e\u00105\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0016R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/idea/framework/CustomLibraryDescriptorWithDeferredConfig;", "Lcom/intellij/openapi/roots/ui/configuration/libraries/CustomLibraryDescription;", "project", "Lcom/intellij/openapi/project/Project;", "configuratorName", "", "libraryName", "dialogTitle", "modulesSeparatorCaption", "libraryKind", "Lcom/intellij/openapi/roots/libraries/LibraryKind;", "suitableLibraryKinds", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/roots/libraries/LibraryKind;Ljava/util/Set;)V", "configurator", "Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator;", "getConfigurator", "()Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator;", "<set-?>", "Lorg/jetbrains/kotlin/idea/framework/CustomLibraryDescriptorWithDeferredConfig$DeferredCopyFileRequests;", "copyFileRequests", "getCopyFileRequests", "()Lorg/jetbrains/kotlin/idea/framework/CustomLibraryDescriptorWithDeferredConfig$DeferredCopyFileRequests;", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectBaseDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "collectPathsInPlugin", "", "Ljava/io/File;", "rootType", "Lcom/intellij/openapi/roots/OrderRootType;", "configureKotlinSettings", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "createConfiguration", "Lcom/intellij/openapi/roots/libraries/NewLibraryConfiguration;", "libraryFiles", "librarySourceFiles", "createConfigurationFromPluginPaths", "createNewLibrary", "parentComponent", "Ljavax/swing/JComponent;", "contextDirectory", "createNewLibraryWithDefaultSettings", "finishLibConfiguration", "module", "Lcom/intellij/openapi/module/Module;", "rootModel", "Lcom/intellij/openapi/roots/ModifiableRootModel;", "isNewProject", "", "getSuitableLibraryKinds", "Companion", "DeferredCopyFileRequests", "kotlin.jvm"})
public abstract class CustomLibraryDescriptorWithDeferredConfig
extends CustomLibraryDescription {
    private final VirtualFile projectBaseDir;
    @Nullable
    private DeferredCopyFileRequests copyFileRequests;
    @Nullable
    private final Project project;
    private final String configuratorName;
    private final String libraryName;
    private final String dialogTitle;
    private final String modulesSeparatorCaption;
    private final LibraryKind libraryKind;
    private final Set<LibraryKind> suitableLibraryKinds;
    private static final String DEFAULT_LIB_DIR_NAME = "lib";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final DeferredCopyFileRequests getCopyFileRequests() {
        return this.copyFileRequests;
    }

    @NotNull
    public Set<LibraryKind> getSuitableLibraryKinds() {
        return this.suitableLibraryKinds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void finishLibConfiguration(@NotNull Module module, @NotNull ModifiableRootModel rootModel, boolean isNewProject) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)rootModel, (String)"rootModel");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        this.configureKotlinSettings(project, rootModel.getSdk());
        if (isNewProject) {
            Project project2 = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
            KotlinCommonCompilerArgumentsHolder.Companion.getInstance(project2).update((Function1)finishLibConfiguration.1.INSTANCE);
        }
        OrderEnumerator orderEnumerator = rootModel.orderEntries();
        Intrinsics.checkNotNullExpressionValue((Object)orderEnumerator, (String)"rootModel.orderEntries()");
        Library library2 = ProjectStructureUtilKt.findLibrary((OrderEnumerator)orderEnumerator, (Function1)((Function1)new Function1<Library, Boolean>(this){
            final /* synthetic */ CustomLibraryDescriptorWithDeferredConfig this$0;

            public final boolean invoke(@NotNull Library library2) {
                Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
                LibraryPresentationManager libraryPresentationManager = LibraryPresentationManager.getInstance();
                Object[] objectArray = library2.getFiles(OrderRootType.CLASSES);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"library.getFiles(OrderRootType.CLASSES)");
                List classFiles = ArraysKt.toList((Object[])objectArray);
                return libraryPresentationManager.isLibraryOfKind(classFiles, CustomLibraryDescriptorWithDeferredConfig.access$getLibraryKind$p(this.this$0));
            }
            {
                this.this$0 = customLibraryDescriptorWithDeferredConfig;
                super(1);
            }
        }));
        if (library2 == null) {
            return;
        }
        Library library3 = library2;
        Library.ModifiableModel modifiableModel = library3.getModifiableModel();
        Intrinsics.checkNotNullExpressionValue((Object)modifiableModel, (String)"library.modifiableModel");
        Library.ModifiableModel model = modifiableModel;
        try {
            Project project3 = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"module.project");
            NotificationMessageCollector collector = NotificationMessageCollectorKt.createConfigureKotlinNotificationCollector(project3);
            DeferredCopyFileRequests deferredCopyFileRequests = this.copyFileRequests;
            if (deferredCopyFileRequests != null) {
                deferredCopyFileRequests.performRequests(ProjectStructureUtilKt.getModuleDir((Module)module), model, collector);
            }
            String[] stringArray = model.getUrls(OrderRootType.CLASSES);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"model.getUrls(OrderRootType.CLASSES)");
            String copyToPath = KotlinWithLibraryConfigurator.Companion.getPathFromLibraryUrls(stringArray);
            if (copyToPath != null) {
                DeferredCopyFileRequests deferredCopyFileRequests2 = this.copyFileRequests;
                KotlinWithLibraryConfigurator.FileState jarState = deferredCopyFileRequests2 == null || deferredCopyFileRequests2.isEmpty() ? KotlinWithLibraryConfigurator.FileState.DO_NOT_COPY : KotlinWithLibraryConfigurator.FileState.COPY;
                List<LibraryJarDescriptor> descriptorsWithSdk = this.getConfigurator().getLibraryJarDescriptors(rootModel.getSdk());
                for (LibraryJarDescriptor jarDescriptor : descriptorsWithSdk) {
                    boolean bl;
                    block9: {
                        VirtualFile[] $this$any$iv;
                        Intrinsics.checkNotNullExpressionValue((Object)model.getFiles(jarDescriptor.getOrderRootType()), (String)"model.getFiles(jarDescriptor.orderRootType)");
                        boolean $i$f$any = false;
                        VirtualFile[] virtualFileArray = $this$any$iv;
                        int n = virtualFileArray.length;
                        for (int i = 0; i < n; ++i) {
                            VirtualFile element$iv;
                            VirtualFile it = element$iv = virtualFileArray[i];
                            boolean bl2 = false;
                            VirtualFile virtualFile = it;
                            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"it");
                            if (!Intrinsics.areEqual((Object)virtualFile.getName(), (Object)jarDescriptor.getJarName())) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                    if (bl) continue;
                    this.getConfigurator().configureLibraryJar(model, jarState, copyToPath, jarDescriptor, collector);
                }
            }
            collector.showNotification();
        }
        finally {
            model.commit();
        }
    }

    protected void configureKotlinSettings(@NotNull Project project, @Nullable Sdk sdk) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    @Nullable
    public NewLibraryConfiguration createNewLibrary(@NotNull JComponent parentComponent, @Nullable VirtualFile contextDirectory) {
        String string;
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        KotlinWithLibraryConfigurator configurator = this.getConfigurator();
        this.copyFileRequests = new DeferredCopyFileRequests(configurator);
        if (this.projectBaseDir == null) {
            string = DEFAULT_LIB_DIR_NAME;
        } else {
            String string2 = FileUIUtils.createRelativePath(null, this.projectBaseDir, DEFAULT_LIB_DIR_NAME);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"FileUIUtils.createRelati\u2026ir, DEFAULT_LIB_DIR_NAME)");
        }
        String defaultPathToJarFile = string;
        List<LibraryJarDescriptor> jarDescriptors = configurator.getLibraryJarDescriptors(null);
        File stdJarInDefaultPath = new File(defaultPathToJarFile, ((LibraryJarDescriptor)CollectionsKt.first(jarDescriptors)).getJarName());
        boolean bl = false;
        List libraryFiles = new ArrayList();
        boolean bl2 = false;
        List librarySourceFiles = new ArrayList();
        if (this.projectBaseDir != null && stdJarInDefaultPath.exists()) {
            libraryFiles.add(stdJarInDefaultPath);
            for (LibraryJarDescriptor jarDescriptor : jarDescriptors) {
                File destination = new File(defaultPathToJarFile, jarDescriptor.getJarName());
                if (!destination.exists()) {
                    DeferredCopyFileRequests deferredCopyFileRequests = this.copyFileRequests;
                    Intrinsics.checkNotNull((Object)deferredCopyFileRequests);
                    deferredCopyFileRequests.addCopyWithReplaceRequest(jarDescriptor.getPathInPlugin(), defaultPathToJarFile);
                    destination = jarDescriptor.getPathInPlugin();
                }
                if (Intrinsics.areEqual((Object)jarDescriptor.getOrderRootType(), (Object)OrderRootType.SOURCES)) {
                    librarySourceFiles.add(destination);
                    continue;
                }
                libraryFiles.add(destination);
            }
        } else {
            CreateLibraryDialog dialog = new CreateLibraryDialog(defaultPathToJarFile, this.dialogTitle, this.modulesSeparatorCaption);
            dialog.show();
            if (!dialog.isOK()) {
                return null;
            }
            String copyIntoPath = dialog.getCopyIntoPath();
            if (copyIntoPath != null) {
                for (LibraryJarDescriptor libraryJarDescriptor : configurator.getLibraryJarDescriptors(null)) {
                    DeferredCopyFileRequests deferredCopyFileRequests = this.copyFileRequests;
                    Intrinsics.checkNotNull((Object)deferredCopyFileRequests);
                    deferredCopyFileRequests.addCopyWithReplaceRequest(libraryJarDescriptor.getPathInPlugin(), copyIntoPath);
                }
            }
            for (LibraryJarDescriptor jarDescriptor : jarDescriptors) {
                if (Intrinsics.areEqual((Object)jarDescriptor.getOrderRootType(), (Object)OrderRootType.SOURCES)) {
                    librarySourceFiles.add(jarDescriptor.getPathInPlugin());
                    continue;
                }
                libraryFiles.add(jarDescriptor.getPathInPlugin());
            }
        }
        return this.createConfiguration(libraryFiles, librarySourceFiles);
    }

    private final KotlinWithLibraryConfigurator getConfigurator() {
        KotlinWithLibraryConfigurator kotlinWithLibraryConfigurator = (KotlinWithLibraryConfigurator)ConfigureKotlinInProjectUtilsKt.getConfiguratorByName(this.configuratorName);
        if (kotlinWithLibraryConfigurator == null) {
            String string = "Configurator with name " + this.configuratorName + " should exists";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return kotlinWithLibraryConfigurator;
    }

    @Nullable
    public NewLibraryConfiguration createNewLibraryWithDefaultSettings(@Nullable VirtualFile contextDirectory) {
        return this.createConfigurationFromPluginPaths();
    }

    @NotNull
    public final NewLibraryConfiguration createConfigurationFromPluginPaths() {
        OrderRootType orderRootType = OrderRootType.CLASSES;
        Intrinsics.checkNotNullExpressionValue((Object)orderRootType, (String)"OrderRootType.CLASSES");
        List<File> list = this.collectPathsInPlugin(orderRootType);
        OrderRootType orderRootType2 = OrderRootType.SOURCES;
        Intrinsics.checkNotNullExpressionValue((Object)orderRootType2, (String)"OrderRootType.SOURCES");
        return this.createConfiguration(list, this.collectPathsInPlugin(orderRootType2));
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> collectPathsInPlugin(OrderRootType rootType) {
        void $this$mapTo$iv$iv;
        LibraryJarDescriptor it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getConfigurator().getLibraryJarDescriptors(null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (LibraryJarDescriptor)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getOrderRootType(), (Object)rootType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (LibraryJarDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = it.getPathInPlugin();
            collection.add(file);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected final NewLibraryConfiguration createConfiguration(@NotNull List<? extends File> libraryFiles, @NotNull List<? extends File> librarySourceFiles) {
        Intrinsics.checkNotNullParameter(libraryFiles, (String)"libraryFiles");
        Intrinsics.checkNotNullParameter(librarySourceFiles, (String)"librarySourceFiles");
        return new NewLibraryConfiguration(this, libraryFiles, librarySourceFiles, this.libraryName, this.getConfigurator().getLibraryType(), (LibraryProperties)DummyLibraryProperties.INSTANCE){
            final /* synthetic */ CustomLibraryDescriptorWithDeferredConfig this$0;
            final /* synthetic */ List $libraryFiles;
            final /* synthetic */ List $librarySourceFiles;

            public void addRoots(@NotNull LibraryEditor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                for (File libraryFile : this.$libraryFiles) {
                    editor.addRoot(VfsUtil.getUrlForLibraryRoot((File)libraryFile), OrderRootType.CLASSES);
                }
                for (File librarySrcFile : this.$librarySourceFiles) {
                    editor.addRoot(VfsUtil.getUrlForLibraryRoot((File)librarySrcFile), OrderRootType.SOURCES);
                }
            }
            {
                this.this$0 = this$0;
                this.$libraryFiles = $captured_local_variable$1;
                this.$librarySourceFiles = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        };
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    public CustomLibraryDescriptorWithDeferredConfig(@Nullable Project project, @NotNull String configuratorName, @NotNull String libraryName, @NotNull String dialogTitle, @NotNull String modulesSeparatorCaption, @NotNull LibraryKind libraryKind, @NotNull Set<? extends LibraryKind> suitableLibraryKinds) {
        Intrinsics.checkNotNullParameter((Object)configuratorName, (String)"configuratorName");
        Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        Intrinsics.checkNotNullParameter((Object)modulesSeparatorCaption, (String)"modulesSeparatorCaption");
        Intrinsics.checkNotNullParameter((Object)libraryKind, (String)"libraryKind");
        Intrinsics.checkNotNullParameter(suitableLibraryKinds, (String)"suitableLibraryKinds");
        this.project = project;
        this.configuratorName = configuratorName;
        this.libraryName = libraryName;
        this.dialogTitle = dialogTitle;
        this.modulesSeparatorCaption = modulesSeparatorCaption;
        this.libraryKind = libraryKind;
        this.suitableLibraryKinds = suitableLibraryKinds;
        Project project2 = this.project;
        this.projectBaseDir = project2 != null ? project2.getBaseDir() : null;
    }

    public static final /* synthetic */ LibraryKind access$getLibraryKind$p(CustomLibraryDescriptorWithDeferredConfig $this) {
        return $this.libraryKind;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/framework/CustomLibraryDescriptorWithDeferredConfig$DeferredCopyFileRequests;", "", "configurator", "Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator;", "(Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator;)V", "copyFilesRequests", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/idea/framework/CustomLibraryDescriptorWithDeferredConfig$DeferredCopyFileRequests$CopyFileRequest;", "Lkotlin/collections/ArrayList;", "addCopyWithReplaceRequest", "", "file", "Ljava/io/File;", "copyIntoPath", "", "isEmpty", "", "performRequests", "relativePath", "model", "Lcom/intellij/openapi/roots/libraries/Library$ModifiableModel;", "collector", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "CopyFileRequest", "kotlin.jvm"})
    public static final class DeferredCopyFileRequests {
        private final ArrayList<CopyFileRequest> copyFilesRequests;
        private final KotlinWithLibraryConfigurator configurator;

        public final boolean isEmpty() {
            return this.copyFilesRequests.isEmpty();
        }

        public final void performRequests(@NotNull String relativePath, @NotNull Library.ModifiableModel model, @NotNull NotificationMessageCollector collector) {
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
            for (CopyFileRequest request : this.copyFilesRequests) {
                String destinationPath = FileUtil.isAbsolute((String)request.getToDir()) ? request.getToDir() : new File(relativePath, request.getToDir()).getPath();
                File file = request.getFile();
                String string = destinationPath;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"destinationPath");
                File resultFile = this.configurator.copyFileToDir(file, string, collector);
                if (!request.getReplaceInLib() || resultFile == null) continue;
                ProjectStructureUtilKt.replaceFileRoot((Library.ModifiableModel)model, (File)request.getFile(), (File)resultFile);
            }
        }

        public final void addCopyWithReplaceRequest(@NotNull File file, @NotNull String copyIntoPath) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)copyIntoPath, (String)"copyIntoPath");
            this.copyFilesRequests.add(new CopyFileRequest(copyIntoPath, file, true));
        }

        public DeferredCopyFileRequests(@NotNull KotlinWithLibraryConfigurator configurator) {
            Intrinsics.checkNotNullParameter((Object)configurator, (String)"configurator");
            this.configurator = configurator;
            boolean bl = false;
            this.copyFilesRequests = new ArrayList();
        }

        @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/framework/CustomLibraryDescriptorWithDeferredConfig$DeferredCopyFileRequests$CopyFileRequest;", "", "toDir", "", "file", "Ljava/io/File;", "replaceInLib", "", "(Ljava/lang/String;Ljava/io/File;Z)V", "getFile", "()Ljava/io/File;", "getReplaceInLib", "()Z", "getToDir", "()Ljava/lang/String;", "kotlin.jvm"})
        public static final class CopyFileRequest {
            @NotNull
            private final String toDir;
            @NotNull
            private final File file;
            private final boolean replaceInLib;

            @NotNull
            public final String getToDir() {
                return this.toDir;
            }

            @NotNull
            public final File getFile() {
                return this.file;
            }

            public final boolean getReplaceInLib() {
                return this.replaceInLib;
            }

            public CopyFileRequest(@NotNull String toDir, @NotNull File file, boolean replaceInLib) {
                Intrinsics.checkNotNullParameter((Object)toDir, (String)"toDir");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                this.toDir = toDir;
                this.file = file;
                this.replaceInLib = replaceInLib;
            }
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/framework/CustomLibraryDescriptorWithDeferredConfig$Companion;", "", "()V", "DEFAULT_LIB_DIR_NAME", "", "kotlin.jvm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

