/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.debugger;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Data;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.debugger.DebuggerRequest;
import com.google.api.services.debugger.DebuggerRequestInitializer;
import com.google.api.services.debugger.model.Breakpoint;
import com.google.api.services.debugger.model.GetBreakpointResponse;
import com.google.api.services.debugger.model.ListBreakpointsResponse;
import com.google.api.services.debugger.model.ListDebuggeesResponse;
import com.google.api.services.debugger.model.SetBreakpointResponse;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Debugger
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "debugger/v1beta/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/debugger/v1beta/";

    public Debugger(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Debugger(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Debuggees debuggees() {
        return new Debuggees();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.20.0 of the Cloud Debugger API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Debugger.DEFAULT_ROOT_URL, Debugger.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Debugger build() {
            return new Debugger(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setDebuggerRequestInitializer(DebuggerRequestInitializer debuggerRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)debuggerRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Debuggees {
        public List list() throws IOException {
            List result = new List();
            Debugger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Breakpoints breakpoints() {
            return new Breakpoints();
        }

        public class Breakpoints {
            public Delete delete(String debuggeeId, String breakpointId) throws IOException {
                Delete result = new Delete(debuggeeId, breakpointId);
                Debugger.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String debuggeeId, String breakpointId) throws IOException {
                Get result = new Get(debuggeeId, breakpointId);
                Debugger.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String debuggeeId) throws IOException {
                List result = new List(debuggeeId);
                Debugger.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Set set(String debuggeeId, Breakpoint content) throws IOException {
                Set result = new Set(debuggeeId, content);
                Debugger.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Set
            extends DebuggerRequest<SetBreakpointResponse> {
                private static final String REST_PATH = "debuggees/{debuggeeId}/breakpoints/set";
                @Key
                private String debuggeeId;

                protected Set(String debuggeeId, Breakpoint content) {
                    super(Debugger.this, "POST", REST_PATH, (Object)content, SetBreakpointResponse.class);
                    this.debuggeeId = (String)Preconditions.checkNotNull((Object)debuggeeId, (Object)"Required parameter debuggeeId must be specified.");
                }

                public Set setAlt(String alt) {
                    return (Set)super.setAlt(alt);
                }

                public Set setFields(String fields) {
                    return (Set)super.setFields(fields);
                }

                public Set setKey(String key) {
                    return (Set)super.setKey(key);
                }

                public Set setOauthToken(String oauthToken) {
                    return (Set)super.setOauthToken(oauthToken);
                }

                public Set setPrettyPrint(Boolean prettyPrint) {
                    return (Set)super.setPrettyPrint(prettyPrint);
                }

                public Set setQuotaUser(String quotaUser) {
                    return (Set)super.setQuotaUser(quotaUser);
                }

                public Set setUserIp(String userIp) {
                    return (Set)super.setUserIp(userIp);
                }

                public String getDebuggeeId() {
                    return this.debuggeeId;
                }

                public Set setDebuggeeId(String debuggeeId) {
                    this.debuggeeId = debuggeeId;
                    return this;
                }

                @Override
                public Set set(String parameterName, Object value) {
                    return (Set)super.set(parameterName, value);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends DebuggerRequest<ListBreakpointsResponse> {
                private static final String REST_PATH = "debuggees/{debuggeeId}/breakpoints";
                @Key
                private String debuggeeId;
                @Key
                private Boolean includeAllUsers;
                @Key
                private Boolean stripResults;
                @Key
                private Boolean includeInactive;
                @Key
                private String waitToken;
                @Key
                private String action;

                protected List(String debuggeeId) {
                    super(Debugger.this, "GET", REST_PATH, null, ListBreakpointsResponse.class);
                    this.debuggeeId = (String)Preconditions.checkNotNull((Object)debuggeeId, (Object)"Required parameter debuggeeId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getDebuggeeId() {
                    return this.debuggeeId;
                }

                public List setDebuggeeId(String debuggeeId) {
                    this.debuggeeId = debuggeeId;
                    return this;
                }

                public Boolean getIncludeAllUsers() {
                    return this.includeAllUsers;
                }

                public List setIncludeAllUsers(Boolean includeAllUsers) {
                    this.includeAllUsers = includeAllUsers;
                    return this;
                }

                public boolean isIncludeAllUsers() {
                    if (this.includeAllUsers == null || this.includeAllUsers == Data.NULL_BOOLEAN) {
                        return false;
                    }
                    return this.includeAllUsers;
                }

                public Boolean getStripResults() {
                    return this.stripResults;
                }

                public List setStripResults(Boolean stripResults) {
                    this.stripResults = stripResults;
                    return this;
                }

                public Boolean getIncludeInactive() {
                    return this.includeInactive;
                }

                public List setIncludeInactive(Boolean includeInactive) {
                    this.includeInactive = includeInactive;
                    return this;
                }

                public boolean isIncludeInactive() {
                    if (this.includeInactive == null || this.includeInactive == Data.NULL_BOOLEAN) {
                        return false;
                    }
                    return this.includeInactive;
                }

                public String getWaitToken() {
                    return this.waitToken;
                }

                public List setWaitToken(String waitToken) {
                    this.waitToken = waitToken;
                    return this;
                }

                public String getAction() {
                    return this.action;
                }

                public List setAction(String action) {
                    this.action = action;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends DebuggerRequest<GetBreakpointResponse> {
                private static final String REST_PATH = "debuggees/{debuggeeId}/breakpoints/{breakpointId}";
                @Key
                private String debuggeeId;
                @Key
                private String breakpointId;

                protected Get(String debuggeeId, String breakpointId) {
                    super(Debugger.this, "GET", REST_PATH, null, GetBreakpointResponse.class);
                    this.debuggeeId = (String)Preconditions.checkNotNull((Object)debuggeeId, (Object)"Required parameter debuggeeId must be specified.");
                    this.breakpointId = (String)Preconditions.checkNotNull((Object)breakpointId, (Object)"Required parameter breakpointId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUserIp(String userIp) {
                    return (Get)super.setUserIp(userIp);
                }

                public String getDebuggeeId() {
                    return this.debuggeeId;
                }

                public Get setDebuggeeId(String debuggeeId) {
                    this.debuggeeId = debuggeeId;
                    return this;
                }

                public String getBreakpointId() {
                    return this.breakpointId;
                }

                public Get setBreakpointId(String breakpointId) {
                    this.breakpointId = breakpointId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends DebuggerRequest<Void> {
                private static final String REST_PATH = "debuggees/{debuggeeId}/breakpoints/{breakpointId}";
                @Key
                private String debuggeeId;
                @Key
                private String breakpointId;

                protected Delete(String debuggeeId, String breakpointId) {
                    super(Debugger.this, "DELETE", REST_PATH, null, Void.class);
                    this.debuggeeId = (String)Preconditions.checkNotNull((Object)debuggeeId, (Object)"Required parameter debuggeeId must be specified.");
                    this.breakpointId = (String)Preconditions.checkNotNull((Object)breakpointId, (Object)"Required parameter breakpointId must be specified.");
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUserIp(String userIp) {
                    return (Delete)super.setUserIp(userIp);
                }

                public String getDebuggeeId() {
                    return this.debuggeeId;
                }

                public Delete setDebuggeeId(String debuggeeId) {
                    this.debuggeeId = debuggeeId;
                    return this;
                }

                public String getBreakpointId() {
                    return this.breakpointId;
                }

                public Delete setBreakpointId(String breakpointId) {
                    this.breakpointId = breakpointId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DebuggerRequest<ListDebuggeesResponse> {
            private static final String REST_PATH = "debuggees";
            @Key
            private Boolean includeInactive;
            @Key
            private String project;

            protected List() {
                super(Debugger.this, "GET", REST_PATH, null, ListDebuggeesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public Boolean getIncludeInactive() {
                return this.includeInactive;
            }

            public List setIncludeInactive(Boolean includeInactive) {
                this.includeInactive = includeInactive;
                return this;
            }

            public boolean isIncludeInactive() {
                if (this.includeInactive == null || this.includeInactive == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeInactive;
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                this.project = project;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }
}

