/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.utils;

public class PrettyName {
    private String text;
    private int markStart;
    private int markEnd;

    public PrettyName(String text) {
        if (text == null) {
            text = "";
        }
        this.text = text;
        this.markStart = 0;
        this.markEnd = text.length();
    }

    public PrettyName(String text, int markStart, int markEnd) {
        if (text == null) {
            text = "";
        }
        this.text = text;
        this.markStart = this.validatePos(markStart);
        this.markEnd = this.validatePos(markEnd);
    }

    public PrettyName(String text, int markStart) {
        if (text == null) {
            text = "";
        }
        this.text = text;
        this.markStart = this.validatePos(markStart);
        this.markEnd = text.length();
    }

    private int validatePos(int pos) {
        return Math.max(0, Math.min(pos, this.text.length()));
    }

    public String getText() {
        return this.text;
    }

    public int getMarkStart() {
        return this.markStart;
    }

    public int getMarkEnd() {
        return this.markEnd;
    }

    public String getPrefix() {
        return this.text.substring(0, this.markStart);
    }

    public String getMarked() {
        return this.text.substring(this.markStart, this.markEnd);
    }

    public String getSuffix() {
        return this.text.substring(this.markEnd);
    }
}

