/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.parser;

import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprBinary;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprVar;
import com.jetbrains.sourceglider.scripts.rml.ast.Stmt;
import com.jetbrains.sourceglider.scripts.rml.ast.StmtAssign;
import com.jetbrains.sourceglider.scripts.rml.ast.StmtRelAssign;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.scripts.rml.parser.Expression;
import com.jetbrains.sourceglider.scripts.rml.parser.Nonterm;
import com.jetbrains.sourceglider.scripts.rml.parser.ParseException;
import com.jetbrains.sourceglider.scripts.rml.parser.TokenInfo;
import com.jetbrains.sourceglider.ui.Messages;

public class StatementAssign
extends Nonterm {
    public static final int ASSIGNMENT = 0;
    public static final int UNITE = 1;
    public static final int SUBTRACT = 2;
    public Stmt stmt;
    public Expression expr;
    private String relvar;
    private String numvar;
    private DomainType[] types;
    private String[] domNames;
    private int[][] domLocs;
    private int domainIndex;
    private int type;
    private int[] lvalueLoc;
    private int opCode;

    public StatementAssign(Context context2) {
        super(context2);
    }

    public void relvar(TokenInfo token) {
        this.relvar = token.getString();
        this.types = this.context.variablesManager.getRelation(this.relvar);
        this.domNames = new String[this.types.length];
        this.domLocs = new int[this.types.length][2];
        this.domainIndex = 0;
        this.type = 0;
        this.lvalueLoc = token.location;
    }

    public void domain(TokenInfo token) throws ParseException {
        String name;
        if (this.domainIndex >= this.types.length) {
            throw new ParseException(token.location, Messages.getString(StatementAssign.class.getName() + "-0"));
        }
        this.domNames[this.domainIndex] = name = token.getString();
        this.domLocs[this.domainIndex] = token.location;
        if (this.context.variablesManager.containsDomain(name)) {
            throw new ParseException(token.location, Messages.getString(StatementAssign.class.getName() + "-1"));
        }
        this.context.variablesManager.addDomain(name, this.types[this.domainIndex++]);
    }

    public void finish(TokenInfo token) throws ParseException {
        if (this.domainIndex < this.types.length) {
            throw new ParseException(token.location, Messages.getString(StatementAssign.class.getName() + "-2"));
        }
    }

    public void numvar(TokenInfo token) throws ParseException {
        this.numvar = token.getString();
        if (!this.context.variablesManager.containsVariable(this.numvar)) {
            throw new ParseException(token.location, Messages.getString(StatementAssign.class.getName() + "-3") + this.numvar + Messages.getString(StatementAssign.class.getName() + "-4"));
        }
        this.type = this.context.variablesManager.getVariableType(this.numvar);
        this.lvalueLoc = token.location;
    }

    public void id(TokenInfo token) throws ParseException {
        throw new ParseException(token.location, Messages.getString(StatementAssign.class.getName() + "-5") + token.getString() + Messages.getString(StatementAssign.class.getName() + "-6"));
    }

    public void assign(TokenInfo token) {
        this.opCode = 0;
    }

    public void unite(TokenInfo token) throws ParseException {
        if (this.type != 0) {
            throw new ParseException(this.lvalueLoc, Messages.getString(StatementAssign.class.getName() + "-7"));
        }
        this.opCode = 1;
    }

    public void subtract(TokenInfo token) throws ParseException {
        if (this.type != 0) {
            throw new ParseException(this.lvalueLoc, Messages.getString(StatementAssign.class.getName() + "-8"));
        }
        this.opCode = 2;
    }

    public void expr() throws ParseException {
        if (this.type != this.expr.type) {
            throw new ParseException(this.expr.location, Messages.getString(StatementAssign.class.getName() + "-9"));
        }
        if (this.relvar != null) {
            for (int i2 = 0; i2 < this.domNames.length; ++i2) {
                if (!this.context.variablesManager.wasDomainUsed(this.domNames[i2])) {
                    throw new ParseException(this.domLocs[i2], Messages.getString(StatementAssign.class.getName() + "-10") + this.domNames[i2] + Messages.getString(StatementAssign.class.getName() + "-11"));
                }
                this.context.variablesManager.removeDomain(this.domNames[i2]);
            }
            if (this.opCode == 0) {
                this.stmt = new StmtRelAssign(this.relvar, this.domNames, this.expr.relExpr, this.context);
            } else if (this.opCode == 1) {
                this.stmt = new StmtRelAssign(this.relvar, this.domNames, new RelExprBinary(0, new RelExprVar(this.relvar, this.domNames, this.context), this.expr.relExpr, this.context, this), this.context);
            } else if (this.opCode == 2) {
                this.stmt = new StmtRelAssign(this.relvar, this.domNames, new RelExprBinary(3, new RelExprVar(this.relvar, this.domNames, this.context), this.expr.relExpr, this.context, this), this.context);
            }
        } else {
            this.stmt = new StmtAssign(this.numvar, this.expr.expr, this.context);
        }
    }
}

