/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.parser;

import com.jetbrains.sourceglider.scripts.rml.ast.Stmt;
import com.jetbrains.sourceglider.scripts.rml.ast.StmtList;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.scripts.rml.parser.Declaration;
import com.jetbrains.sourceglider.scripts.rml.parser.Nonterm;
import com.jetbrains.sourceglider.scripts.rml.parser.ParseException;
import com.jetbrains.sourceglider.scripts.rml.parser.Statement;
import com.jetbrains.sourceglider.scripts.rml.parser.TokenInfo;
import com.jetbrains.sourceglider.ui.Messages;
import java.util.ArrayList;
import java.util.List;

public class Program
extends Nonterm {
    private Stmt stmt;
    public Statement statement;
    public Declaration decl;
    private String key;
    private List<Stmt> stmtList = new ArrayList<Stmt>();
    private boolean wasLocation;

    public Program(Context context2) {
        super(context2);
    }

    public void key(TokenInfo token) {
        this.key = token.getString();
        if (this.key.equals("location")) {
            this.wasLocation = true;
        }
    }

    public void value(TokenInfo token) {
        this.context.variablesManager.addScriptMetaInfo(this.key, token.getString());
    }

    public void checkLoc(TokenInfo token) throws ParseException {
        if (!this.wasLocation) {
            throw new ParseException(token.location, Messages.getString(Program.class.getName() + "-0") + "location" + Messages.getString(Program.class.getName() + "-1"));
        }
    }

    public Stmt getStmt() {
        return this.stmt;
    }

    public void stmt() {
        this.stmtList.add(this.statement.stmt);
    }

    public void finish() {
        this.stmt = new StmtList(this.stmtList, this.context);
    }
}

