/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.ast;

import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.scripts.rml.DomainConstraint;
import com.jetbrains.sourceglider.scripts.rml.DomainsPool;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExpr;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.scripts.rml.parser.Factor;
import com.jetbrains.sourceglider.scripts.rml.parser.Nonterm;
import com.jetbrains.sourceglider.scripts.rml.parser.VariablesManager;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;
import com.jetbrains.sourceglider.utils.ArrayHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class RelExprVar
extends RelExpr {
    public static final int DOMAIN = 0;
    public static final int ATTRIBUTE = 1;
    public static final int UNDERSCORE = 2;
    public static final int REGEXP = 3;
    private final String relname;
    private final String[] values;
    private final int[] flags;
    private boolean fastRename;
    private Nonterm nonterm1;
    private Nonterm nonterm2;

    public RelExprVar(String relname, String[] values, int[] flags, Context context2, Factor nonterm1, Nonterm nonterm2) {
        super(context2);
        this.relname = relname;
        this.values = values;
        this.flags = flags;
        this.nonterm1 = nonterm1;
        this.nonterm2 = nonterm2;
        this.fastRename = true;
        for (int flag : flags) {
            if (flag == 0) continue;
            this.fastRename = false;
            break;
        }
    }

    public RelExprVar(String relname, String[] values, Context context2) {
        super(context2);
        this.relname = relname;
        this.values = values;
        this.fastRename = true;
        this.flags = new int[values.length];
        Arrays.fill(this.flags, 0);
    }

    @Override
    public IRelation interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, ThreadCallback threadCallback, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, ProfileManager profileManager) {
        IRelation result2 = relationsManager.makeRepositoryRelation(variablesManager.getRelation(this.relname), this.relname);
        if (this.fastRename) {
            Domain[] domains = new Domain[this.values.length];
            for (int i2 = 0; i2 < domains.length; ++i2) {
                domains[i2] = variablesManager.getDomain(this.values[i2]);
            }
            IRelation oldResult = result2;
            result2 = result2.fastRename(domains, threadCallback);
            oldResult.kill();
            return result2;
        }
        for (int i3 = this.values.length - 1; i3 >= 0; --i3) {
            IRelation oldResult = result2;
            if (this.flags[i3] == 1) {
                Domain domain = result2.getDomain(i3);
                int attr = symbolTable.findAttributeInt(domain.getType(), this.values[i3]);
                if (attr == -1) {
                    result2 = relationsManager.makeEmptyRelation((Domain[])ArrayHelper.deleteElement(result2.getDomains(), i3, Domain.class));
                    uiInstancesProvider.getConsole().println(Messages.getString(RelExprVar.class.getName() + "-0") + this.values[i3] + Messages.getString(RelExprVar.class.getName() + "-1"));
                } else {
                    result2 = result2.project(i3, attr, threadCallback);
                }
            } else if (this.flags[i3] == 2) {
                result2 = result2.exists(i3, threadCallback);
            } else if (this.flags[i3] == 3) {
                result2 = result2.relprod(relationsManager.makeRegExprSet(result2.getDomain(i3), this.values[i3], threadCallback), result2.getDomain(i3), threadCallback);
            } else if (this.flags[i3] == 0) {
                result2 = result2.rename(i3, variablesManager.getDomain(this.values[i3]), threadCallback);
            }
            oldResult.kill();
        }
        return result2;
    }

    public Domain getDomain(RuntimeVariablesManager variablesManager, int index) {
        return variablesManager.getRelation(this.relname).getDomain(index);
    }

    public String getDomainName(int index) {
        return this.flags[index] == 0 ? this.values[index] : "_";
    }

    @Override
    public void collectDomainConstraints(Map<String, List> constraints, VariablesManager variablesManager) {
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            if (this.flags[i2] != 0) continue;
            DomainType type = variablesManager.getRelation(this.relname)[i2];
            List vector = constraints.get(this.values[i2]);
            for (int j = 0; j < this.values.length; ++j) {
                if (this.flags[j] != 0 && this.flags[j] != 2 || variablesManager.getRelation(this.relname)[j] != type) continue;
                vector.add(new DomainConstraint(this, j));
            }
        }
    }

    @Override
    public int[] getLocation() {
        if (this.nonterm1 != null && this.nonterm2 != null) {
            int[] loc1 = this.nonterm1.getLocation();
            int[] loc2 = this.nonterm2.getLocation();
            return new int[]{loc1[0], loc2[1], loc2[2], loc2[3]};
        }
        return null;
    }
}

