/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml;

import com.jetbrains.sourceglider.scripts.rml.ast.QueryNode;
import com.jetbrains.sourceglider.ui.console.Console;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ProfileManager {
    private Map<QueryNode, ProfileData> map = new HashMap<QueryNode, ProfileData>();

    public void addDuration(QueryNode node2, long duration, long bddSize) {
        ProfileData profileData = this.map.get(node2);
        if (profileData == null) {
            profileData = new ProfileData();
            this.map.put(node2, profileData);
        }
        ProfileData profileData2 = profileData;
        profileData2.totalDuration = profileData2.totalDuration + duration;
        profileData2 = profileData;
        profileData2.totalBddSize = profileData2.totalBddSize + bddSize;
        profileData2 = profileData;
        profileData2.totalCount = profileData2.totalCount + 1L;
    }

    public void dump(Console console, String query) {
        ArrayList<QueryNode> nodes = new ArrayList<QueryNode>(this.map.keySet());
        nodes.sort((o1, o2) -> {
            long diff2 = this.map.get(o1).totalDuration - this.map.get(o2).totalDuration;
            return diff2 < 0L ? 1 : (diff2 > 0L ? -1 : 0);
        });
        console.println("Operations profile:");
        for (QueryNode node2 : nodes) {
            ProfileData profileData = this.map.get(node2);
            int[] location = node2.getLocation();
            String astString = query.substring(location[0], location[1]);
            console.println("time: " + (double)profileData.totalDuration / 1000.0 + ", BDD nodes: " + profileData.totalBddSize + ", invocations: " + profileData.totalCount + ", loc: " + location[2] + ":" + location[3] + "\t" + astString);
        }
    }

    private static class ProfileData {
        private long totalDuration;
        private long totalBddSize;
        private long totalCount;

        private ProfileData() {
        }
    }
}

