/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.spellchecker;

import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.inspections.TextSplitter;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.spellchecker.tokenizer.TokenizerBase;
import com.intellij.util.Consumer;
import com.jetbrains.cmake.psi.CMakeTokenTypes;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeSpellCheckingStrategy
extends SpellcheckingStrategy {
    private static final TokenSet PLAIN_ID_HOLDERS = TokenSet.create((IElementType[])new IElementType[]{CMakeTokenTypes.ID, CMakeTokenTypes.LITERAL});
    private static final NotNullLazyKey<TokenizerBase<PsiElement>, Project> PREFIX_TOKENIZER = NotNullLazyKey.create((String)"PREFIX_TOKENIZER", project2 -> new TokenizerBase((Splitter)new PlainTextSplitterWithPrefixes((Project)project2)));

    @NotNull
    public Tokenizer getTokenizer(@NotNull PsiElement element) {
        ASTNode node2 = element.getNode();
        if (node2 != null && PLAIN_ID_HOLDERS.contains(node2.getElementType())) {
            return (Tokenizer)PREFIX_TOKENIZER.getValue((UserDataHolder)element.getProject());
        }
        if (element instanceof PsiComment) {
            if (SuppressionUtil.isSuppressionComment((PsiElement)element)) {
                return EMPTY_TOKENIZER;
            }
            return (Tokenizer)PREFIX_TOKENIZER.getValue((UserDataHolder)element.getProject());
        }
        return EMPTY_TOKENIZER;
    }

    private static String getWord(@NotNull String text, int start, int end) {
        return StringUtil.toLowerCase((String)text.substring(start, end));
    }

    static class PlainTextSplitterWithPrefixes
    extends PlainTextSplitter {
        private static final String[] KNOWN_WORD_PREFIXES = new String[]{"asm", "bin", "bit", "boost", "build", "code", "cpp", "cxx", "doc", "debug", "dbg", "dll", "exe", "gnu", "gcc", "help", "jit", "lib", "link", "llvm", "ms", "native", "non", "ocaml", "obj", "pkg", "python", "release", "rel", "root", "src", "xc"};
        private static final String KNOWN_SINGLE_CHAR_SWITCHER_PREFIXES = "bigfrtlmXWD";
        private static final Pattern EXTENDED_WORD_AND_HASH_NOT_SPECIAL = Pattern.compile("(&[^;]+;)|((0x[0-9]*)?\\p{L}+'?\\p{L}[_\\p{L}]*)");
        private static final Splitter HASH_NOT_SPECIAL_TEXT_SPLITTER = new TextSplitter(){

            @NotNull
            @Contract(pure=true)
            protected Pattern getExtendedWordAndSpecial() {
                return EXTENDED_WORD_AND_HASH_NOT_SPECIAL;
            }
        };
        private final SpellCheckerManager mySpeller;

        PlainTextSplitterWithPrefixes(Project project2) {
            this.mySpeller = SpellCheckerManager.getInstance((Project)project2);
        }

        public void split(@Nullable String text, @NotNull TextRange range, @NotNull Consumer<TextRange> consumer) {
            super.split(text, range, text == null ? consumer : this.wrapConsumer(text, consumer));
        }

        @NotNull
        @Contract(pure=true)
        private Consumer<TextRange> wrapConsumer(@NotNull String text, @NotNull Consumer<TextRange> consumer) {
            return range -> {
                int start = range.getStartOffset();
                int end = range.getEndOffset();
                assert (!ApplicationManager.getApplication().isDispatchThread());
                String word = CMakeSpellCheckingStrategy.getWord(text, start, end);
                if (!this.mySpeller.hasProblem(word)) {
                    return;
                }
                if (!(start <= 0 || text.charAt(start - 1) != '-' || start - 2 >= 0 && "\"' \t\n,".indexOf(text.charAt(start - 2)) < 0 || KNOWN_SINGLE_CHAR_SWITCHER_PREFIXES.indexOf(text.charAt(start)) < 0 || this.mySpeller.hasProblem(word = CMakeSpellCheckingStrategy.getWord(text, ++start, end)))) {
                    return;
                }
                for (int i2 = 0; i2 < KNOWN_WORD_PREFIXES.length; ++i2) {
                    String prefix = KNOWN_WORD_PREFIXES[i2];
                    if (!StringUtil.startsWith((CharSequence)word, (CharSequence)prefix)) continue;
                    if ((start += prefix.length()) >= end) break;
                    word = CMakeSpellCheckingStrategy.getWord(text, start, end);
                    if (!this.mySpeller.hasProblem(word)) {
                        return;
                    }
                    i2 = 0;
                }
                consumer.consume((Object)TextRange.create((int)start, (int)end));
            };
        }

        @NotNull
        protected Splitter getTextSplitter() {
            return HASH_NOT_SPECIAL_TEXT_SPLITTER;
        }
    }
}

