/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.psi;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeElementFactory;
import com.jetbrains.cmake.psi.util.CMakeFilePathPartsRenameHolder;
import com.jetbrains.cmake.psi.util.CMakeLiteralUtils;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeArgumentManipulator
extends AbstractElementManipulator<CMakeArgument> {
    public static final NotNullFunction<String, String> ESCAPER = StringUtil.escaper((boolean)true, (String)"$;\"");
    private static final Pattern LINE_CONTINUATION = Pattern.compile("[\\\\]([\\\\][\\\\])*([\n]|([\r][\n]))");

    @Nullable
    @Contract(value="null->null;!null->!null")
    public static String getCMakeLiteralFromValue(@Nullable String pureTextValue) {
        if (pureTextValue == null) {
            return null;
        }
        if (CMakeLiteralUtils.shouldBeInsideQuotes(pureTextValue = (String)ESCAPER.fun((Object)pureTextValue))) {
            pureTextValue = StringUtil.wrapWithDoubleQuote((String)pureTextValue);
        }
        return pureTextValue;
    }

    @Nullable
    @Contract(value="null->null;!null->!null")
    public static String getValueFromCMakeLiteralNoEval(@Nullable String rawLiteralText) {
        if (rawLiteralText == null) {
            return null;
        }
        return StringUtil.unquoteString((String)StringUtil.unescapeStringCharacters((String)LINE_CONTINUATION.matcher(rawLiteralText).replaceAll("")), (char)'\"');
    }

    public CMakeArgument handleContentChange(@NotNull CMakeArgument argument, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        String newFullContent;
        CMakeFilePathPartsRenameHolder filePathHolder = new CMakeFilePathPartsRenameHolder().invoke(argument, range, newContent);
        String oldStart = filePathHolder.getOldStart();
        newContent = filePathHolder.getNewContent();
        String oldEnd = filePathHolder.getOldEnd();
        if (argument.isBracketArgument()) {
            newFullContent = oldStart + newContent + oldEnd;
        } else if (argument.isQuotedArgument()) {
            newFullContent = oldStart + (String)ESCAPER.fun((Object)newContent) + oldEnd;
            if (!newFullContent.startsWith("\"")) {
                newFullContent = StringUtil.wrapWithDoubleQuote((String)newFullContent);
            }
        } else {
            newFullContent = oldStart + (String)ESCAPER.fun((Object)newContent) + oldEnd;
            if (!newFullContent.startsWith("\"") && CMakeLiteralUtils.shouldBeInsideQuotes(newFullContent)) {
                newFullContent = StringUtil.wrapWithDoubleQuote((String)newFullContent);
            }
        }
        argument.replace(CMakeElementFactory.createArgumentRaw(argument.getProject(), newFullContent));
        return argument;
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull CMakeArgument element) {
        if (element.isQuotedArgument()) {
            return element.getContentsRange().shiftRight(-1).grown(-1);
        }
        return element.getContentsRange();
    }
}

