/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfo;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCCompilerKt;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerBase;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.PrecompiledInclude;
import com.jetbrains.cidr.lang.workspace.compiler.TempFilesPool;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.system.HostMachine;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u0000 ,2\u00020\u0001:\u0002,-B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J\u0014\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\rJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016JV\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\r2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\r2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\rJ\u001e\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0 H\u0016J\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001c0\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\rJ\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000bH\u0002J\b\u0010&\u001a\u0004\u0018\u00010\u000bJL\u0010'\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020$2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0 2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002\u00a8\u0006."}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/MSVCCompiler;", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerBase;", "executable", "Ljava/io/File;", "workingDir", "env", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "tempFilesPool", "Lcom/jetbrains/cidr/lang/workspace/compiler/TempFilesPool;", "(Ljava/io/File;Ljava/io/File;Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;Lcom/jetbrains/cidr/lang/workspace/compiler/TempFilesPool;)V", "buildMacrosFileTest", "", "defines", "", "collectHeaderPathsAndDefinesListFromCommandLine", "Lcom/jetbrains/cidr/lang/workspace/compiler/MSVCCompiler$HeaderSearchPathsAndDefines;", "args", "collectInfo", "Lcom/jetbrains/cidr/lang/workspace/compiler/CompilerInfo;", "languageKind", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "switches", "Lcom/jetbrains/cidr/lang/toolchains/CidrCompilerSwitches;", "output", "headersSearchPaths", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchPath;", "includedHeaders", "includesMapping", "Lcom/jetbrains/cidr/lang/workspace/compiler/PrecompiledInclude;", "warnLog", "filterOptions", "skipOptions", "", "getForceIncludeHeaders", "getIncludeMapping", "isSwitch", "", "parameter", "readVersion", "runCompiler", "originalSwitches", "requestSwitches", "environment", "runWithSkippedOptions", "Companion", "HeaderSearchPathsAndDefines", "intellij.cidr.projectModel"})
public final class MSVCCompiler
extends OCCompilerBase {
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final String readVersion() {
        return this.doReadVersion(CollectionsKt.emptyList(), (Function<ProcessOutput, String>)((Function)readVersion.1.INSTANCE));
    }

    @Override
    @NotNull
    public CompilerInfo collectInfo(@NotNull OCLanguageKind languageKind, @NotNull CidrCompilerSwitches switches) throws ExecutionException {
        CidrCompilerSwitches requestSwitches = new MSVCSwitchBuilder(null, false, 3, null).withLanguageKind(languageKind).withSwitches(switches).withSwitch("/Be").withSwitch("/Bd").withSwitch("/EP").build();
        boolean bl = false;
        bl = false;
        return this.runCompiler(languageKind, switches, requestSwitches, this.myEnvironment, false, new LinkedHashSet(), new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final CompilerInfo runCompiler(OCLanguageKind languageKind, CidrCompilerSwitches originalSwitches, CidrCompilerSwitches requestSwitches, CidrToolEnvironment environment, boolean runWithSkippedOptions, Set<String> skipOptions, List<String> warnLog) throws ExecutionException {
        Path it;
        boolean bl;
        boolean bl2;
        Path path;
        Path path2;
        CompilerInfo compilerInfo;
        void responseFile;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Path emptyFile = null;
        Path macroFile = null;
        try {
            void commandLine1;
            CidrCompilerSwitches requestSwitches2 = this.filterOptions(requestSwitches, skipOptions);
            String responseFileText = requestSwitches2.getCommandLineString(CidrCompilerSwitches.Format.MSVC_RESPONSE_FILE);
            HostMachine host = environment.getHostMachine();
            Path tempDir = host.getTempDirectory();
            responseFile.element = this.myTempFilesPool.writeToTempFile(host, responseFileText, tempDir, "response-file", "");
            Function1<Path, Pair<? extends GeneralCommandLine, ? extends String>> $fun$createCompilerExecutionCommandLine$1 = new Function1<Path, Pair<? extends GeneralCommandLine, ? extends String>>(this, environment, (Ref.ObjectRef)responseFile, responseFileText){
                final /* synthetic */ MSVCCompiler this$0;
                final /* synthetic */ CidrToolEnvironment $environment;
                final /* synthetic */ Ref.ObjectRef $responseFile;
                final /* synthetic */ String $responseFileText;

                @NotNull
                public final Pair<GeneralCommandLine, String> invoke(@NotNull Path parameter) {
                    GeneralCommandLine cl = new GeneralCommandLine();
                    this.$environment.prepare(cl, CidrToolEnvironment.PrepareFor.BUILD);
                    cl.setExePath(this.this$0.myExecutable.getPath());
                    cl.withWorkDirectory(this.this$0.myWorkingDirectory);
                    cl.addParameters(new String[]{"@" + this.$environment.toEnvPath(((Object)((Path)this.$responseFile.element).toAbsolutePath()).toString())});
                    cl.addParameters(new String[]{this.$environment.toEnvPath(((Object)parameter.toAbsolutePath()).toString())});
                    String userFriendlyCommandLine = cl.getCommandLineString() + " | @" + ((Path)this.$responseFile.element).getFileName() + '=' + this.$responseFileText;
                    return new Pair((Object)cl, (Object)userFriendlyCommandLine);
                }
                {
                    this.this$0 = mSVCCompiler;
                    this.$environment = cidrToolEnvironment;
                    this.$responseFile = objectRef;
                    this.$responseFileText = string;
                    super(1);
                }
            };
            emptyFile = this.myTempFilesPool.writeToTempFile(host, "", tempDir, "compiler-file", "");
            Pair<GeneralCommandLine, String> pair = $fun$createCompilerExecutionCommandLine$1.invoke(emptyFile);
            GeneralCommandLine generalCommandLine = (GeneralCommandLine)pair.component1();
            String userFriendlyCommandLine1 = (String)pair.component2();
            OCCompilerBase.LOG.debug("Running 1st pass compiler: " + userFriendlyCommandLine1);
            ProcessOutput output = OCCompilerBase.outCompilerRunner.run((GeneralCommandLine)commandLine1, environment);
            if (output.isTimeout()) {
                throw (Throwable)OCCompilerBase.throwCompilerTimeout(userFriendlyCommandLine1);
            }
            if (output.getExitCode() != 0) {
                if (runWithSkippedOptions) throw (Throwable)OCCompilerBase.throwCompilerError(output, userFriendlyCommandLine1);
                if (!MSVCCompilerKt.collectMSVCSkipOptions(output.getStderrLines(), skipOptions, warnLog)) throw (Throwable)OCCompilerBase.throwCompilerError(output, userFriendlyCommandLine1);
                if (OCCompilerBase.LOG.isDebugEnabled()) {
                    OCCompilerBase.LOG.debug("Re-running compiler with skipped options: " + CollectionsKt.joinToString$default((Iterable)skipOptions, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                }
            } else {
                void headersSearchPaths;
                void commandLine2;
                OCCompilerBase.checkCompilerOutput(output, userFriendlyCommandLine1);
                if (OCCompilerBase.LOG.isDebugEnabled()) {
                    OCCompilerBase.LOG.debug("Compiler 1st output: \n" + output.getStderr());
                }
                List<String> cmdArgs = Companion.parseArguments(output.getStderrLines());
                HeaderSearchPathsAndDefines headerSearchPathsAndDefines = this.collectHeaderPathsAndDefinesListFromCommandLine(cmdArgs);
                List<HeadersSearchPath> list = headerSearchPathsAndDefines.component1();
                List<String> definesList = headerSearchPathsAndDefines.component2();
                macroFile = this.myTempFilesPool.writeToTempFile(host, this.buildMacrosFileTest(definesList), tempDir, "compiler-file", "");
                Pair<GeneralCommandLine, String> pair2 = $fun$createCompilerExecutionCommandLine$1.invoke(macroFile);
                headerSearchPathsAndDefines = (GeneralCommandLine)pair2.component1();
                String userFriendlyCommandLine2 = (String)pair2.component2();
                OCCompilerBase.LOG.debug("Running 2st pass compiler");
                output = OCCompilerBase.outCompilerRunner.run((GeneralCommandLine)commandLine2, environment);
                OCCompilerBase.checkCompilerOutput(output, userFriendlyCommandLine2);
                List<File> includedHeaders = this.getForceIncludeHeaders(cmdArgs);
                List<PrecompiledInclude> includeMapping = this.getIncludeMapping(cmdArgs);
                OCCompilerBase.addEmulatedWarning(warnLog);
                CompilerInfo compilerInfo2 = this.collectInfo(languageKind, originalSwitches, output.getStdout(), (List<HeadersSearchPath>)headersSearchPaths, includedHeaders, includeMapping, warnLog);
                return compilerInfo2;
            }
            compilerInfo = this.runCompiler(languageKind, originalSwitches, requestSwitches2, environment, runWithSkippedOptions, skipOptions, warnLog);
            path2 = (Path)responseFile.element;
        }
        catch (IOException e) {
            throw (Throwable)new ExecutionException((Throwable)e);
        }
        if (path2 != null) {
            path = path2;
            bl2 = false;
            bl = false;
            it = path;
            boolean bl3 = false;
            this.myTempFilesPool.delete(it);
        }
        Path path3 = emptyFile;
        if (path3 == null) return compilerInfo;
        path = path3;
        bl2 = false;
        bl = false;
        it = path;
        boolean pair2 = false;
        this.myTempFilesPool.delete(it);
        return compilerInfo;
        finally {
            Path it2;
            Path path4;
            Path path5 = (Path)responseFile.element;
            if (path5 != null) {
                path4 = path5;
                boolean bl4 = false;
                boolean bl5 = false;
                it2 = path4;
                boolean bl6 = false;
                this.myTempFilesPool.delete(it2);
            }
            Path path6 = emptyFile;
            if (path6 != null) {
                path4 = path6;
                boolean bl7 = false;
                boolean bl8 = false;
                it2 = path4;
                $i$a$-let-MSVCCompiler$runCompiler$3 = false;
                this.myTempFilesPool.delete(it2);
            }
            Path path7 = macroFile;
            if (path7 != null) {
                path4 = path7;
                boolean bl9 = false;
                boolean bl10 = false;
                it2 = path4;
                boolean bl11 = false;
                this.myTempFilesPool.delete(it2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CidrCompilerSwitches filterOptions(@NotNull CidrCompilerSwitches switches, @NotNull Set<String> skipOptions) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv = skipOptions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!this.isSwitch(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List skipSwitches = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)SetsKt.setOf((Object[])new String[]{"/Fa", "/Fd", "/Fe", "/Fi", "/Fm", "/Fo", "/Fr", "/FR", "/doc"}));
        Iterable $this$filter$iv2 = skipOptions;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!this.isSwitch(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List skipValues = (List)destination$iv$iv2;
        BiFunction<String, String, Boolean> argumentsFilter2 = new BiFunction<String, String, Boolean>(this, skipValues, skipSwitches){
            private boolean skipOptionValue;
            final /* synthetic */ MSVCCompiler this$0;
            final /* synthetic */ List $skipValues;
            final /* synthetic */ List $skipSwitches;

            public final boolean getSkipOptionValue$intellij_cidr_projectModel() {
                return this.skipOptionValue;
            }

            public final void setSkipOptionValue$intellij_cidr_projectModel(boolean bl) {
                this.skipOptionValue = bl;
            }

            @NotNull
            public Boolean apply(@NotNull String parameter, @Nullable String nextParameter) {
                boolean tokenIsSwitch = MSVCCompiler.access$isSwitch(this.this$0, parameter);
                if (this.skipOptionValue) {
                    this.skipOptionValue = false;
                    if (!tokenIsSwitch) {
                        return false;
                    }
                }
                if (this.$skipValues.contains(parameter)) {
                    return false;
                }
                if (this.$skipSwitches.contains(parameter)) {
                    this.skipOptionValue = true;
                    return false;
                }
                Iterable $this$forEach$iv = this.$skipSwitches;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)parameter, (String)it, (boolean)false, (int)2, null)) continue;
                    return false;
                }
                if (Intrinsics.areEqual((Object)parameter, (Object)"/FI") && CollectionsKt.contains((Iterable)this.$skipValues, (Object)nextParameter)) {
                    return false;
                }
                if (StringsKt.startsWith$default((String)parameter, (String)"/FI", (boolean)false, (int)2, null)) {
                    String string = parameter;
                    int n = "/FI".length();
                    boolean bl = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                    if (this.$skipValues.contains(string3)) {
                        return false;
                    }
                }
                return true;
            }
            {
                this.this$0 = this$0;
                this.$skipValues = $captured_local_variable$1;
                this.$skipSwitches = $captured_local_variable$2;
            }
        };
        return switches.filterOptions(argumentsFilter2);
    }

    private final boolean isSwitch(String parameter) {
        return StringsKt.startsWith$default((String)parameter, (String)"/", (boolean)false, (int)2, null);
    }

    private final String buildMacrosFileTest(List<String> defines) {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("__cidr_defines_start__\n");
        Iterable $this$forEach$iv = new LinkedHashSet(CollectionsKt.plus((Collection)MSVCCompilerKt.access$getBUILT_IN_MACROS$p(), (Iterable)defines));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            builder2.append("#if (defined " + it + ")\n__cidr_define_" + it + ' ' + it + "\n#endif\n");
        }
        builder2.append("__cidr_defines_end__\n");
        return builder2.toString();
    }

    @NotNull
    public final HeaderSearchPathsAndDefines collectHeaderPathsAndDefinesListFromCommandLine(@NotNull List<String> args) {
        ArrayList<String> defines = new ArrayList<String>();
        ArrayList<HeadersSearchPath> headerPaths = new ArrayList<HeadersSearchPath>();
        boolean nextIsIncludePath = false;
        boolean nextIsBuiltInIncludePath = false;
        for (String each : args) {
            if (nextIsIncludePath || nextIsBuiltInIncludePath) {
                String path = FileUtil.resolveShortWindowsName((String)FileUtil.toCanonicalPath((String)each));
                File file2 = FileUtil.isAbsolute((String)path) ? new File(path) : new File(this.myWorkingDirectory, path);
                headerPaths.add(new HeadersSearchPath(file2, false, HeadersSearchPath.Kind.SYSTEM, false, nextIsBuiltInIncludePath));
                nextIsIncludePath = false;
                nextIsBuiltInIncludePath = false;
                continue;
            }
            nextIsIncludePath = Intrinsics.areEqual((Object)each, (Object)"-I");
            nextIsBuiltInIncludePath = Intrinsics.areEqual((Object)each, (Object)"-external:I");
            if (!StringsKt.startsWith$default((String)each, (String)"-D", (boolean)false, (int)2, null)) continue;
            int eq = StringsKt.indexOfAny$default((CharSequence)each, (char[])new char[]{'=', '(', ' '}, (int)0, (boolean)false, (int)6, null);
            String string = each;
            int n = 2;
            int n2 = eq > -1 ? eq : each.length();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = string3;
            n = 0;
            String string4 = string;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            defines.add(((Object)StringsKt.trim((CharSequence)string4)).toString());
        }
        return new HeaderSearchPathsAndDefines((List<HeadersSearchPath>)headerPaths, (List<String>)defines);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompilerInfo collectInfo(@NotNull OCLanguageKind languageKind, @NotNull CidrCompilerSwitches switches, @NotNull String output, @NotNull List<HeadersSearchPath> headersSearchPaths, @NotNull List<? extends File> includedHeaders, @NotNull List<PrecompiledInclude> includesMapping, @NotNull List<String> warnLog) {
        int version;
        LinkedHashMap features;
        String defines;
        block15: {
            block12: {
                Object object;
                OCCompilerFeatures.Type<OCLanguageStandard> type;
                Map map2;
                block14: {
                    block13: {
                        void it;
                        CharSequence $this$forEachIndexed$iv;
                        defines = "";
                        int definesStart = StringsKt.indexOf$default((CharSequence)output, (String)"__cidr_defines_start__\n", (int)0, (boolean)false, (int)6, null);
                        int definesEnd = StringsKt.indexOf$default((CharSequence)output, (String)"__cidr_defines_end__\n", (int)0, (boolean)false, (int)6, null);
                        if (definesStart > -1 && definesEnd > -1) {
                            String string = output;
                            int n = definesStart + "__cidr_defines_start__\n".length();
                            boolean bl = false;
                            String string2 = string;
                            if (string2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string3 = string2.substring(n, definesEnd);
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                            defines = string3;
                            StringBuilder builder2 = new StringBuilder();
                            boolean hasNewLine = false;
                            $this$forEachIndexed$iv = defines;
                            boolean $i$f$forEachIndexed = false;
                            int index$iv = 0;
                            CharSequence charSequence = $this$forEachIndexed$iv;
                            for (int j = 0; j < charSequence.length(); ++j) {
                                void c;
                                char item$iv = charSequence.charAt(j);
                                int n2 = index$iv++;
                                char c2 = item$iv;
                                int i2 = n2;
                                boolean bl2 = false;
                                if (c == 10) {
                                    if (hasNewLine) continue;
                                    if (i2 == 0 || defines.charAt(i2 - 1) != '\\') {
                                        hasNewLine = true;
                                    }
                                } else {
                                    hasNewLine = false;
                                }
                                builder2.append((char)c);
                            }
                            defines = builder2.toString();
                            $this$forEachIndexed$iv = defines;
                            Regex regex = new Regex("^__cidr_define_", RegexOption.MULTILINE);
                            String string4 = "#define ";
                            boolean bl3 = false;
                            defines = regex.replace($this$forEachIndexed$iv, string4);
                        }
                        features = new LinkedHashMap();
                        version = Companion.getMSCVersion(defines);
                        if (!languageKind.isCpp()) break block12;
                        map2 = features;
                        type = OCCompilerFeatures.LANGUAGE_STANDARD;
                        object = Companion.getMSVCLangVersion(defines);
                        if (object == null) break block13;
                        $this$forEachIndexed$iv = object;
                        boolean bl = false;
                        boolean bl4 = false;
                        String string = $this$forEachIndexed$iv;
                        OCCompilerFeatures.Type<OCLanguageStandard> type2 = type;
                        Map map3 = map2;
                        boolean bl5 = false;
                        OCLanguageStandard oCLanguageStandard = OCLanguageStandard.getCppStandard((String)it);
                        map2 = map3;
                        type = type2;
                        object = oCLanguageStandard;
                        if (object != null) break block14;
                    }
                    object = OCLanguageStandard.CPP11;
                }
                map2.put(type, object);
                break block15;
            }
            ((Map)features).put(OCCompilerFeatures.LANGUAGE_STANDARD, OCLanguageStandard.C11);
        }
        if (version < 1900) {
            ((Map)features).put(OCCompilerFeatures.Feature.CXX_CONSTEXPR, false);
            ((Map)features).put(OCCompilerFeatures.Feature.CXX_USER_LITERALS, false);
            ((Map)features).put(OCCompilerFeatures.Feature.CXX_BINARY_LITERALS, false);
            ((Map)features).put(OCCompilerFeatures.Feature.CXX_GENERIC_LAMBDAS, false);
            ((Map)features).put(OCCompilerFeatures.Feature.CXX_RETURN_TYPE_DEDUCTION, false);
        }
        if (version < 1800) {
            ((Map)features).put(OCCompilerFeatures.Feature.CXX_NONSTATIC_MEMBER_INIT, false);
            ((Map)features).put(OCCompilerFeatures.Feature.CXX_RAW_STRING_LITERALS, false);
        }
        ((Map)features).put(OCCompilerFeatures.Feature.IS_BASE_OF, true);
        boolean is64 = Companion.is64Bit(defines);
        ((Map)features).put(OCCompilerFeatures.TypeSize.WCHAR_T, (short)2);
        ((Map)features).put(OCCompilerFeatures.TypeSize.INT, (short)4);
        ((Map)features).put(OCCompilerFeatures.TypeSize.LONG, (short)4);
        ((Map)features).put(OCCompilerFeatures.TypeSize.LONG_LONG, (short)8);
        ((Map)features).put(OCCompilerFeatures.TypeSize.FLOAT, (short)4);
        ((Map)features).put(OCCompilerFeatures.TypeSize.DOUBLE, (short)8);
        ((Map)features).put(OCCompilerFeatures.TypeSize.LONG_DOUBLE, (short)8);
        ((Map)features).put(OCCompilerFeatures.TypeSize.SIZE_T, is64 ? (short)8 : 4);
        return new CompilerInfo(switches, defines, features, headersSearchPaths, includedHeaders, includesMapping, warnLog, 0, 128, null);
    }

    private final List<File> getForceIncludeHeaders(List<String> args) {
        String forceIncludeCmd = "-FI";
        LinkedHashSet<File> result2 = new LinkedHashSet<File>(1);
        for (int i2 = 0; i2 < args.size(); ++i2) {
            String arg = args.get(i2);
            if (!StringsKt.startsWith$default((String)arg, (String)forceIncludeCmd, (boolean)false, (int)2, null) || ++i2 >= args.size()) continue;
            String path = args.get(i2);
            File file2 = FileUtil.isWindowsAbsolutePath((String)path) ? new File(path) : new File(this.myWorkingDirectory, path);
            result2.add(file2);
        }
        return (List)new SmartList((Collection)result2);
    }

    @NotNull
    public final List<PrecompiledInclude> getIncludeMapping(@NotNull List<String> args) {
        String pchCreationCmd = "-Yc";
        String pchUsingCmd = "-Yu";
        String pchPathCmd = "-Fp";
        String precompileUntilHeaderName = null;
        String usePrecompiledHeadersUntilHeaderName = null;
        String customPchFilePath = null;
        int i2 = 0;
        while (i2 < args.size()) {
            String arg = args.get(i2);
            if (++i2 == args.size()) break;
            String nextArg = args.get(i2);
            boolean nextArgIsSwith = StringsKt.startsWith$default((CharSequence)nextArg, (char)'-', (boolean)false, (int)2, null);
            if (nextArgIsSwith) continue;
            String string = arg;
            if (Intrinsics.areEqual((Object)string, (Object)pchPathCmd)) {
                customPchFilePath = nextArg;
            } else if (Intrinsics.areEqual((Object)string, (Object)pchCreationCmd)) {
                precompileUntilHeaderName = nextArg;
            } else if (Intrinsics.areEqual((Object)string, (Object)pchUsingCmd)) {
                usePrecompiledHeadersUntilHeaderName = nextArg;
            }
            ++i2;
        }
        SmartList result2 = new SmartList();
        if (customPchFilePath != null) {
            File pchFile = FileUtil.isAbsolute((String)customPchFilePath) ? new File(customPchFilePath) : new File(this.myWorkingDirectory, customPchFilePath);
            String canonicalPCHPath = FileUtil.toCanonicalPath((String)pchFile.getPath());
            if (precompileUntilHeaderName != null) {
                result2.add((Object)new PrecompiledInclude(canonicalPCHPath, precompileUntilHeaderName, true));
            }
            if (usePrecompiledHeadersUntilHeaderName != null) {
                result2.add((Object)new PrecompiledInclude(canonicalPCHPath, usePrecompiledHeadersUntilHeaderName, false));
            }
        }
        return (List)result2;
    }

    public MSVCCompiler(@NotNull File executable, @NotNull File workingDir, @NotNull CidrToolEnvironment env, @NotNull TempFilesPool tempFilesPool) {
        super(executable, workingDir, env, tempFilesPool);
    }

    public static final /* synthetic */ boolean access$isSwitch(MSVCCompiler $this, String parameter) {
        return $this.isSwitch(parameter);
    }

    @JvmStatic
    public static final int getMSCVersion(@NotNull CharSequence defines) {
        return Companion.getMSCVersion(defines);
    }

    @JvmStatic
    @Nullable
    public static final String getMSVCLangVersion(@NotNull CharSequence defines) {
        return Companion.getMSVCLangVersion(defines);
    }

    @JvmStatic
    public static final boolean is64Bit(@NotNull CharSequence defines) {
        return Companion.is64Bit(defines);
    }

    @JvmStatic
    @NotNull
    public static final List<String> parseArguments(@NotNull List<String> lines) {
        return Companion.parseArguments(lines);
    }

    @JvmStatic
    private static final List<String> splitArguments(String line) {
        return MSVCCompiler.Companion.splitArguments(line);
    }

    @JvmStatic
    @Nullable
    public static final OCLanguageKind resolveLanguage(@NotNull List<String> switches) {
        return Companion.resolveLanguage(switches);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J)\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/MSVCCompiler$HeaderSearchPathsAndDefines;", "", "headersSearchPaths", "", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchPath;", "defines", "", "(Ljava/util/List;Ljava/util/List;)V", "getDefines", "()Ljava/util/List;", "getHeadersSearchPaths", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.cidr.projectModel"})
    public static final class HeaderSearchPathsAndDefines {
        @NotNull
        private final List<HeadersSearchPath> headersSearchPaths;
        @NotNull
        private final List<String> defines;

        @NotNull
        public final List<HeadersSearchPath> getHeadersSearchPaths() {
            return this.headersSearchPaths;
        }

        @NotNull
        public final List<String> getDefines() {
            return this.defines;
        }

        public HeaderSearchPathsAndDefines(@NotNull List<HeadersSearchPath> headersSearchPaths, @NotNull List<String> defines) {
            this.headersSearchPaths = headersSearchPaths;
            this.defines = defines;
        }

        @NotNull
        public final List<HeadersSearchPath> component1() {
            return this.headersSearchPaths;
        }

        @NotNull
        public final List<String> component2() {
            return this.defines;
        }

        @NotNull
        public final HeaderSearchPathsAndDefines copy(@NotNull List<HeadersSearchPath> headersSearchPaths, @NotNull List<String> defines) {
            return new HeaderSearchPathsAndDefines(headersSearchPaths, defines);
        }

        public static /* synthetic */ HeaderSearchPathsAndDefines copy$default(HeaderSearchPathsAndDefines headerSearchPathsAndDefines, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list = headerSearchPathsAndDefines.headersSearchPaths;
            }
            if ((n & 2) != 0) {
                list2 = headerSearchPathsAndDefines.defines;
            }
            return headerSearchPathsAndDefines.copy(list, list2);
        }

        @NotNull
        public String toString() {
            return "HeaderSearchPathsAndDefines(headersSearchPaths=" + this.headersSearchPaths + ", defines=" + this.defines + ")";
        }

        public int hashCode() {
            List<HeadersSearchPath> list = this.headersSearchPaths;
            List<String> list2 = this.defines;
            return (list != null ? ((Object)list).hashCode() : 0) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof HeaderSearchPathsAndDefines)) break block3;
                    HeaderSearchPathsAndDefines headerSearchPathsAndDefines = (HeaderSearchPathsAndDefines)object;
                    if (!Intrinsics.areEqual(this.headersSearchPaths, headerSearchPathsAndDefines.headersSearchPaths) || !Intrinsics.areEqual(this.defines, headerSearchPathsAndDefines.defines)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0007J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0007J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u0012\u001a\u00020\bH\u0003\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/MSVCCompiler$Companion;", "", "()V", "getMSCVersion", "", "defines", "", "getMSVCLangVersion", "", "is64Bit", "", "parseArguments", "", "lines", "resolveLanguage", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "switches", "splitArguments", "line", "intellij.cidr.projectModel"})
    public static final class Companion {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public final int getMSCVersion(@NotNull CharSequence defines) {
            MatchResult matchResult = Regex.find$default((Regex)new Regex("#define\\s+_MSC_VER\\s+(\\d+)"), (CharSequence)defines, (int)0, (int)2, null);
            Object object = matchResult;
            if (matchResult == null) return 0;
            MatchResult matchResult2 = object;
            boolean bl = false;
            boolean bl2 = false;
            MatchResult it = matchResult2;
            boolean bl3 = false;
            Integer n = Integer.valueOf((String)it.getGroupValues().get(1));
            object = n;
            if (n == null) return 0;
            int n2 = (Integer)object;
            return n2;
        }

        @JvmStatic
        @Nullable
        public final String getMSVCLangVersion(@NotNull CharSequence defines) {
            String string;
            MatchResult matchResult = Regex.find$default((Regex)new Regex("#define\\s+_MSVC_LANG\\s+(\\d+L?)"), (CharSequence)defines, (int)0, (int)2, null);
            if (matchResult != null) {
                MatchResult matchResult2 = matchResult;
                boolean bl = false;
                boolean bl2 = false;
                MatchResult it = matchResult2;
                boolean bl3 = false;
                string = (String)it.getGroupValues().get(1);
            } else {
                string = null;
            }
            return string;
        }

        @JvmStatic
        public final boolean is64Bit(@NotNull CharSequence defines) {
            boolean bl;
            MatchResult matchResult = Regex.find$default((Regex)new Regex("#define\\s+_WIN64\\s+1"), (CharSequence)defines, (int)0, (int)2, null);
            if (matchResult != null) {
                MatchResult matchResult2 = matchResult;
                boolean bl2 = false;
                boolean bl3 = false;
                MatchResult it = matchResult2;
                boolean bl4 = false;
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        @JvmStatic
        @NotNull
        public final List<String> parseArguments(@NotNull List<String> lines) {
            String builtinIncludesCmd;
            Object v3;
            boolean bl;
            List args;
            block9: {
                Object v0;
                boolean bl2;
                Iterable iterable;
                block8: {
                    Iterable iterable2 = lines;
                    boolean bl3 = false;
                    iterable = iterable2;
                    bl2 = false;
                    for (Object t : iterable) {
                        String it = (String)t;
                        boolean bl4 = false;
                        if (!(StringsKt.startsWith$default((String)it, (String)"`", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)it, (String)"'", (boolean)false, (int)2, null))) continue;
                        v0 = t;
                        break block8;
                    }
                    v0 = null;
                }
                String string = v0;
                if (string == null) {
                    return CollectionsKt.emptyList();
                }
                String cmd = string;
                args = CollectionsKt.toMutableList((Collection)this.splitArguments(StringsKt.trimEnd((String)StringsKt.trimStart((String)cmd, (char[])new char[]{'`'}), (char[])new char[]{'\''})));
                iterable = lines;
                bl2 = false;
                Iterable iterable3 = iterable;
                bl = false;
                Iterator iterator2 = iterable3.iterator();
                while (iterator2.hasNext()) {
                    Object t = iterator2.next();
                    String it = (String)t;
                    boolean bl5 = false;
                    String string2 = it;
                    boolean bl6 = false;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    if (!StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)string3)).toString(), (String)"@set INCLUDE=", (boolean)false, (int)2, null)) continue;
                    v3 = t;
                    break block9;
                }
                v3 = null;
            }
            String string = v3;
            if (string == null) {
                return CollectionsKt.emptyList();
            }
            String string4 = builtinIncludesCmd = string;
            int n = 0;
            String string5 = string4;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string4 = ((Object)StringsKt.trimStart((CharSequence)string5)).toString();
            n = "@set INCLUDE=".length();
            bl = false;
            String string6 = string4;
            if (string6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
            List builtinIncludes = StringsKt.split$default((CharSequence)string7, (char[])new char[]{';'}, (boolean)false, (int)0, (int)6, null);
            for (String builtinInclude : builtinIncludes) {
                int includeIndex = args.indexOf(builtinInclude);
                if (includeIndex <= 0) continue;
                args.set(includeIndex - 1, "-external:I");
            }
            return args;
        }

        @JvmStatic
        private final List<String> splitArguments(String line) {
            ArrayList<String> result2 = new ArrayList<String>();
            List raw = ParametersListUtil.parse((String)line);
            StringBuilder parsingArgument = new StringBuilder();
            for (String eachArg : raw) {
                int n;
                CharSequence charSequence;
                if (StringsKt.startsWith$default((String)eachArg, (String)"-", (boolean)false, (int)2, null)) {
                    charSequence = parsingArgument;
                    n = 0;
                    if (charSequence.length() > 0) {
                        result2.add(parsingArgument.toString());
                        parsingArgument.setLength(0);
                    }
                    if (StringsKt.startsWith$default((String)eachArg, (String)"-Yc", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)eachArg, (String)"-Yu", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)eachArg, (String)"-Fp", (boolean)false, (int)2, null)) {
                        charSequence = eachArg;
                        n = 0;
                        int n2 = 3;
                        boolean bl = false;
                        CharSequence charSequence2 = charSequence;
                        if (charSequence2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string = ((String)charSequence2).substring(n, n2);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        result2.add(string);
                        if (eachArg.length() <= 3) continue;
                        charSequence = eachArg;
                        n = 3;
                        n2 = 0;
                        CharSequence charSequence3 = charSequence;
                        if (charSequence3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string2 = ((String)charSequence3).substring(n);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                        parsingArgument.append(string2);
                        continue;
                    }
                    result2.add(eachArg);
                    continue;
                }
                charSequence = parsingArgument;
                n = 0;
                if (charSequence.length() > 0) {
                    parsingArgument.append(" ");
                }
                parsingArgument.append(eachArg);
            }
            CharSequence charSequence = parsingArgument;
            boolean bl = false;
            if (charSequence.length() > 0) {
                result2.add(parsingArgument.toString());
            }
            return result2;
        }

        @JvmStatic
        @Nullable
        public final OCLanguageKind resolveLanguage(@NotNull List<String> switches) {
            Object v0;
            block1: {
                Iterable iterable = switches;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    String it = (String)t;
                    boolean bl3 = false;
                    if (!(StringsKt.startsWith((String)it, (String)"/Tc", (boolean)true) || StringsKt.startsWith((String)it, (String)"/Tp", (boolean)true))) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            String string = v0;
            return string == null ? null : (StringsKt.startsWith((String)string, (String)"/Tc", (boolean)true) ? (OCLanguageKind)CLanguageKind.C : (OCLanguageKind)CLanguageKind.CPP);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

