/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.util.Processor;
import com.intellij.util.containers.MostlySingularMultiMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class OCMostlySingularMultiUniqueMap<K, V>
extends MostlySingularMultiMap<K, V> {
    private final Set<V> myAllValues = new ObjectOpenHashSet();

    public void add(@NotNull K key, @NotNull V value) {
        if (this.myAllValues.add(value)) {
            super.add(key, value);
        }
    }

    public boolean addIfAbsent(@NotNull K key, @NotNull V value) {
        if (this.myAllValues.add(value)) {
            super.add(key, value);
            return true;
        }
        return false;
    }

    public boolean processAllValues(@NotNull Processor<? super V> p) {
        for (V t : this.myAllValues) {
            if (p.process(t)) continue;
            return false;
        }
        return true;
    }

    public boolean remove(@NotNull K key, @NotNull V value) {
        this.myAllValues.remove(value);
        return super.remove(key, value);
    }

    public boolean removeAllValues(@NotNull K key) {
        this.processForKey(key, v -> {
            this.myAllValues.remove(v);
            return true;
        });
        return super.removeAllValues(key);
    }

    public void addAll(@NotNull MostlySingularMultiMap<K, V> other) {
        for (Object key : other.keySet()) {
            other.processForKey(key, value -> {
                this.add(key, value);
                return true;
            });
        }
    }

    public void compact() {
        ((ObjectOpenHashSet)this.myAllValues).trim();
        super.compact();
    }

    public void clear() {
        this.myAllValues.clear();
        super.clear();
    }

    @NotNull
    public Collection<V> getAllValues() {
        return Collections.unmodifiableCollection(this.myAllValues);
    }
}

