/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbolImpl;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceAliasSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.types.FindConstructorResult;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCStructType
extends OCType {
    @NotNull
    private List<OCStructSymbol> myStructs;
    @Nullable
    private String myTypedefName;
    @Nullable
    private List<OCTypeArgument> myArguments;

    public OCStructType() {
    }

    public OCStructType(@NotNull OCStructSymbol structs) {
        this(structs, null);
    }

    public OCStructType(@NotNull List<OCStructSymbol> structs) {
        this.myStructs = structs;
        this.myTypedefName = null;
    }

    public OCStructType(@NotNull OCStructSymbol structs, @Nullable String typedefName) {
        this.myStructs = Collections.singletonList(structs);
        this.myTypedefName = typedefName;
    }

    public OCStructType(@NotNull List<OCStructSymbol> structs, @Nullable String typedefName, @Nullable List<OCTypeArgument> arguments) {
        this(structs, typedefName, false, false);
        this.myArguments = arguments;
    }

    public OCStructType(@NotNull List<OCStructSymbol> structs, @Nullable String typedefName, boolean isConst, boolean isVolatile, @Nullable List<OCTypeArgument> arguments) {
        this(structs, typedefName, isConst, isVolatile);
        this.myArguments = arguments;
    }

    public OCStructType(@NotNull List<OCStructSymbol> structs, @Nullable String typedefName, boolean isConst, boolean isVolatile) {
        super(isConst, isVolatile);
        this.myStructs = structs;
        this.myTypedefName = typedefName;
    }

    @NotNull
    public Collection<OCSymbol> collectMethods(@NotNull String methodName, OCResolveContext context2) {
        CommonProcessors.CollectProcessor<OCSymbol> collector = new CommonProcessors.CollectProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return symbol instanceof OCFunctionSymbol;
            }
        };
        this.processMembers(methodName, (Processor<? super OCSymbol>)collector, context2);
        return collector.getResults();
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCStructType f = (OCStructType)first;
        OCStructType s = (OCStructType)second;
        if (!Objects.equals(f.myTypedefName, s.myTypedefName)) {
            return false;
        }
        return c.equalLists(f.myStructs, s.myStructs);
    }

    @Override
    public int hashCode() {
        return this.baseHashCode() * 31 + this.myStructs.get(0).hashCode();
    }

    public List<OCStructSymbol> getStructs() {
        return this.myStructs;
    }

    @Nullable
    public String getTypedefName() {
        return this.myTypedefName;
    }

    @NotNull
    public OCStructSymbol getSymbol() {
        return this.myStructs.get(0);
    }

    @Nullable
    public List<OCTypeArgument> getArguments() {
        return this.myArguments;
    }

    @Nullable
    public List<OCTypeArgument> getResolvedArguments(@NotNull OCResolveContext context2) {
        if (this.myArguments == null) {
            return null;
        }
        ArrayList<OCTypeArgument> result2 = new ArrayList<OCTypeArgument>();
        for (OCTypeArgument myArgument : this.myArguments) {
            result2.add(OCSimpleTypeSubstitution.resolveTypeArgument(myArgument, context2));
        }
        return result2;
    }

    @NotNull
    public OCSymbolKind getKind() {
        return this.myStructs.get(0).getKind();
    }

    public boolean isEnumClass() {
        return this.myStructs.get(0).isEnumClass();
    }

    public boolean isEnum() {
        return this.myStructs.get(0).isEnum();
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitStructType(this);
    }

    @Nullable
    public OCDeclaratorSymbol findField(String name) {
        for (OCStructSymbol struct : this.myStructs) {
            OCDeclaratorSymbol field = struct.findField(name);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    @NotNull
    public List<OCDeclaratorSymbol> getFields() {
        CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
        this.myStructs.get(0).processFields((Processor<? super OCDeclaratorSymbol>)collector);
        List results = (List)collector.getResults();
        results.sort(Comparator.comparingLong(OCSymbol::getComplexOffset));
        return results;
    }

    @NotNull
    public FindConstructorResult findConstructor(@NotNull OCArgumentsList<?> arguments, @NotNull OCResolveContext context2, @Nullable PsiElement localContext, boolean allowImplicitConversions, @Nullable Supplier<Boolean> isExplicitCall, boolean isListInitialization) {
        return this.getSymbol().findConstructor(arguments, context2, localContext, allowImplicitConversions, isExplicitCall, isListInitialization, this);
    }

    public boolean isEmpty(@NotNull OCResolveContext context2) {
        return this.isEmpty(new HashSet<OCStructSymbol>(), context2);
    }

    public boolean isEmpty(HashSet<OCStructSymbol> processed, @NotNull OCResolveContext context2) {
        boolean[] result2 = new boolean[]{true};
        for (OCStructSymbol struct : this.myStructs) {
            if (processed.add(struct)) {
                if (struct.getKind() == OCSymbolKind.ENUM) {
                    return false;
                }
                struct.processFields((Processor<? super OCDeclaratorSymbol>)((Processor)symbol -> {
                    if (symbol.getKind() != OCSymbolKind.STRUCT_FIELD || symbol.isStatic()) {
                        return true;
                    }
                    OCType elementType = symbol.getResolvedType(context2);
                    if (elementType instanceof OCArrayType) {
                        if (!((OCArrayType)elementType).isEmpty(processed, context2)) {
                            result2[0] = false;
                        }
                    } else if (elementType instanceof OCStructType) {
                        if (!((OCStructType)elementType).isEmpty(processed, context2)) {
                            result2[0] = false;
                        }
                    } else {
                        result2[0] = false;
                    }
                    return true;
                }));
                processed.remove(struct);
                continue;
            }
            return false;
        }
        return result2[0];
    }

    public boolean processFields(@Nullable String fieldName, Processor<? super OCDeclaratorSymbol> processor2, OCResolveContext context2) {
        return this.processMembers(fieldName, (Processor<? super OCSymbol>)((Processor)ocSymbol -> {
            if (ocSymbol instanceof OCDeclaratorSymbol) {
                return processor2.process((Object)((OCDeclaratorSymbol)ocSymbol));
            }
            return true;
        }), context2);
    }

    public boolean isAbstract() {
        return !this.getSymbol().processMembers((String)null, (Processor<? super OCSymbol>)((Processor)symbol -> !(symbol instanceof OCFunctionSymbol) || !((OCFunctionSymbol)symbol).isPureVirtual()));
    }

    public boolean isUnnamed() {
        return this.myStructs.get(0).isUnnamed();
    }

    public boolean isPredeclaration() {
        for (OCStructSymbol struct : this.myStructs) {
            if (struct.isPredeclaration()) continue;
            return false;
        }
        return true;
    }

    public boolean isPOD(boolean checkInnerStructs, @NotNull OCResolveContext context2) {
        return !ContainerUtil.exists(this.myStructs, symbol -> !symbol.isPOD(checkInnerStructs, context2));
    }

    public static boolean processMembersInBaseTypes(@NotNull OCStructSymbol scope, @Nullable String memberName, boolean typesOnly, boolean goTransitive, @NotNull Condition<? super OCSymbol> condition, @NotNull Processor<? super OCSymbol> processor2, @NotNull OCResolveContext context2) {
        HashSet processedSet;
        Set processed = OCTypeUtils.newSymbolWithSubstitutionSet();
        Stack workset = new Stack();
        FilteringProcessor filteringProcessor = new FilteringProcessor(condition, processor2);
        if (!goTransitive && memberName == null) {
            processedSet = new HashSet();
            goTransitive = true;
        } else {
            processedSet = null;
        }
        processed.add(scope);
        workset.add((Object)new Pair((Object)scope, processedSet));
        while (!workset.isEmpty()) {
            ProgressManager.checkCanceled();
            Pair pair = (Pair)workset.pop();
            if (!(pair.getFirst() instanceof OCStructSymbol)) continue;
            OCStructSymbol structSymbol = (OCStructSymbol)pair.getFirst();
            boolean finalGoTransitive = goTransitive;
            if (structSymbol.processBaseClasses(context2.useFor(scope), (symbol, visibility) -> {
                if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppConstructor() && symbol.getName().equals(memberName) && !filteringProcessor.process((Object)symbol)) {
                    return false;
                }
                HashSet<String> alreadyProcessed = pair.getSecond() != null ? new HashSet<String>((Collection)pair.getSecond()) : null;
                InnerProcessor resolver = new InnerProcessor(memberName, typesOnly, finalGoTransitive, alreadyProcessed, scope.getSubstitution(), processed, (Stack<? super Pair<OCNamespaceLikeSymbol, Set<String>>>)workset, processor2, condition, context2);
                return resolver.process(symbol);
            })) continue;
            return false;
        }
        return true;
    }

    public static boolean processMembersOfNamespace(@NotNull OCNamespaceLikeSymbol namespace, @Nullable String memberName, boolean lookInsideUsings, boolean typesOnly, Processor<? super OCSymbol> processor2, @NotNull OCResolveContext context2) {
        return OCStructType.processMembersOfNamespace(namespace, memberName, true, lookInsideUsings, true, typesOnly, processor2, null, true, context2);
    }

    public static boolean processMembersOfNamespace(@NotNull OCNamespaceLikeSymbol namespace, @Nullable String memberName, boolean lookForMembers, boolean lookInsideUsings, boolean lookIntoBaseClasses, boolean typesOnly, Processor<? super OCSymbol> processor2, @Nullable OCSymbolReference usageReference, boolean handleInjectedClasses, @NotNull OCResolveContext context2) {
        ProgressManager.checkCanceled();
        class SomethingProcessedDetector
        implements Processor<OCSymbol> {
            private final Processor<? super OCSymbol> myProcessor;
            private boolean mySomethingProcessed = false;
            private boolean myNamespaceProcessed = false;

            SomethingProcessedDetector(Processor<? super OCSymbol> processor2) {
                this.myProcessor = processor2;
            }

            public boolean process(OCSymbol symbol) {
                if (symbol.getKind() != OCSymbolKind.SYMBOL_USING_SYMBOL) {
                    this.mySomethingProcessed = true;
                }
                if (symbol.getKind() == OCSymbolKind.NAMESPACE) {
                    this.myNamespaceProcessed = true;
                }
                return this.myProcessor.process((Object)symbol);
            }
        }
        SomethingProcessedDetector detector = new SomethingProcessedDetector(processor2);
        FilteringProcessor filter = new FilteringProcessor(OCSymbolWithQualifiedName.WITHOUT_QUALIFIER, (Processor)detector);
        if (lookForMembers && !namespace.processMembers(memberName, new FriendsFilter(namespace, (Processor<? super OCSymbol>)filter))) {
            return false;
        }
        Set processed = OCTypeUtils.newSymbolWithSubstitutionSet();
        Stack workset = new Stack();
        processed.add(namespace);
        workset.add((Object)new Pair((Object)namespace, null));
        Collection<OCNamespaceSymbol> inlineNamespaces = namespace.getInlineNamespaces();
        if (lookInsideUsings && inlineNamespaces != null && (!detector.myNamespaceProcessed || memberName == null)) {
            for (OCNamespaceSymbol inlineNamespace : inlineNamespaces) {
                OCStructType.processMembersOfNamespace(inlineNamespace, memberName, true, typesOnly, processor2, context2);
            }
        }
        if (!(!lookInsideUsings || namespace.getNamespaceUsings() == null && inlineNamespaces == null || detector.myNamespaceProcessed && memberName != null)) {
            while (!workset.isEmpty()) {
                ProgressManager.checkCanceled();
                Pair pair = (Pair)workset.pop();
                Collection<OCUsingSymbol> namespaceUsings = ((OCNamespaceLikeSymbol)pair.getFirst()).getNamespaceUsings();
                if (namespaceUsings == null) continue;
                for (OCUsingSymbol using : namespaceUsings) {
                    List<OCSymbol> list;
                    ProgressManager.checkCanceled();
                    InnerProcessor resolver = new InnerProcessor(memberName, typesOnly, true, null, OCTypeSubstitution.ID, processed, (Stack<? super Pair<OCNamespaceLikeSymbol, Set<String>>>)workset, processor2, (Condition<? super OCSymbol>)Conditions.alwaysTrue(), context2);
                    OCSymbolReference reference = using.getSymbolReference();
                    if (usageReference != null && reference instanceof OCSymbolReference.GlobalReference) {
                        OCSymbolReference.GlobalReference globalReference = (OCSymbolReference.GlobalReference)reference;
                        if (usageReference.getOffset() != -1L && Comparing.equal((Object)globalReference.getVirtualFile(), (Object)usageReference.getVirtualFile()) && globalReference.getOffset() >= usageReference.getOffset()) continue;
                        List<String> usageName = usageReference.getQualifiedName().flatten();
                        List<String> usingName = reference.getQualifiedName().flatten();
                        if (ContainerUtil.startsWith(usingName, (List)usageName)) continue;
                        reference = new OCSymbolReference.UsingReference(globalReference.getQualifiedName(), globalReference.getSymbolContext(), usageReference.getVirtualFile(), usageReference.getOffset(), globalReference.getFilter(), globalReference.getVirtualFile(), globalReference.getOffset());
                    }
                    if ((list = context2.resolveToSymbols(reference, false, typesOnly)).isEmpty() && context2.isOriginallyProcessNonImported() && !context2.isProcessNonImported()) {
                        context2.setProcessNonImported(true);
                        list = context2.resolveToSymbols(reference, false, typesOnly);
                        context2.setProcessNonImported(false);
                    }
                    for (OCSymbol symbol : list) {
                        ProgressManager.checkCanceled();
                        if (resolver.process(symbol)) continue;
                        return false;
                    }
                }
            }
        }
        if (namespace instanceof OCStructSymbol) {
            if (handleInjectedClasses && ((OCStructSymbol)namespace).getName().equals(memberName) && !processor2.process((Object)((OCStructSymbol)namespace))) {
                return false;
            }
            OCStructSymbol struct = (OCStructSymbol)namespace;
            boolean isAssignmentOperator = "operator=".equals(memberName);
            if (!typesOnly) {
                Processor msvcAnonymousStructureFinder;
                OCStructType ownType;
                OCCppReferenceType constRefToOwnType;
                OCFile file2 = struct.getContainingOCFile(context2.getProject());
                if (struct.getKind() == OCSymbolKind.STRUCT && isAssignmentOperator && struct.processMembers(memberName, (Processor<? super OCSymbol>)new CommonProcessors.FindFirstProcessor<OCSymbol>(constRefToOwnType = OCCppReferenceType.to((ownType = new OCStructType(struct)).cloneWithConstModifier(context2.getProject())), context2){
                    final /* synthetic */ OCCppReferenceType val$constRefToOwnType;
                    final /* synthetic */ OCResolveContext val$context;
                    {
                        this.val$constRefToOwnType = oCCppReferenceType;
                        this.val$context = oCResolveContext;
                    }

                    protected boolean accept(OCSymbol symbol) {
                        if (!(symbol instanceof OCFunctionSymbol)) {
                            return false;
                        }
                        List<OCType> args = ((OCFunctionSymbol)symbol).getType().getParameterTypes();
                        return args.size() == 1 && args.get(0).equalsAfterResolving(this.val$constRefToOwnType, this.val$context);
                    }
                }) && struct.processMembers("operator=", (Processor<? super OCSymbol>)new CommonProcessors.FindFirstProcessor())) {
                    OCFunctionType functionType = new OCFunctionType(OCCppReferenceType.to(ownType), Collections.singletonList(constRefToOwnType));
                    int attributes = OCSymbolAttribute.EXPLICIT.getMask();
                    OCDeclaratorSymbolImpl paramSymbol = new OCDeclaratorSymbolImpl(null, -1L, null, OCQualifiedName.interned("<unnamed>"), Collections.emptyList(), constRefToOwnType, OCSymbolKind.PARAMETER, null, Collections.emptyList(), Collections.emptyList(), OCDeclaratorSymbol.Property.IS_SYNTHETIC.ordinal(), 0, null, null);
                    processor2.process((Object)new OCFunctionSymbol(struct.getContainingFile(), struct.getComplexOffset(), struct, OCQualifiedName.with(memberName), Collections.emptyList(), Collections.emptyList(), 0, attributes, Collections.emptyList(), functionType, Collections.emptyList(), OCSymbolKind.FUNCTION_DECLARATION, OCVisibility.PUBLIC));
                }
                if ((struct.getKind() == OCSymbolKind.STRUCT || struct.getKind() == OCSymbolKind.UNION) && file2 != null && context2.isMsvcExtensionsCapable() && !file2.isCpp() && OCCompilerFeaturesHelper.isFeatureEnabled(file2, OCCompilerFeatures.Feature.MS_EXTENSIONS) && !namespace.processMembers(null, msvcAnonymousStructureFinder = memberSymbol -> {
                    OCStructSymbol symbol;
                    OCType type;
                    if (memberSymbol instanceof OCDeclaratorSymbol && memberSymbol.isUnnamed() && (type = memberSymbol.getType().resolve(context2)) instanceof OCStructType && !(symbol = ((OCStructType)type).getSymbol()).isEnum()) {
                        return OCStructType.processMembersOfNamespace(symbol, memberName, false, false, processor2, context2);
                    }
                    return true;
                })) {
                    return false;
                }
            }
            if (!(!lookIntoBaseClasses || isAssignmentOperator || detector.mySomethingProcessed && memberName != null || OCStructType.processMembersInBaseTypes(struct, memberName, typesOnly, true, (Condition<? super OCSymbol>)Conditions.alwaysTrue(), processor2, context2))) {
                return false;
            }
        }
        return true;
    }

    public boolean processMembers(@Nullable String memberName, Processor<? super OCSymbol> processor2, @NotNull OCResolveContext context2) {
        for (OCStructSymbol struct : this.myStructs) {
            if (OCStructType.processMembersOfNamespace(struct, memberName, true, false, processor2, context2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSubstructOf(OCStructSymbol struct, OCStructSymbol substruct, @NotNull OCResolveContext context2) {
        return Comparing.equal((Object)struct, (Object)substruct) || !substruct.processAllBaseClasses(context2, (symbol, visibility) -> !symbol.equals(struct), true);
    }

    @Override
    public boolean isMagicInside(@NotNull OCResolveContext context2) {
        return this.isMagicInside(context2, true);
    }

    @Override
    public boolean isSubclassOfMagic(@NotNull OCResolveContext context2) {
        return this.isMagicInside(context2, false);
    }

    public boolean isMagicInside(@NotNull OCResolveContext context2, boolean checkTemplateArgs) {
        for (OCStructSymbol struct : this.myStructs) {
            if (checkTemplateArgs && OCResolveUtil.hasNonResolvedTemplateParameters(struct, context2)) {
                return true;
            }
            if (struct.getBaseCppClasses(context2).isEmpty() && this.myStructs.size() <= 1) {
                return false;
            }
            OCSymbolWithQualifiedName current = struct;
            boolean hasTemplateInParent = false;
            while (current instanceof OCStructSymbol) {
                OCStructSymbol currentStruct = current;
                if (!currentStruct.getTemplateParameters().isEmpty()) {
                    hasTemplateInParent = true;
                    break;
                }
                current = currentStruct.getResolvedOwner(context2);
            }
            if (!hasTemplateInParent && this.myStructs.size() <= 1) {
                return false;
            }
            if (struct.processAllBaseClasses(context2, (symbol, visibility) -> !(symbol instanceof OCTypeParameterSymbol), true)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSeveralSpecializations() {
        int nonPredefsCnt = 0;
        for (OCStructSymbol struct : this.myStructs) {
            if (struct.isPredefinition()) continue;
            ++nonPredefsCnt;
        }
        return nonPredefsCnt > 1;
    }

    @Override
    public boolean isScalar() {
        return this.getKind() == OCSymbolKind.ENUM;
    }

    @Override
    public boolean isCppStructType(@NotNull OCCompilationContext context2) {
        return this.getKind() == OCSymbolKind.STRUCT && context2.isCpp();
    }

    @Override
    public boolean isNumberCompatible(@NotNull OCResolveContext context2) {
        return super.isNumberCompatible(context2) || this.getKind() == OCSymbolKind.ENUM && !this.isEnumClass();
    }

    @Override
    public boolean isIntegerCompatible(@NotNull OCResolveContext context2, boolean checkCppConvertible) {
        return super.isIntegerCompatible(context2, checkCppConvertible) || this.getKind() == OCSymbolKind.ENUM && !this.isEnumClass();
    }

    @Override
    @NotNull
    public String getDefaultValue(@NotNull OCResolveContext context2) {
        if (this.getKind() == OCSymbolKind.ENUM) {
            CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
            this.myStructs.get(0).processFields((Processor<? super OCDeclaratorSymbol>)finder);
            if (finder.isFound()) {
                return this.getDefaultEnumValue((OCSymbol)finder.getFoundValue(), context2);
            }
        } else if (this.getKind() == OCSymbolKind.STRUCT) {
            OCStructSymbol symbol = this.getSymbol();
            if (this.isCppStructType(context2)) {
                CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
                OCCommonProcessors.OrderedProcessor orderedProcessor = new OCCommonProcessors.OrderedProcessor(finder, (Condition<T>[])new Condition[]{symbol12 -> symbol12.canBeCalledWithoutArguments() && symbol12.getVisibility() == OCVisibility.PUBLIC, symbol1 -> symbol1.getVisibility() == OCVisibility.PUBLIC, Conditions.alwaysTrue()});
                symbol.processConstructors(orderedProcessor, context2);
                orderedProcessor.finish();
                OCStructType nakedType = (OCStructType)this.cloneWithoutCVQualifiers(context2.getProject());
                String typedefed = nakedType.getTypedefName();
                String aliased = nakedType.getAliasName();
                String hint = typedefed != null ? typedefed : aliased;
                String bestName = nakedType.getBestNameInContext(context2, hint);
                StringBuilder builder2 = new StringBuilder(bestName);
                builder2.append("(");
                if (finder.isFound()) {
                    boolean isFirst = true;
                    for (OCDeclaratorSymbol parameter : ((OCFunctionSymbol)finder.getFoundValue()).getParameterSymbols()) {
                        OCType type;
                        if (parameter.hasInitializer()) break;
                        if (!isFirst) {
                            builder2.append(",");
                        }
                        if ((type = parameter.getResolvedType(context2)).isCppStructType(context2)) {
                            String name;
                            if (type instanceof OCCppReferenceType) {
                                type = ((OCCppReferenceType)type).getRefType();
                            }
                            if (type instanceof OCStructType) {
                                OCQualifiedName qualifiedName = ((OCStructType)type).getSymbol().getResolvedQualifiedName(context2);
                                qualifiedName = qualifiedName != null ? qualifiedName : symbol.getQualifiedName();
                                name = qualifiedName.getNameWithParent();
                            } else {
                                name = type.getName();
                            }
                            builder2.append(name).append("()");
                        } else {
                            builder2.append(type.getDefaultValue(context2));
                        }
                        isFirst = false;
                    }
                }
                builder2.append(")");
                return builder2.toString();
            }
        }
        return "result";
    }

    @Override
    @Nullable
    public String getFormatString() {
        return this.getKind() == OCSymbolKind.ENUM ? "%d" : super.getFormatString();
    }

    @Override
    @NotNull
    protected OCType doGetLeastCommonType(OCType type, @NotNull OCResolveContext context2) {
        if (type == null) {
            return OCUnknownType.INSTANCE;
        }
        if (this.equals(type, context2)) {
            return this;
        }
        if (type instanceof OCMagicType) {
            return this;
        }
        if (this.getKind() == OCSymbolKind.ENUM && type.isPointerCompatible(context2)) {
            return OCIntType.INT;
        }
        if (this.getKind() == OCSymbolKind.ENUM && type instanceof OCStructType && ((OCStructType)type).getKind() == OCSymbolKind.ENUM) {
            return OCIntType.INT;
        }
        return OCUnknownType.INSTANCE;
    }

    @Override
    public boolean isInstanceable() {
        return true;
    }

    @Override
    public boolean isUnresolved(@NotNull OCResolveContext context2) {
        for (OCTypeArgument argument : this.getSymbol().getTemplateArguments(context2)) {
            if (!(argument instanceof OCType) || !((OCType)argument).isUnresolved(context2)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private String getDefaultEnumValue(@NotNull OCSymbol defaultEnumValue, @NotNull OCResolveContext context2) {
        if (this.isEnumClass()) {
            return this.getName(context2) + "::" + defaultEnumValue.getName();
        }
        String bestNameInContext = this.getBestNameInContext(context2);
        int namespaceIndex = bestNameInContext.lastIndexOf("::");
        String namespacePrefix = namespaceIndex >= 0 ? bestNameInContext.substring(0, namespaceIndex) : "";
        return StringUtil.isNotEmpty((String)namespacePrefix) && !namespacePrefix.contains(" ") ? namespacePrefix + "::" + defaultEnumValue.getName() : defaultEnumValue.getName();
    }

    private static class FriendsFilter
    implements Processor<OCSymbol> {
        private final OCQualifiedName parentQualifiedName;
        private final Processor<? super OCSymbol> myProcessor;

        FriendsFilter(OCNamespaceLikeSymbol parent, Processor<? super OCSymbol> processor2) {
            this.parentQualifiedName = parent instanceof OCSymbolWithQualifiedName ? ((OCSymbolWithQualifiedName)((Object)parent)).getQualifiedName() : null;
            this.myProcessor = processor2;
        }

        public boolean process(OCSymbol symbol) {
            if (symbol instanceof OCSymbolWithQualifiedName && ((OCSymbolWithQualifiedName)symbol).isFriend()) {
                OCQualifiedName qualifiedName;
                OCSymbolWithQualifiedName parent = ((OCSymbolWithQualifiedName)symbol).getParent();
                OCQualifiedName oCQualifiedName = qualifiedName = parent != null ? parent.getQualifiedName() : null;
                if (!Comparing.equal((Object)qualifiedName, (Object)this.parentQualifiedName)) {
                    return true;
                }
            }
            return this.myProcessor.process((Object)symbol);
        }
    }

    private static class InnerProcessor
    implements Processor<OCSymbol> {
        private final String myMemberName;
        private final boolean myTypesOnly;
        private final boolean myGoTransitive;
        private final Set<String> myAlreadyProcessed;
        private final OCTypeSubstitution mySubstitution;
        private final Set<? super OCNamespaceLikeSymbol> myProcessed;
        private final Stack<? super Pair<OCNamespaceLikeSymbol, Set<String>>> myWorkset;
        private final Processor<? super OCSymbol> myProcessor;
        private final Processor<OCSymbol> myFilteringProcessor;
        private final Condition<? super OCSymbol> myCondition;
        @NotNull
        private final OCResolveContext myContext;

        InnerProcessor(String memberName, boolean typesOnly, boolean goTransitive, Set<String> alreadyProcessed, OCTypeSubstitution substitution2, Set<? super OCNamespaceLikeSymbol> processed, Stack<? super Pair<OCNamespaceLikeSymbol, Set<String>>> workset, Processor<? super OCSymbol> processor2, Condition<? super OCSymbol> condition, @NotNull OCResolveContext context2) {
            this.myMemberName = memberName;
            this.myTypesOnly = typesOnly;
            this.myGoTransitive = goTransitive;
            this.myAlreadyProcessed = alreadyProcessed;
            this.mySubstitution = substitution2;
            this.myProcessed = processed;
            this.myWorkset = workset;
            this.myProcessor = processor2;
            this.myFilteringProcessor = new FilteringProcessor(condition, processor2);
            this.myCondition = condition;
            this.myContext = context2;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean process(OCSymbol symbol) {
            if (symbol instanceof OCStructSymbol && symbol.getName().equals(this.myMemberName) && !this.myProcessor.process((Object)symbol)) {
                return false;
            }
            if (symbol instanceof OCNamespaceSymbol && !this.myProcessed.contains(symbol)) {
                Ref processed;
                FilteringProcessor filter;
                OCNamespaceSymbol struct;
                this.myProcessed.add((OCNamespaceLikeSymbol)((Object)symbol));
                if (symbol instanceof OCStructSymbol && this.mySubstitution != OCTypeSubstitution.ID) {
                    symbol = new OCStructSymbol((OCStructSymbol)symbol, OCTypeSubstitution.compose(((OCStructSymbol)symbol).getSubstitution(), this.mySubstitution));
                }
                if (!(struct = (OCNamespaceSymbol)symbol).processMembers(this.myMemberName, new FriendsFilter(struct, (Processor<? super OCSymbol>)(filter = new FilteringProcessor(OCSymbolWithQualifiedName.WITHOUT_QUALIFIER, arg_0 -> this.lambda$process$0(processed = new Ref((Object)false), arg_0)))))) {
                    return false;
                }
                if (((Boolean)processed.get()).booleanValue() && !this.myGoTransitive) return true;
                this.myWorkset.push((Object)new Pair((Object)struct, this.myAlreadyProcessed));
                return true;
            }
            if (symbol instanceof OCDeclaratorSymbol && symbol.getKind().isTypedefOrAlias()) {
                OCType type = symbol.getType();
                if (type instanceof OCMagicType) {
                    if (this.myFilteringProcessor.process((Object)new OCTypeParameterTypeSymbol(null, 0L, this.myMemberName, null, Collections.emptyList(), null, false, true, true))) return this.myFilteringProcessor.process((Object)new OCDeclaratorSymbolImpl(this.myMemberName, new OCMagicType(this.myMemberName), OCSymbolKind.TEMPLATE_VALUE_PARAMETER));
                    return false;
                }
                if (type instanceof OCStructType) {
                    if (this.mySubstitution == OCTypeSubstitution.ID) {
                        return ContainerUtil.process(((OCStructType)type).getStructs(), (Processor)this);
                    }
                    for (OCStructSymbol struct : ((OCStructType)type).getStructs()) {
                        if (this.process(new OCStructSymbol(struct, OCTypeSubstitution.compose(struct.getSubstitution(), this.mySubstitution)))) continue;
                        return false;
                    }
                    return true;
                } else {
                    if (!(type instanceof OCReferenceType)) return true;
                    return ContainerUtil.process(this.myContext.substitute(((OCReferenceType)type).getSubstitution()).resolveToSymbols(((OCReferenceType)type).getReference(this.myContext), true, true), (Processor)this);
                }
            }
            if (symbol instanceof OCTypeParameterSymbol) {
                OCTypeParameterTypeSymbol qualifierTypeParameter;
                OCTypeParameterTypeSymbol oCTypeParameterTypeSymbol = qualifierTypeParameter = symbol instanceof OCTypeParameterTypeSymbol ? (OCTypeParameterTypeSymbol)symbol : null;
                if (this.myFilteringProcessor.process((Object)new OCTypeParameterTypeSymbol(null, 0L, this.myMemberName, qualifierTypeParameter, null, Collections.emptyList(), null, false, true, true))) return this.myFilteringProcessor.process((Object)new OCDeclaratorSymbolImpl(this.myMemberName, new OCMagicType(this.myMemberName), OCSymbolKind.TEMPLATE_VALUE_PARAMETER){});
                return false;
            }
            if (symbol instanceof OCUsingSymbol) {
                return ContainerUtil.process(this.myContext.resolveToSymbols(((OCUsingSymbol)symbol).getSymbolReference(), true, this.myTypesOnly), (Processor)this);
            }
            if (!(symbol instanceof OCNamespaceAliasSymbol)) return true;
            return ContainerUtil.process(this.myContext.resolveToSymbols(((OCNamespaceAliasSymbol)symbol).getNamespaceReference(), true, this.myTypesOnly), (Processor)this);
        }

        private /* synthetic */ boolean lambda$process$0(Ref processed, OCSymbol symbol1) {
            String signature;
            String string = signature = symbol1 instanceof OCFunctionSymbol ? ((OCFunctionSymbol)symbol1).getSignatureWithoutParamNames() : symbol1.getName();
            if (this.myAlreadyProcessed != null && this.myAlreadyProcessed.contains(signature)) {
                return true;
            }
            if (this.myCondition.value((Object)symbol1)) {
                processed.set((Object)true);
                if (this.myAlreadyProcessed != null) {
                    this.myAlreadyProcessed.add(signature);
                }
                if (!this.myProcessor.process((Object)symbol1)) {
                    return false;
                }
            }
            return true;
        }
    }
}

