/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.toolchains;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class CidrCompilerSwitches {
    @NotNull
    public static final CidrCompilerSwitches EMPTY = new CidrCompilerSwitches(ContainerUtil.emptyList());
    @NotNull
    private final @Unmodifiable List<String> myRawArgs;

    public CidrCompilerSwitches(@NotNull List<String> rawArgs) {
        this.myRawArgs = ContainerUtil.unmodifiableOrEmptyList(rawArgs);
    }

    @NotNull
    public @NotNull @Unmodifiable List<@NotNull String> getList(@NotNull Format format) {
        if (format == Format.RAW) {
            return this.myRawArgs;
        }
        return ContainerUtil.map(this.myRawArgs, it -> CidrSwitchBuilder.convertSingleRawArgTo(it, format));
    }

    @NotNull
    public String getCommandLineString(@NotNull Format format) {
        if (format == Format.RAW) {
            throw new IllegalArgumentException("RAW format cannot be correctly used in command line strings.");
        }
        return StringUtil.join(this.getList(format), (String)" ");
    }

    @NotNull
    public CidrCompilerSwitches filterOptions(@NotNull BiFunction<String, String, Boolean> argumentsFilter2) {
        ArrayList<String> filtered = null;
        int size = this.myRawArgs.size();
        for (int i2 = 0; i2 < size; ++i2) {
            String nextParam;
            String param = this.myRawArgs.get(i2).trim();
            String string = nextParam = i2 + 1 < size ? this.myRawArgs.get(i2 + 1).trim() : null;
            if (!argumentsFilter2.apply(param, nextParam).booleanValue()) continue;
            if (filtered == null) {
                filtered = new ArrayList<String>();
            }
            filtered.add(param);
        }
        return filtered == null ? EMPTY : new CidrCompilerSwitches(filtered);
    }

    @NotNull
    public CidrCompilerSwitches expandResponseFiles(@NotNull File baseDirectory, @NotNull CidrToolEnvironment environment, @NotNull Format responseFileFormat) throws IOException {
        if (responseFileFormat != Format.GCC_RESPONSE_FILE && responseFileFormat != Format.MSVC_RESPONSE_FILE) {
            throw new IllegalArgumentException("Passed format cannot be used as response file format.");
        }
        ArrayList<String> expandedArguments = new ArrayList<String>(this.myRawArgs);
        THashSet expansionStack = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        CidrCompilerSwitches.expandResponseFiles(baseDirectory, expandedArguments, (Set<File>)expansionStack, environment, responseFileFormat);
        return new CidrCompilerSwitches(expandedArguments);
    }

    private static void expandResponseFiles(@NotNull File baseDirectory, @NotNull List<String> arguments, @NotNull Set<File> expansionStack, @NotNull CidrToolEnvironment environment, @NotNull Format responseFileFormat) throws IOException {
        if (expansionStack.size() > 20) {
            throw new IOException("Maximum recursion depth has been reached during response files expansion.");
        }
        int position = 0;
        while (position < arguments.size()) {
            String argument = arguments.get(position);
            if (!argument.startsWith("@")) {
                ++position;
                continue;
            }
            String responseFilePath = argument.substring(1);
            List<String> expandedArguments = CidrCompilerSwitches.expandResponseFile(baseDirectory, responseFilePath, expansionStack, environment, responseFileFormat);
            arguments.remove(position);
            arguments.addAll(position, expandedArguments);
            position += expandedArguments.size();
        }
    }

    private static List<String> expandResponseFile(@NotNull File baseDirectory, @NotNull String responseFilePath, @NotNull Set<File> expansionStack, @NotNull CidrToolEnvironment environment, @NotNull Format responseFileFormat) throws IOException {
        String responseFileLocalPath = environment.toLocalPath(baseDirectory, responseFilePath);
        File responseFile = new File(responseFileLocalPath);
        if (expansionStack.contains(responseFile)) {
            throw new IOException("Cyclic dependency has been detected during response files expansion.");
        }
        if (!responseFile.exists() || !responseFile.isFile()) {
            return Collections.emptyList();
        }
        expansionStack.add(responseFile);
        String content = FileUtil.loadFile((File)responseFile);
        List<String> arguments = CidrSwitchBuilder.parseArgs(content, responseFileFormat);
        CidrCompilerSwitches.expandResponseFiles(baseDirectory, arguments, expansionStack, environment, responseFileFormat);
        expansionStack.remove(responseFile);
        return arguments;
    }

    public String toString() {
        return this.getCommandLineString(Format.BASH_SHELL);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CidrCompilerSwitches switches = (CidrCompilerSwitches)o;
        return this.myRawArgs.equals(switches.myRawArgs);
    }

    public int hashCode() {
        return this.myRawArgs.hashCode();
    }

    public static enum Format {
        RAW,
        BASH_SHELL,
        WINDOWS_SHELL,
        GNU_MAKEFILES,
        MINGW_MAKEFILES,
        NMAKE_MAKEFILES,
        GCC_RESPONSE_FILE,
        MSVC_RESPONSE_FILE;

    }
}

