/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.serialization;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import com.intellij.util.lang.CompoundRuntimeException;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCModuleImportSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesPack;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.FileSymbolTableSerializationVersion;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.FileSymbolTableSerializer;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.MetaData;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.SerializationAttributeService;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.SerializationService;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.SerializationSession;
import gnu.trove.THashSet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SerializationServiceImpl
implements SerializationService {
    private static final Logger LOG = Logger.getInstance(SerializationServiceImpl.class);
    private static final String TABLES_KEY_PREFIX = "objc_file_symbol_tables_attribute:";
    private static final FileAttribute ourFileTablesMetaAttribute = new FileAttribute("objc_file_symbol_tables_meta_attribute", FileSymbolTableSerializationVersion.INSTANCE.getVersion(), false);
    private final Stack<FileSymbolTableSerializer> mySerializerPool = new Stack();

    @Override
    public void serializeTables(@NotNull Project project2, @NotNull String projectLocationHash, @NotNull Map<VirtualFile, FileSymbolTablesPack> tables, @NotNull ProgressIndicator indicator) {
        AtomicInteger counter = new AtomicInteger();
        int size = tables.size();
        ConcurrentLinkedQueue<VirtualFile> queue2 = new ConcurrentLinkedQueue<VirtualFile>(tables.keySet());
        String keyForSerialization = this.getKeyForSerialization(projectLocationHash);
        FileAttribute cacheAttribute = this.getFileCacheAttributeForProjectKey(keyForSerialization);
        String basePath = project2.getBasePath();
        LOG.assertTrue(basePath != null);
        this.performAsynchronously(project2, indicator, (Consumer<NotNullLazyValue<FileSymbolTableSerializer>>)((Consumer)serializer2 -> {
            VirtualFile file2;
            boolean ok = true;
            while (ok && (file2 = (VirtualFile)queue2.poll()) != null) {
                indicator.checkCanceled();
                VirtualFile finalFile = file2;
                ok = (Boolean)ReadAction.compute(() -> {
                    indicator.checkCanceled();
                    if (SerializationServiceImpl.shouldSerializeTable(finalFile)) {
                        try {
                            MetaData metaData = this.readMetaData((NotNullLazyValue<FileSymbolTableSerializer>)serializer2, finalFile);
                            metaData.registerProject(projectLocationHash, basePath);
                            this.writeMetaData((FileSymbolTableSerializer)serializer2.getValue(), finalFile, metaData);
                            FileSymbolTablesPack pack = (FileSymbolTablesPack)tables.get(finalFile);
                            SerializationServiceImpl.writePack(pack, finalFile, (FileSymbolTableSerializer)serializer2.getValue(), cacheAttribute);
                        }
                        catch (IOException e) {
                            LOG.error("Can't serialize file symbol table", (Throwable)e);
                            return false;
                        }
                    }
                    return true;
                });
                indicator.setFraction((double)counter.incrementAndGet() / (double)size);
            }
        }));
    }

    @Override
    @NotNull
    public Map<VirtualFile, FileSymbolTablesPack> deserializeTables(@NotNull Project project2, @NotNull String projectLocationHash, @NotNull Collection<VirtualFile> filesToLoad, @NotNull ProgressIndicator indicator, double indicatorScale) {
        ModuleMapManager moduleMapManager = ModuleMapManager.getInstance(project2);
        THashSet processedFiles = new THashSet();
        Set notLoaded = ContainerUtil.newConcurrentSet();
        notLoaded.addAll(filesToLoad);
        ArrayDeque<VirtualFile> workset = new ArrayDeque<VirtualFile>(filesToLoad);
        Set dirtySet = ContainerUtil.newConcurrentSet();
        MultiMap importsMap = new MultiMap();
        ConcurrentHashMap<VirtualFile, FileSymbolTablesPack> result2 = new ConcurrentHashMap<VirtualFile, FileSymbolTablesPack>();
        long total = notLoaded.size();
        this.performAsynchronously(project2, indicator, (Consumer<NotNullLazyValue<FileSymbolTableSerializer>>)((Consumer)arg_0 -> this.lambda$deserializeTables$5(projectLocationHash, indicator, workset, (Set)processedFiles, dirtySet, notLoaded, indicatorScale, total, importsMap, moduleMapManager, result2, arg_0)));
        workset.addAll(dirtySet);
        while (!workset.isEmpty()) {
            VirtualFile file2 = workset.pop();
            for (VirtualFile dep : importsMap.get((Object)file2)) {
                if (!dirtySet.add(dep)) continue;
                workset.push(dep);
            }
        }
        for (VirtualFile file3 : dirtySet) {
            result2.remove(file3);
        }
        return result2;
    }

    private void performAsynchronously(@NotNull Project project2, @NotNull ProgressIndicator indicator, @NotNull Consumer<NotNullLazyValue<FileSymbolTableSerializer>> task2) {
        Application application = ApplicationManager.getApplication();
        OCLog.LOG.assertTrue(application.isDispatchThread() || !application.isReadAccessAllowed() || indicator == ProgressManager.getInstance().getProgressIndicator());
        ArrayList<Future> futures2 = new ArrayList<Future>();
        for (int i2 = 0; i2 < PARALLEL_SERIALIZERS; ++i2) {
            futures2.add(application.executeOnPooledThread(() -> {
                FileSymbolTableSerializer serializer2 = this.borrowSerializer(project2);
                try {
                    task2.consume((Object)NotNullLazyValue.createConstantValue((Object)serializer2));
                }
                finally {
                    this.returnSerializer(serializer2);
                }
            }));
        }
        SmartList exceptions = new SmartList();
        for (Future future : futures2) {
            try {
                ProgressIndicatorUtils.awaitWithCheckCanceled((Future)future, (ProgressIndicator)indicator);
            }
            catch (ProcessCanceledException pce) {
                throw pce;
            }
            catch (Throwable t) {
                exceptions.add(t.getCause());
            }
        }
        if (!exceptions.isEmpty()) {
            throw new CompoundRuntimeException((List)exceptions);
        }
        indicator.checkCanceled();
    }

    private static boolean shouldSerializeTable(@NotNull VirtualFile file2) {
        return file2.isValid() && file2 instanceof VirtualFileWithId && !file2.isDirectory();
    }

    @NotNull
    private String getKeyForSerialization(@NotNull String projectLocationHash) {
        return TABLES_KEY_PREFIX + projectLocationHash;
    }

    @NotNull
    private FileAttribute getFileCacheAttributeForProjectKey(@NotNull String key) {
        return SerializationAttributeService.getInstance().getFileCacheAttributeForProjectKey(key, FileSymbolTableSerializationVersion.INSTANCE.getVersion());
    }

    @Nullable
    private FileSymbolTablesPack readTablesForFile(@NotNull NotNullLazyValue<FileSymbolTableSerializer> serializer2, @NotNull SerializationSession session, @NotNull VirtualFile file2) throws IOException {
        boolean metaDataChanged;
        String lastLocationHash;
        String keyForSerialization;
        FileSymbolTablesPack pack = null;
        MetaData metaData = this.readMetaData(serializer2, file2);
        boolean upToDate = metaData.isFileUpToDate();
        if (upToDate && (pack = this.readPack(serializer2, keyForSerialization = this.getKeyForSerialization(session.getProjectLocationHash()), file2)) == null && (lastLocationHash = metaData.getMostRecentLocationHash()) != null && (pack = this.readPack(serializer2, keyForSerialization = this.getKeyForSerialization(lastLocationHash), file2)) != null) {
            pack.markAsFallback();
        }
        if (metaDataChanged = metaData.evictProjects((projectKey, projectPath) -> {
            if (upToDate && session.projectExists(projectPath)) {
                return false;
            }
            FileAttribute attribute = this.getFileCacheAttributeForProjectKey(projectKey);
            attribute.writeAttribute(file2).close();
            return true;
        })) {
            this.writeMetaData((FileSymbolTableSerializer)serializer2.getValue(), file2, metaData);
        }
        return pack;
    }

    @Nullable
    private FileSymbolTablesPack readPack(@NotNull NotNullLazyValue<FileSymbolTableSerializer> serializer2, @NotNull String keyForSerialization, @NotNull VirtualFile file2) throws IOException {
        FileAttribute attribute = this.getFileCacheAttributeForProjectKey(keyForSerialization);
        try (DataInputStream dis = attribute.readAttribute(file2);){
            if (dis == null || dis.available() == 0) {
                FileSymbolTablesPack fileSymbolTablesPack = null;
                return fileSymbolTablesPack;
            }
            long metaIndicesVersion = dis.readLong();
            if (metaIndicesVersion != FileSymbolTableSerializationVersion.INSTANCE.getGlobalIndicesVersion()) {
                FileSymbolTablesPack fileSymbolTablesPack = null;
                return fileSymbolTablesPack;
            }
            long savedTimestamp = dis.readLong();
            if (savedTimestamp != file2.getTimeStamp()) {
                FileSymbolTablesPack fileSymbolTablesPack = null;
                return fileSymbolTablesPack;
            }
            FileSymbolTablesPack fileSymbolTablesPack = ((FileSymbolTableSerializer)serializer2.getValue()).readSymbolTables(dis, file2);
            return fileSymbolTablesPack;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePack(@NotNull FileSymbolTablesPack pack, @NotNull VirtualFile finalFile, @NotNull FileSymbolTableSerializer serializer2, @NotNull FileAttribute cacheAttribute) throws IOException {
        try (DataOutputStream dos = cacheAttribute.writeAttribute(finalFile);){
            dos.writeLong(FileSymbolTableSerializationVersion.INSTANCE.getGlobalIndicesVersion());
            dos.writeLong(finalFile.getTimeStamp());
            Object object = pack.getTablesAccessLock();
            synchronized (object) {
                serializer2.writeSymbolTables(dos, pack);
                pack.setSerialized();
            }
        }
    }

    @NotNull
    private MetaData readMetaData(@NotNull NotNullLazyValue<FileSymbolTableSerializer> serializer2, @NotNull VirtualFile file2) throws IOException {
        try (DataInputStream dis = ourFileTablesMetaAttribute.readAttribute(file2);){
            if (dis == null || dis.available() == 0) {
                MetaData metaData = new MetaData();
                return metaData;
            }
            long metaIndicesVersion = dis.readLong();
            long metaFileTimestamp = dis.readLong();
            boolean isUpToDate = metaIndicesVersion == FileSymbolTableSerializationVersion.INSTANCE.getGlobalIndicesVersion();
            isUpToDate = isUpToDate && metaFileTimestamp == file2.getTimeStamp();
            MetaData metaData = ((FileSymbolTableSerializer)serializer2.getValue()).readMetaData(dis);
            if (metaData == null) {
                MetaData metaData2 = new MetaData();
                return metaData2;
            }
            metaData.setFileUpToDate(isUpToDate);
            MetaData metaData3 = metaData;
            return metaData3;
        }
    }

    private void writeMetaData(@NotNull FileSymbolTableSerializer serializer2, @NotNull VirtualFile file2, @NotNull MetaData metaData) throws IOException {
        try (DataOutputStream dos = ourFileTablesMetaAttribute.writeAttribute(file2);){
            dos.writeLong(FileSymbolTableSerializationVersion.INSTANCE.getGlobalIndicesVersion());
            dos.writeLong(file2.getTimeStamp());
            serializer2.writeMetaData(dos, metaData);
        }
    }

    @Override
    @Nullable
    public FileSymbolTablesPack deserializeTables(@NotNull Project project2, @NotNull SerializationSession session, @NotNull VirtualFile file2) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return (FileSymbolTablesPack)ProgressManager.getInstance().computeInNonCancelableSection(() -> {
            NotNullLazyValue serializer2 = NotNullLazyValue.createValue(() -> this.borrowSerializer(project2));
            try {
                FileSymbolTablesPack p = this.readTablesForFile((NotNullLazyValue<FileSymbolTableSerializer>)serializer2, session, file2);
                if (p != null && !p.isEmpty()) {
                    FileSymbolTablesPack fileSymbolTablesPack = p;
                    return fileSymbolTablesPack;
                }
            }
            catch (IOException e) {
                LOG.error("Can't deserialize file symbol table", (Throwable)e);
            }
            finally {
                if (serializer2.isComputed()) {
                    this.returnSerializer((FileSymbolTableSerializer)serializer2.getValue());
                }
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private FileSymbolTableSerializer borrowSerializer(@NotNull Project project2) {
        Stack<FileSymbolTableSerializer> stack = this.mySerializerPool;
        synchronized (stack) {
            FileSymbolTableSerializer result2 = (FileSymbolTableSerializer)this.mySerializerPool.tryPop();
            if (result2 == null) {
                result2 = new FileSymbolTableSerializer();
            }
            result2.setProject(project2);
            return result2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnSerializer(@NotNull FileSymbolTableSerializer serializer2) {
        Stack<FileSymbolTableSerializer> stack = this.mySerializerPool;
        synchronized (stack) {
            serializer2.setProject(null);
            serializer2.compact();
            this.mySerializerPool.push((Object)serializer2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$deserializeTables$5(String projectLocationHash, ProgressIndicator indicator, ArrayDeque workset, Set processedFiles, Set dirtySet, Set notLoaded, double indicatorScale, long total, MultiMap importsMap, ModuleMapManager moduleMapManager, Map result2, NotNullLazyValue serializer2) {
        try {
            SerializationSession session = new SerializationSession(projectLocationHash);
            while (true) {
                VirtualFile file2;
                indicator.checkCanceled();
                ArrayDeque arrayDeque = workset;
                synchronized (arrayDeque) {
                    if (workset.isEmpty()) {
                        return;
                    }
                    file2 = (VirtualFile)workset.pop();
                    if (!processedFiles.add(file2)) {
                        continue;
                    }
                }
                FileSymbolTablesPack pack = (FileSymbolTablesPack)ReadAction.compute(() -> {
                    indicator.checkCanceled();
                    if (!SerializationServiceImpl.shouldSerializeTable(file2)) {
                        return null;
                    }
                    FileSymbolTablesPack p = this.readTablesForFile((NotNullLazyValue<FileSymbolTableSerializer>)serializer2, session, file2);
                    if (p == null) {
                        dirtySet.add(file2);
                    }
                    return p;
                });
                if (pack == null) continue;
                notLoaded.remove(file2);
                indicator.setFraction(indicatorScale * ((double)total - (double)notLoaded.size()) / (double)total);
                if (pack.isEmpty()) continue;
                for (FileSymbolTable table : pack.tablesView()) {
                    table.processIncludes((Processor<? super OCSymbol>)((Processor)include -> {
                        ModuleMapManager.Cache cache;
                        ModuleMapSymbol module2;
                        indicator.checkCanceled();
                        if (include instanceof OCIncludeSymbol) {
                            VirtualFile targetFile;
                            OCIncludeSymbol inc = (OCIncludeSymbol)include;
                            if (inc.isSymbolTableUsed() && (targetFile = inc.getTargetFile()) != null) {
                                ArrayDeque arrayDeque = workset;
                                synchronized (arrayDeque) {
                                    workset.push(targetFile);
                                    importsMap.putValue((Object)targetFile, (Object)file2);
                                }
                            }
                        } else if (include instanceof OCModuleImportSymbol && (module2 = (ModuleMapSymbol)ReadAction.compute(() -> SerializationServiceImpl.lambda$null$3(cache = moduleMapManager.getGlobalCache(), include))) != null) {
                            ArrayDeque arrayDeque = workset;
                            synchronized (arrayDeque) {
                                for (VirtualFile header : module2.getIncludeHeaders()) {
                                    workset.push(header);
                                    importsMap.putValue((Object)header, (Object)file2);
                                }
                            }
                        }
                        return true;
                    }));
                }
                result2.put(file2, pack);
            }
        }
        catch (IOException e) {
            LOG.error("Can't deserialize file symbol table", (Throwable)e);
            return;
        }
    }

    private static /* synthetic */ ModuleMapSymbol lambda$null$3(ModuleMapManager.Cache cache, OCSymbol include) throws RuntimeException {
        return cache.findModule(include.getName());
    }
}

