/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCLazyNamedSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.AbstractGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsBuilder;
import com.jetbrains.cidr.lang.symbols.symtable.OCLazyNamedSymbolCollection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGlobalProjectSymbolsCache
extends AbstractGlobalProjectSymbolsCache<OCSymbol, OCSymbols> {
    protected OCGlobalProjectSymbolsCache(@NotNull Project project2) {
        super(OCGlobalProjectSymbolsCache.class, project2);
    }

    @Override
    @NotNull
    protected OCSymbols buildGlobalSymbols(@NotNull Project project2) {
        return (OCSymbols)BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)project2, () -> OCGlobalProjectSymbolsBuilder.build(project2));
    }

    @NotNull
    public static OCGlobalProjectSymbolsCache getInstance(@NotNull Project project2) {
        return (OCGlobalProjectSymbolsCache)project2.getComponent(OCGlobalProjectSymbolsCache.class);
    }

    @Nullable
    public static OCSymbol findNearestTopLevelSymbol(@NotNull Project project2, @Nullable String name, @Nullable Condition<? super OCSymbol> condition, @Nullable VirtualFile contextFile) {
        return OCGlobalProjectSymbolsCache.findNearestTopLevelSymbol(OCGlobalProjectSymbolsCache.class, project2, name, condition, contextFile);
    }

    public static boolean processTopLevelSymbols(@NotNull Project project2, @NotNull Processor<? super OCSymbol> processor2, @Nullable String name) {
        return OCGlobalProjectSymbolsCache.processTopLevelSymbols(OCGlobalProjectSymbolsCache.class, project2, processor2, name);
    }

    public static boolean processTopLevelAndMemberSymbols(@NotNull Project project2, @NotNull Processor<? super OCSymbol> processor2, @Nullable String name) {
        return OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(OCGlobalProjectSymbolsCache.class, project2, processor2, name);
    }

    public static boolean processByQualifiedName(@NotNull Project project2, @NotNull Processor<? super OCSymbol> processor2, @NotNull String name) {
        return OCGlobalProjectSymbolsCache.processByQualifiedName(OCGlobalProjectSymbolsCache.class, project2, processor2, name);
    }

    public static boolean processAliasNamesForType(@NotNull Project project2, @NotNull String name, @NotNull Processor<String> processor2) {
        return OCGlobalProjectSymbolsCache.processAliasNamesForType(OCGlobalProjectSymbolsCache.class, project2, name, processor2);
    }

    public static boolean processTopLevelAndMemberSymbols(@NotNull Project project2, @NotNull Processor<? super OCSymbol> processor2, @Nullable String name, boolean topLevelOnly) {
        return OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(OCGlobalProjectSymbolsCache.class, project2, processor2, name, topLevelOnly);
    }

    @NotNull
    public static Set<String> getAllSymbolNames(@NotNull Project project2) {
        return OCGlobalProjectSymbolsCache.getAllSymbolNames(OCGlobalProjectSymbolsCache.class, project2);
    }

    public static MostlySingularMultiMap<String, OCSymbol> getCppMemberSymbols(@NotNull Project project2) {
        return ((OCSymbols)OCGlobalProjectSymbolsCache.getInstance((Project)project2).getGlobalSymbols()).myCppMemberSymbols;
    }

    public static boolean processSymbolsByCategory(@NotNull Project project2, @NotNull Processor<? super OCSymbol> processor2, @Nullable String name) {
        FileSymbolTablesCache.getInstance(project2).ensurePendingFilesProcessed();
        return ((OCSymbols)OCGlobalProjectSymbolsCache.getInstance(project2).getGlobalSymbols()).processSymbolsByCategory(processor2, name);
    }

    public static boolean processSymbolsBySuperType(@NotNull Project project2, @Nullable String superName, @NotNull Processor<? super OCSymbol> processor2) {
        FileSymbolTablesCache.getInstance(project2).ensurePendingFilesProcessed();
        return ((OCSymbols)OCGlobalProjectSymbolsCache.getInstance(project2).getGlobalSymbols()).processSymbolsBySuperType(processor2, superName);
    }

    @NotNull
    public static MostlySingularMultiMap<String, OCClassSymbol> getAllCategories(@NotNull Project project2) {
        return ((OCSymbols)OCGlobalProjectSymbolsCache.getInstance(project2).getGlobalSymbols()).getAllNamesWithCategories();
    }

    static class OCSymbols
    implements AbstractGlobalProjectSymbolsCache.Symbols<OCSymbol> {
        @NotNull
        final MostlySingularMultiMap<String, OCClassSymbol> myCategoryToClass;
        @NotNull
        final MostlySingularMultiMap<String, OCSymbol> myTopLevelSymbols;
        @NotNull
        final MostlySingularMultiMap<String, OCSymbol> myMemberSymbols;
        @NotNull
        final MostlySingularMultiMap<String, OCSymbol> myCppMemberSymbols;
        @NotNull
        final MostlySingularMultiMap<String, OCSymbol> myTypeAliases;
        @NotNull
        final MultiMap<String, OCSymbol> mySuperTypeToClass;
        @NotNull
        final OCLazyNamedSymbolCollection myLazyNamedSymbols;

        OCSymbols() {
            this((MostlySingularMultiMap<String, OCClassSymbol>)MostlySingularMultiMap.emptyMap(), (MostlySingularMultiMap<String, OCSymbol>)MostlySingularMultiMap.emptyMap(), (MostlySingularMultiMap<String, OCSymbol>)MostlySingularMultiMap.emptyMap(), (MostlySingularMultiMap<String, OCSymbol>)MostlySingularMultiMap.emptyMap(), (MostlySingularMultiMap<String, OCSymbol>)MostlySingularMultiMap.emptyMap(), (MultiMap<String, OCSymbol>)MultiMap.empty(), Collections.emptySet());
        }

        OCSymbols(@NotNull MostlySingularMultiMap<String, OCClassSymbol> categoryToClass, @NotNull MostlySingularMultiMap<String, OCSymbol> topLevelSymbols, @NotNull MostlySingularMultiMap<String, OCSymbol> memberSymbols, @NotNull MostlySingularMultiMap<String, OCSymbol> cppMemberSymbols, @NotNull MostlySingularMultiMap<String, OCSymbol> typeAliases, @NotNull MultiMap<String, OCSymbol> superTypeToClass, @NotNull Set<OCLazyNamedSymbol> lazyNamedSymbols) {
            this.myCategoryToClass = categoryToClass;
            this.myTopLevelSymbols = topLevelSymbols;
            this.myMemberSymbols = memberSymbols;
            this.myCppMemberSymbols = cppMemberSymbols;
            this.myTypeAliases = typeAliases;
            this.myLazyNamedSymbols = new OCLazyNamedSymbolCollection(lazyNamedSymbols);
            this.mySuperTypeToClass = superTypeToClass;
        }

        @Override
        public boolean processAliasNamesForType(@NotNull String name, @NotNull Processor<? super String> processor2) {
            return this.myTypeAliases.processForKey((Object)name, typeNameInFile -> processor2.process((Object)typeNameInFile.getName()));
        }

        @Override
        public boolean processTopLevel(@NotNull Processor<? super OCSymbol> processor2, @Nullable String name) {
            if (!OCResolveUtil.processMap(processor2, name, this.myTopLevelSymbols)) {
                return false;
            }
            return this.myLazyNamedSymbols.process(processor2, name);
        }

        public boolean processCppMemberSymbols(@NotNull Processor<? super OCSymbol> processor2, @Nullable String name) {
            return OCResolveUtil.processMap(processor2, name, this.myCppMemberSymbols);
        }

        @Override
        public boolean processAllSymbols(@NotNull Processor<? super OCSymbol> processor2, @Nullable String name) {
            return this.processTopLevel(processor2, name) && OCResolveUtil.processMap(processor2, name, this.myMemberSymbols) && OCResolveUtil.processMap(processor2, name, this.myCppMemberSymbols);
        }

        public boolean processSymbolsByCategory(@NotNull Processor<? super OCSymbol> processor2, @Nullable String name) {
            return OCResolveUtil.processMap(processor2, name, this.myCategoryToClass);
        }

        public boolean processSymbolsBySuperType(@NotNull Processor<? super OCSymbol> processor2, @Nullable String name) {
            return ContainerUtil.process((Iterable)this.mySuperTypeToClass.get((Object)name), processor2);
        }

        @NotNull
        public MostlySingularMultiMap<String, OCClassSymbol> getAllNamesWithCategories() {
            return this.myCategoryToClass;
        }
    }
}

