/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.google.common.collect.ImmutableList;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.CUDALanguageKind;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSymbol;
import com.jetbrains.cidr.lang.symbols.OCLazyNamedSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCModuleImportSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.CallerAwareJob;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCAdditionalFileSymbolTableBuilder;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbolTableModificationTracker;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.util.OCConcurrentMostlySingularMultiUniqueMapBuilder;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountedCompleter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class OCGlobalProjectSymbolsBuilder
extends CallerAwareJob<Void> {
    @NotNull
    volatile OCConcurrentMostlySingularMultiUniqueMapBuilder<OCClassSymbol> myCategoryToClass;
    @NotNull
    volatile OCConcurrentMostlySingularMultiUniqueMapBuilder<OCSymbol> myTopLevelSymbols;
    @NotNull
    volatile OCConcurrentMostlySingularMultiUniqueMapBuilder<OCSymbol> myMemberSymbols;
    @NotNull
    volatile OCConcurrentMostlySingularMultiUniqueMapBuilder<OCSymbol> myCppMemberSymbols;
    @NotNull
    volatile OCConcurrentMostlySingularMultiUniqueMapBuilder<OCSymbol> myTypeAliases;
    @NotNull
    volatile Set<OCLazyNamedSymbol> myLazyNamedSymbols;
    @NotNull
    volatile MultiMap<String, OCSymbol> mySuperTypeToClass;
    @NotNull
    private final FileSymbolTablesCache myCache;
    @NotNull
    private final ModuleMapManager myModuleMapManager;
    @NotNull
    private final Set<VirtualFile> myProcessed = ContainerUtil.newConcurrentSet();
    @NotNull
    private final Set<String> myProcessedModules = ContainerUtil.newConcurrentSet();
    public static final AtomicBoolean isBuilding = new AtomicBoolean(false);
    private static final ExecutorService ourCopyExecutor = AppExecutorUtil.createBoundedScheduledExecutorService((String)"Copy Symbols Pool", (int)Integer.max(1, Integer.min(Runtime.getRuntime().availableProcessors() - 1, 4)));

    OCGlobalProjectSymbolsBuilder(@NotNull FileSymbolTablesCache cache, int estimatedWorksetSize) {
        super(estimatedWorksetSize);
        this.myCache = cache;
        Project project2 = cache.getProject();
        this.myModuleMapManager = ModuleMapManager.getInstance(project2);
    }

    @NotNull
    static OCGlobalProjectSymbolsCache.OCSymbols build(@NotNull Project project2) {
        OCFileSymbolTableModificationTracker.log("{ build GST", new Object[0]);
        isBuilding.set(true);
        try {
            OCGlobalProjectSymbolsCache.OCSymbols oCSymbols;
            long st;
            long st2;
            long st1;
            block20: {
                OCFileSymbolTableModificationTracker FSTmt = OCFileSymbolTableModificationTracker.getInstance(project2);
                FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(project2);
                OCFileSymbolTableModificationTracker.State buildState = FSTmt.getStateAndReset();
                Set<VirtualFile> filesToAddToGlobalSymbols = buildState.filesWithNewSymbolTable;
                Set<Object> filesToFilterOutFromGlobalSymbols = buildState.filesWithInvalidSymbolTable;
                HashSet<VirtualFile> filesWithBuildTables = new HashSet<VirtualFile>(cache.getCachedFiles());
                OCGlobalProjectSymbolsCache.OCSymbols oldSymbols = buildState.symbols;
                if (oldSymbols == null) {
                    filesToAddToGlobalSymbols = filesWithBuildTables;
                    if (filesToAddToGlobalSymbols.isEmpty()) {
                        OCFileSymbolTableModificationTracker.log("fake GST run", new Object[0]);
                        OCGlobalProjectSymbolsCache.OCSymbols oCSymbols2 = new OCGlobalProjectSymbolsCache.OCSymbols();
                        return oCSymbols2;
                    }
                    filesToFilterOutFromGlobalSymbols = Collections.emptySet();
                    OCFileSymbolTableModificationTracker.log("full GST run", new Object[0]);
                } else {
                    filesToAddToGlobalSymbols.forEach(vf -> OCFileSymbolTableModificationTracker.log("file with new tables ", vf));
                    Set<VirtualFile> finalFilesToProcess = filesToAddToGlobalSymbols;
                    filesToFilterOutFromGlobalSymbols.forEach(vf -> {
                        OCFileSymbolTableModificationTracker.log("file with invalid tables ", vf);
                        if (filesWithBuildTables.contains(vf)) {
                            OCFileSymbolTableModificationTracker.log("file with valid tables ", vf);
                            finalFilesToProcess.add((VirtualFile)vf);
                        }
                    });
                    filesToAddToGlobalSymbols = finalFilesToProcess;
                    OCFileSymbolTableModificationTracker.log("optimal GST run", new Object[0]);
                }
                st1 = Long.MIN_VALUE;
                st2 = Long.MIN_VALUE;
                st = System.currentTimeMillis();
                try {
                    OCGlobalProjectSymbolsBuilder builder2 = new OCGlobalProjectSymbolsBuilder(cache, 3 * filesWithBuildTables.size());
                    builder2.copyActualSymbolsToInitialState(oldSymbols, filesToFilterOutFromGlobalSymbols);
                    st1 = System.currentTimeMillis();
                    OCGlobalProjectSymbolsCache.OCSymbols newSymbols = builder2.create(filesToAddToGlobalSymbols);
                    st2 = System.currentTimeMillis();
                    if (buildState.version != FSTmt.attachAndReturnCurrentVersion(newSymbols)) {
                        OCFileSymbolTableModificationTracker.log("dirty GST", new Object[0]);
                    }
                    oCSymbols = newSymbols;
                    if (st1 == Long.MIN_VALUE) break block20;
                }
                catch (ProcessCanceledException pce) {
                    try {
                        if (oldSymbols != null) {
                            FSTmt.restoreStateOnCancel(buildState, oldSymbols);
                            OCFileSymbolTableModificationTracker.log("cancel build GST safe", new Object[0]);
                        } else {
                            OCFileSymbolTableModificationTracker.log("cancel build GST with lost state: next is full GST run", new Object[0]);
                        }
                        throw pce;
                    }
                    catch (Throwable throwable) {
                        if (st1 != Long.MIN_VALUE) {
                            OCFileSymbolTableModificationTracker.log("GST: bulk copy: ", st1 - st);
                        }
                        if (st2 != Long.MIN_VALUE) {
                            OCFileSymbolTableModificationTracker.log("GST: process file tables: ", st2 - st1);
                            OCFileSymbolTableModificationTracker.log("GST: full creation: ", st2 - st);
                        } else {
                            OCFileSymbolTableModificationTracker.log("GST: canceled after: ", System.currentTimeMillis() - st);
                        }
                        throw throwable;
                    }
                }
                OCFileSymbolTableModificationTracker.log("GST: bulk copy: ", st1 - st);
            }
            if (st2 != Long.MIN_VALUE) {
                OCFileSymbolTableModificationTracker.log("GST: process file tables: ", st2 - st1);
                OCFileSymbolTableModificationTracker.log("GST: full creation: ", st2 - st);
            } else {
                OCFileSymbolTableModificationTracker.log("GST: canceled after: ", System.currentTimeMillis() - st);
            }
            return oCSymbols;
        }
        finally {
            isBuilding.set(false);
            OCFileSymbolTableModificationTracker.log("} build GST", new Object[0]);
        }
    }

    private void copyActualSymbolsToInitialState(@Nullable OCGlobalProjectSymbolsCache.OCSymbols oldSymbols, @NotNull Set<VirtualFile> filesToFilterOut) {
        if (oldSymbols == null) {
            this.myCategoryToClass = OCConcurrentMostlySingularMultiUniqueMapBuilder.createBuilder(ContainerUtil.identityStrategy());
            this.myTopLevelSymbols = OCConcurrentMostlySingularMultiUniqueMapBuilder.createBuilder(ContainerUtil.identityStrategy());
            this.myMemberSymbols = OCConcurrentMostlySingularMultiUniqueMapBuilder.createBuilder(ContainerUtil.identityStrategy());
            this.myCppMemberSymbols = OCConcurrentMostlySingularMultiUniqueMapBuilder.createBuilder(ContainerUtil.identityStrategy());
            this.myTypeAliases = OCConcurrentMostlySingularMultiUniqueMapBuilder.createBuilder(ContainerUtil.identityStrategy());
            this.myLazyNamedSymbols = ConcurrentCollectionFactory.createConcurrentSet((TObjectHashingStrategy)ContainerUtil.identityStrategy());
            this.mySuperTypeToClass = new StringToSymbolConcurrentMultiMap();
        } else {
            Predicate<OCSymbol> isActualSymbol = symbol -> !filesToFilterOut.contains(symbol.getContainingFile());
            ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
            assert (progress != null);
            Object[] tasks2 = new Runnable[]{() -> {
                this.myTopLevelSymbols = OCGlobalProjectSymbolsBuilder.copyBuilder(ContainerUtil.identityStrategy(), oldSymbols.myTopLevelSymbols, isActualSymbol, progress);
            }, () -> {
                this.myCppMemberSymbols = OCGlobalProjectSymbolsBuilder.copyBuilder(ContainerUtil.identityStrategy(), oldSymbols.myCppMemberSymbols, isActualSymbol, progress);
            }, () -> {
                this.myMemberSymbols = OCGlobalProjectSymbolsBuilder.copyBuilder(ContainerUtil.identityStrategy(), oldSymbols.myMemberSymbols, isActualSymbol, progress);
            }, () -> {
                this.myCategoryToClass = OCGlobalProjectSymbolsBuilder.copyBuilder(ContainerUtil.identityStrategy(), oldSymbols.myCategoryToClass, isActualSymbol, progress);
            }, () -> {
                this.myTypeAliases = OCGlobalProjectSymbolsBuilder.copyBuilder(ContainerUtil.identityStrategy(), oldSymbols.myTypeAliases, isActualSymbol, progress);
            }, () -> {
                StringToSymbolConcurrentMultiMap superTypeToClass = new StringToSymbolConcurrentMultiMap(oldSymbols.mySuperTypeToClass.size());
                oldSymbols.mySuperTypeToClass.entrySet().forEach(entry -> ((Collection)entry.getValue()).forEach(symbol -> {
                    if (isActualSymbol.test((OCSymbol)symbol)) {
                        superTypeToClass.putValue(entry.getKey(), symbol);
                    }
                }));
                this.mySuperTypeToClass = superTypeToClass;
            }, () -> {
                Set lazyNamedSymbols = ConcurrentCollectionFactory.createConcurrentSet((int)oldSymbols.myLazyNamedSymbols.size(), (TObjectHashingStrategy)ContainerUtil.identityStrategy());
                oldSymbols.myLazyNamedSymbols.process((Processor<? super OCLazyNamedSymbol>)((Processor)symbol -> {
                    if (isActualSymbol.test((OCSymbol)symbol)) {
                        lazyNamedSymbols.add(symbol);
                    }
                    return true;
                }), null);
                this.myLazyNamedSymbols = lazyNamedSymbols;
            }};
            ContainerUtil.map((Object[])tasks2, task2 -> ourCopyExecutor.submit((Runnable)task2)).forEach(future -> ProgressIndicatorUtils.awaitWithCheckCanceled((Future)future));
        }
    }

    @NotNull
    private static <M> OCConcurrentMostlySingularMultiUniqueMapBuilder<M> copyBuilder(@NotNull TObjectHashingStrategy<M> strategy2, @NotNull MostlySingularMultiMap<String, M> src, @NotNull Predicate<? super M> isActualSymbol, @NotNull ProgressIndicator progress) {
        int[] count = new int[]{0, 0};
        @NotNull OCConcurrentMostlySingularMultiUniqueMapBuilder<M> dest = new OCConcurrentMostlySingularMultiUniqueMapBuilder(src.size(), strategy2);
        src.keySet().forEach(key -> src.processForKey(key, symbol -> {
            int n = count[1];
            count[1] = n + 1;
            if ((n & 0xFFFF) == 0) {
                progress.checkCanceled();
            }
            if (isActualSymbol.test((Object)symbol) && dest.addIfAbsent((String)key, (Object)symbol)) {
                count[0] = count[0] + 1;
            }
            return true;
        }));
        progress.checkCanceled();
        return dest;
    }

    @NotNull
    @Contract(value="_ -> new")
    private OCGlobalProjectSymbolsCache.OCSymbols create(Set<VirtualFile> filesToProcess) {
        this.myProcessed.addAll(filesToProcess);
        this.run(new FileWorker(null, ImmutableList.copyOf(filesToProcess)));
        MultiMap superTypeToClass = MultiMap.createSet();
        superTypeToClass.putAllValues(this.mySuperTypeToClass);
        return new OCGlobalProjectSymbolsCache.OCSymbols(this.myCategoryToClass.build(), this.myTopLevelSymbols.build(), this.myMemberSymbols.build(), this.myCppMemberSymbols.build(), this.myTypeAliases.build(), (MultiMap<String, OCSymbol>)superTypeToClass, this.myLazyNamedSymbols);
    }

    private void addSymbol(@NotNull OCSymbol symbol) {
        if (symbol.getContainingFile() == null) {
            return;
        }
        if (symbol instanceof OCLazyNamedSymbol) {
            if (!this.myLazyNamedSymbols.add((OCLazyNamedSymbol)symbol)) {
                return;
            }
        } else {
            String name = symbol.getName();
            if (OCSymbolWithQualifiedName.isWithoutQualifier(symbol) ? !this.myTopLevelSymbols.addIfAbsent(name, symbol) : !this.myCppMemberSymbols.addIfAbsent(name, symbol)) {
                return;
            }
        }
        if (symbol instanceof OCClassSymbol) {
            OCClassSymbol classSymbol = (OCClassSymbol)symbol;
            String categoryName = classSymbol.getCategoryName();
            if (categoryName != null && !this.myCategoryToClass.addIfAbsent(categoryName, classSymbol)) {
                return;
            }
            String superClassName = classSymbol.getSuperClassName();
            if (!superClassName.isEmpty()) {
                this.mySuperTypeToClass.putValue((Object)superClassName, (Object)symbol);
            }
            for (String protocolName : classSymbol.getProtocolNames()) {
                if (protocolName == null || protocolName.isEmpty()) continue;
                this.mySuperTypeToClass.putValue((Object)protocolName, (Object)symbol);
            }
            classSymbol.processMembers(OCMemberSymbol.class, ocMemberSymbol -> {
                this.myMemberSymbols.addIfAbsent(ocMemberSymbol.getName(), (OCSymbol)ocMemberSymbol);
                return true;
            });
        } else if (symbol instanceof OCNamespaceSymbol) {
            ((OCNamespaceSymbol)symbol).processMembers((String)null, (Processor<? super OCSymbol>)new Processor<OCSymbol>(){

                public boolean process(OCSymbol ocSymbol) {
                    boolean isMember;
                    boolean bl = isMember = !(ocSymbol instanceof OCSymbolWithQualifiedName) || ((OCSymbolWithQualifiedName)ocSymbol).getQualifierParent() != null;
                    if (isMember && !OCGlobalProjectSymbolsBuilder.this.myCppMemberSymbols.addIfAbsent(ocSymbol.getName(), ocSymbol)) {
                        return true;
                    }
                    if (ocSymbol instanceof OCNamespaceSymbol) {
                        ((OCNamespaceSymbol)ocSymbol).processMembers((String)null, this);
                    }
                    return true;
                }
            });
        } else if (symbol.getKind().isTypedefOrAlias()) {
            String refName = symbol.getType().getName();
            this.myTypeAliases.addIfAbsent(refName, symbol);
        }
    }

    private final class ModuleWorker
    extends CountedCompleter<Void> {
        @NotNull
        private final List<String> workset;

        private ModuleWorker(@NotNull CountedCompleter parent, List<String> workset) {
            super(parent);
            this.workset = workset;
        }

        @Override
        public void compute() {
            ImmutableList.Builder additionalFiles = ImmutableList.builder();
            for (String moduleName : this.workset) {
                ProgressManager.checkCanceled();
                ModuleMapManager.Cache globalCache = OCGlobalProjectSymbolsBuilder.this.myModuleMapManager.getGlobalCache();
                ModuleMapSymbol module2 = (ModuleMapSymbol)ReadAction.compute(() -> globalCache.findModule(moduleName));
                if (module2 == null) continue;
                for (VirtualFile header : module2.getIncludeHeaders()) {
                    if (!OCGlobalProjectSymbolsBuilder.this.myProcessed.add(header)) continue;
                    additionalFiles.add((Object)header);
                }
            }
            ImmutableList additionalWorkset = additionalFiles.build();
            if (!additionalWorkset.isEmpty()) {
                OCGlobalProjectSymbolsBuilder.this.forkAsPending(this, new FileWorker(this, additionalWorkset));
            }
            this.propagateCompletion();
        }
    }

    private final class AdditionalTablesWorker
    extends CountedCompleter<Void> {
        @NotNull
        private final ImmutableList<VirtualFile> workset;

        private AdditionalTablesWorker(@NotNull CountedCompleter parent, ImmutableList<VirtualFile> workset) {
            super(parent);
            this.workset = workset;
        }

        @Override
        public void compute() {
            for (VirtualFile file2 : this.workset) {
                OCAdditionalFileSymbolTableBuilder.buildAllAdditionalTables(OCGlobalProjectSymbolsBuilder.this.myCache.getProject(), file2);
            }
            OCGlobalProjectSymbolsBuilder.this.forkAsPending(this, new FileWorker(this, this.workset));
            this.propagateCompletion();
        }
    }

    private final class FileWorker
    extends CallerAwareJob.IterativeWorker<VirtualFile> {
        @NotNull
        private final List<String> additionalModulesWorkset;
        @NotNull
        private final List<VirtualFile> additionalTablesWorkset;

        private FileWorker(@NotNull CountedCompleter parent, ImmutableList<? extends VirtualFile> workset) {
            super(parent, workset);
            this.additionalModulesWorkset = new ArrayList<String>();
            this.additionalTablesWorkset = new ArrayList<VirtualFile>();
        }

        @NotNull
        protected FileWorker newWorker(@NotNull ImmutableList<? extends VirtualFile> workset) {
            return new FileWorker((CountedCompleter)this, workset);
        }

        @Override
        protected void process(@NotNull ImmutableList<? extends VirtualFile> workset) {
            Processor symbolProcessor = symbol -> {
                if (symbol instanceof OCModuleImportSymbol) {
                    String moduleName = symbol.getName();
                    if (OCGlobalProjectSymbolsBuilder.this.myProcessedModules.add(moduleName)) {
                        this.additionalModulesWorkset.add(moduleName);
                    }
                } else {
                    OCGlobalProjectSymbolsBuilder.this.addSymbol(symbol);
                }
                return true;
            };
            for (VirtualFile file2 : workset) {
                if (OCAdditionalFileSymbolTableBuilder.shouldBuildAdditionalTables(OCGlobalProjectSymbolsBuilder.this.myCache.getProject(), file2)) {
                    this.additionalTablesWorkset.add(file2);
                    continue;
                }
                for (FileSymbolTable table : OCGlobalProjectSymbolsBuilder.this.myCache.allTablesForFile(file2)) {
                    if (!(table.getSignature().myLanguageKind instanceof CLanguageKind) && !(table.getSignature().myLanguageKind instanceof CUDALanguageKind)) continue;
                    table.processFile((Processor<? super OCSymbol>)symbolProcessor);
                }
            }
        }

        @Override
        protected void processingFinished() {
            if (!this.additionalModulesWorkset.isEmpty()) {
                OCGlobalProjectSymbolsBuilder.this.scheduleOnCallerAsPending(this, new ModuleWorker(this, this.additionalModulesWorkset));
            }
            if (!this.additionalTablesWorkset.isEmpty()) {
                OCGlobalProjectSymbolsBuilder.this.scheduleOnCallerAsPending(this, new AdditionalTablesWorker(this, ImmutableList.copyOf(this.additionalTablesWorkset)));
            }
            this.propagateCompletion();
        }
    }

    private static final class StringToSymbolConcurrentMultiMap
    extends MultiMap<String, OCSymbol> {
        StringToSymbolConcurrentMultiMap(int size) {
            super(new ConcurrentHashMap(size));
        }

        StringToSymbolConcurrentMultiMap() {
            super(new ConcurrentHashMap());
        }

        @NotNull
        protected Collection<OCSymbol> createCollection() {
            return ConcurrentCollectionFactory.createConcurrentSet((TObjectHashingStrategy)ContainerUtil.identityStrategy());
        }
    }
}

