/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.ArraysKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContextSignature
implements Serializable {
    public static final int NO_EXACT_DEFINITION_MARKER = Integer.MAX_VALUE;
    private final String @NotNull [] myDefined;
    private final int @NotNull [] myDefinedHashes;
    private final String @NotNull [] myNotDefined;
    @Nullable
    private final String myHeaderGuard;
    private final boolean myHeaderGuardDefined;
    private final String @NotNull [] myNamespace;
    private int myDistinctiveDefinedCount = 0;
    private int myDistinctiveNotDefinedCount = 0;
    @Nullable
    public final OCLanguageKind myLanguageKind;
    final boolean myIsSurrogate;

    public ContextSignature(@Nullable OCLanguageKind kind, @NotNull Map<String, Integer> definitions, @NotNull Set<String> notDefined, @NotNull List<String> namespace, boolean isSurrogate, @Nullable String headerGuard, boolean headerGuardDefined) {
        this.myLanguageKind = kind;
        this.myIsSurrogate = isSurrogate;
        int defSize = definitions.size();
        this.myDefined = ArrayUtil.newStringArray((int)defSize);
        this.myDefinedHashes = ArrayUtil.newIntArray((int)defSize);
        int curDef = 0;
        for (Map.Entry<String, Integer> e : definitions.entrySet()) {
            this.myDefined[curDef] = e.getKey();
            Integer hash = e.getValue();
            this.myDefinedHashes[curDef] = hash == null ? Integer.MAX_VALUE : ContextSignature.packedHash(hash);
            ++curDef;
        }
        this.myNotDefined = ArrayUtilRt.toStringArray(notDefined);
        this.myHeaderGuard = headerGuard;
        this.myHeaderGuardDefined = this.myHeaderGuard != null && headerGuardDefined;
        this.myNamespace = ArrayUtilRt.toStringArray(namespace);
    }

    public ContextSignature() {
        this(null, Collections.emptyMap(), Collections.emptySet(), Collections.emptyList(), false, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompatible(@NotNull OCImmutableInclusionContext ctx) {
        if (ctx.getLanguageKind() != this.myLanguageKind) {
            return false;
        }
        if (this.myIsSurrogate && !ctx.isSurrogate()) {
            return false;
        }
        List<String> namespace = ctx.getCurrentNamespace();
        if (!namespace.equals(Arrays.asList(this.myNamespace))) {
            return false;
        }
        if (this.myHeaderGuard != null && ctx.getDefinition(this.myHeaderGuard, OCImmutableInclusionContext.SignaturePart.NO) == null == this.myHeaderGuardDefined) {
            return false;
        }
        ContextSignature contextSignature = this;
        synchronized (contextSignature) {
            int i2;
            for (i2 = 0; i2 < this.myDistinctiveDefinedCount; ++i2) {
                if (ContextSignature.checkDefined(ctx, this.myDefined[i2], this.myDefinedHashes[i2])) continue;
                return false;
            }
            for (i2 = 0; i2 < this.myDistinctiveNotDefinedCount; ++i2) {
                if (!ctx.isDefined(this.myNotDefined[i2], true)) continue;
                return false;
            }
            for (i2 = this.myDistinctiveDefinedCount; i2 < this.myDefined.length; ++i2) {
                if (ContextSignature.checkDefined(ctx, this.myDefined[i2], this.myDefinedHashes[i2])) continue;
                ArrayUtil.swap((Object[])this.myDefined, (int)this.myDistinctiveDefinedCount, (int)i2);
                ArrayUtil.swap((int[])this.myDefinedHashes, (int)this.myDistinctiveDefinedCount, (int)i2);
                ++this.myDistinctiveDefinedCount;
                return false;
            }
            for (i2 = this.myDistinctiveNotDefinedCount; i2 < this.myNotDefined.length; ++i2) {
                if (!ctx.isDefined(this.myNotDefined[i2], true)) continue;
                ArrayUtil.swap((Object[])this.myNotDefined, (int)this.myDistinctiveNotDefinedCount, (int)i2);
                ++this.myDistinctiveNotDefinedCount;
                return false;
            }
        }
        return true;
    }

    private static boolean checkDefined(@NotNull OCImmutableInclusionContext ctx, String def, int defHash) {
        boolean ok;
        boolean shouldCheckExactDefinition = defHash != Integer.MAX_VALUE;
        OCMacroSymbol ctxDef = ctx.getDefinition(def, shouldCheckExactDefinition ? OCImmutableInclusionContext.SignaturePart.EXACT_DEFINITION : OCImmutableInclusionContext.SignaturePart.HAS_DEFINITION, true);
        boolean bl = ok = ctxDef != null;
        if (ok && shouldCheckExactDefinition) {
            ok = defHash == ContextSignature.packedHash(ctxDef.getSubstitutionHash());
        }
        return ok;
    }

    private static int packedHash(int hash) {
        return hash == Integer.MAX_VALUE ? hash - 1 : hash;
    }

    public boolean sameSignature(@NotNull ContextSignature other) {
        HashSet nd2;
        if (!Comparing.equal((Object)this.myLanguageKind, (Object)other.myLanguageKind)) {
            return false;
        }
        if (this.myIsSurrogate != other.myIsSurrogate) {
            return false;
        }
        HashSet nd1 = ContainerUtil.newHashSet((Object[])this.myNotDefined);
        if (!Comparing.equal((Object)nd1, (Object)(nd2 = ContainerUtil.newHashSet((Object[])other.myNotDefined)))) {
            return false;
        }
        Map d1 = ContainerUtil.newHashMap(Arrays.asList(this.myDefined), (List)ArraysKt.asList((int[])this.myDefinedHashes));
        Map d2 = ContainerUtil.newHashMap(Arrays.asList(other.myDefined), (List)ArraysKt.asList((int[])other.myDefinedHashes));
        return Comparing.equal((Object)d1, (Object)d2);
    }

    synchronized void dumpStats(@NotNull PrintWriter out) {
        String guard = this.myHeaderGuard;
        String prefix = "  ";
        out.println(prefix + "Guard: " + (guard == null ? "" : guard + " -> " + this.myHeaderGuardDefined));
        ArrayList<String> defined = new ArrayList<String>(Arrays.asList(this.myDefined));
        ContextSignature.dumpDefines(out, defined, this.myDistinctiveDefinedCount, prefix + "Defined:", prefix + "+ ");
        ArrayList<String> notDefined = new ArrayList<String>(Arrays.asList(this.myNotDefined));
        ContextSignature.dumpDefines(out, notDefined, this.myDistinctiveNotDefinedCount, prefix + "Not defined:", prefix + "- ");
    }

    private static void dumpDefines(@NotNull PrintWriter out, @NotNull List<String> defined, int distinctiveCount, @NotNull String title, @NotNull String prefix) {
        ArrayList<String> distinctive = new ArrayList<String>(defined.subList(0, distinctiveCount));
        Collections.sort(defined);
        out.println(title + " (" + StringUtil.join(distinctive, (String)", ") + ")");
        for (String d : defined) {
            out.println(prefix + d + (distinctive.contains(d) ? "  <<" : ""));
        }
    }
}

