/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCCompilerGeneratedConstructorSymbol;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.symbols.ComplexTextRange;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeductionGuideSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbolImpl;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.FindConstructorResult;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.visitors.OCTypeResolveVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import icons.CidrLangIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCStructSymbol
extends OCNamespaceSymbol
implements OCTemplateSymbol {
    private static final Key<CachedValue<Map<OCStructSymbol, Boolean>>> TRIVIAL_DTOR_CACHE = Key.create((String)"TRIVIAL_DTOR_CACHE_IN_FILE");
    private OCSymbolKind mySymbolKind;
    @NotNull
    private List<Pair<OCType, OCVisibility>> myBaseCppClasses;
    @NotNull
    private List<OCTypeParameterSymbol> myTemplateParameters;
    @Nullable
    private List<OCTypeArgument> myTemplateSpecialization;
    @NotNull
    private OCTypeSubstitution mySubstitution = OCTypeSubstitution.ID;
    @Nullable
    private ComplexTextRange myScope;
    @Nullable
    private List<OCType> myBefriendedTypes;
    private int myPropertiesAndAttributes;
    private boolean myHasClassKeyword;

    public OCStructSymbol() {
    }

    public OCStructSymbol(@Nullable VirtualFile file2, long offset, @Nullable OCSymbolWithQualifiedName parent, @NotNull OCQualifiedName name, @NotNull List<String> attributes, @NotNull OCSymbolKind kind, @NotNull List<Pair<OCType, OCVisibility>> baseClasses, @NotNull List<OCTypeParameterSymbol> templateParameters, @Nullable List<OCTypeArgument> templateSpecialization, @Nullable List<OCSymbol> membersList, @Nullable MostlySingularMultiMap<String, OCSymbol> members, @Nullable ComplexTextRange scope, @Nullable OCVisibility visibility, int classProperties, int classAttributes, boolean hasClassKeyword) {
        super(file2, offset, parent, name, attributes, membersList, members, null, false, visibility);
        assert (kind == OCSymbolKind.STRUCT || kind == OCSymbolKind.UNION || kind == OCSymbolKind.ENUM);
        this.mySymbolKind = kind;
        this.myBaseCppClasses = baseClasses;
        this.myTemplateParameters = templateParameters;
        this.myTemplateSpecialization = templateSpecialization;
        this.myScope = scope;
        this.myPropertiesAndAttributes = classProperties | classAttributes;
        this.myHasClassKeyword = hasClassKeyword;
    }

    public OCStructSymbol(@NotNull OCStructSymbol origin, @NotNull OCTypeSubstitution substitution2) {
        this(origin, substitution2, origin.getParent());
    }

    public OCStructSymbol(@NotNull OCStructSymbol origin, @NotNull OCTypeSubstitution substitution2, @Nullable OCSymbolWithQualifiedName parent) {
        super(origin.myFile, origin.myComplexOffset, parent, origin.getQualifiedName(), origin.getAttributes(), origin.getMembersList(), origin.getMembers(), null, false, origin.myVisibility);
        this.mySymbolKind = origin.getKind();
        this.myBaseCppClasses = origin.myBaseCppClasses;
        this.myTemplateParameters = origin.myTemplateParameters;
        this.myTemplateSpecialization = origin.myTemplateSpecialization;
        this.mySubstitution = substitution2;
        this.myScope = origin.getScope();
        this.myBefriendedTypes = origin.myBefriendedTypes;
        this.myPropertiesAndAttributes = origin.myPropertiesAndAttributes;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCStructSymbol f = (OCStructSymbol)first;
        OCStructSymbol s = (OCStructSymbol)second;
        if (!c.equalLists(f.myBefriendedTypes, s.myBefriendedTypes)) {
            return false;
        }
        if (f.myPropertiesAndAttributes != s.myPropertiesAndAttributes) {
            return false;
        }
        if (!Comparing.equal((Object)f.myScope, (Object)s.myScope)) {
            return false;
        }
        if (!Comparing.equal((Object)((Object)f.mySymbolKind), (Object)((Object)s.mySymbolKind))) {
            return false;
        }
        if (!c.equalLists(f.myBaseCppClasses, s.myBaseCppClasses)) {
            return false;
        }
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        if (!c.equalLists(f.myTemplateParameters, s.myTemplateParameters)) {
            return false;
        }
        return c.equalLists(f.myTemplateSpecialization, s.myTemplateSpecialization);
    }

    @Override
    public void updateOffset(int start, int lengthShift) {
        super.updateOffset(start, lengthShift);
        for (OCTypeParameterSymbol parameter : this.myTemplateParameters) {
            parameter.updateOffset(start, lengthShift);
        }
    }

    @Override
    public void compact() {
        super.compact();
        this.myBaseCppClasses = ContainerUtil.trimToSize(this.myBaseCppClasses);
        this.myTemplateParameters = ContainerUtil.trimToSize(this.myTemplateParameters);
        this.myTemplateSpecialization = ContainerUtil.trimToSize(this.myTemplateSpecialization);
        for (OCTypeParameterSymbol parameter : this.myTemplateParameters) {
            parameter.compact();
        }
        this.myBefriendedTypes = ContainerUtil.trimToSize(this.myBefriendedTypes);
    }

    @Override
    public boolean isFriend() {
        return this.hasAttribute(OCSymbolAttribute.FRIEND);
    }

    public boolean isFinal() {
        return this.hasAttribute(OCSymbolAttribute.FINAL);
    }

    public boolean isEnumClass() {
        return this.hasProperty(Property.IS_ENUM_CLASS);
    }

    public boolean isClass() {
        return this.getKind() == OCSymbolKind.STRUCT && this.myHasClassKeyword;
    }

    public boolean isStruct() {
        return this.getKind() == OCSymbolKind.STRUCT && !this.myHasClassKeyword;
    }

    @Override
    public boolean isQualifiedContainer() {
        return this.hasProperty(Property.IS_QUALIFIED_CONTAINER);
    }

    public boolean isEnum() {
        return this.getKind() == OCSymbolKind.ENUM;
    }

    @Override
    public boolean isTemplateSymbol() {
        return this.myTemplateParameters.size() != 0 || this.myTemplateSpecialization != null;
    }

    public boolean isInnerClass() {
        for (OCSymbolWithQualifiedName parent = this.myParent; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof OCStructSymbol)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttribute(@NotNull OCSymbolAttribute attr) {
        return (this.myPropertiesAndAttributes & attr.getMask()) != 0;
    }

    public boolean hasProperty(@NotNull Property prop) {
        return (this.myPropertiesAndAttributes & prop.getMask()) != 0;
    }

    @Override
    @NotNull
    public List<OCTypeParameterSymbol> getTemplateParameters() {
        return this.myTemplateParameters;
    }

    @Override
    @Nullable
    public List<OCTypeArgument> getTemplateSpecialization() {
        return this.myTemplateSpecialization;
    }

    @Nullable
    public List<OCType> getBefriendedTypes() {
        return this.myBefriendedTypes;
    }

    @Override
    @NotNull
    public OCTypeSubstitution getSubstitution() {
        return this.mySubstitution;
    }

    @Override
    public boolean isVariadicTemplate() {
        return OCTemplateSymbolImpl.isVariadicTemplate(this);
    }

    @Override
    public boolean isSpecialization() {
        return this.getTemplateSpecialization() != null;
    }

    @Override
    public boolean isExplicitInstantiation() {
        return this.isTemplateSymbol() && this.getTemplateParameters().isEmpty();
    }

    @Override
    public int getRequiredTemplateArgumentsCnt() {
        return OCTemplateSymbolImpl.getRequiredTemplateArgumentsCnt(this);
    }

    @Override
    public boolean isGlobal() {
        return this.myScope == null;
    }

    @Override
    public boolean isPredeclaration() {
        return this.getMembers() == null;
    }

    @Override
    public boolean isDefinition() {
        return !this.isPredeclaration();
    }

    public void addBefriendedType(@NotNull OCType type) {
        if (this.myBefriendedTypes == null) {
            this.myBefriendedTypes = new ArrayList<OCType>(1);
        }
        this.myBefriendedTypes.add(type);
    }

    public String getNiceAttributes() {
        ArrayList<String> words = new ArrayList<String>();
        for (OCSymbolAttribute oCSymbolAttribute : OCSymbolAttribute.values()) {
            if (!this.hasAttribute(oCSymbolAttribute)) continue;
            words.add(StringUtil.toLowerCase((String)oCSymbolAttribute.name()));
        }
        for (Enum enum_ : Property.values()) {
            if (!this.hasProperty((Property)enum_)) continue;
            words.add(enum_.name().substring(3));
        }
        return "\u300a" + StringUtil.join(words, (String)" ") + "\u300b";
    }

    @Override
    public String toString() {
        return (Object)((Object)this.getKind()) + this.getNiceAttributes() + "[" + this.getName() + "]@" + this.getOffset();
    }

    @Override
    @NotNull
    public String getKindUppercase(@NotNull OCCompilationContext context2) {
        OCSymbolKind kind = this.getKind();
        if (kind == OCSymbolKind.STRUCT && context2.isCpp()) {
            return "Class";
        }
        return super.getKindUppercase(context2);
    }

    @Override
    public boolean processMembers(@Nullable String memberName, @NotNull Processor<? super OCSymbol> processor2) {
        Processor inner = this.mySubstitution != OCTypeSubstitution.ID ? symbol -> processor2.process((Object)this.mySubstitution.substitute(symbol, this, false)) : processor2;
        return super.processMembers(memberName, (Processor<? super OCSymbol>)inner);
    }

    public boolean processFields(@NotNull Processor<? super OCDeclaratorSymbol> processor2) {
        return this.processMembers((String)null, new OCCommonProcessors.TypeFilteredProcessor(processor2, OCDeclaratorSymbol.class));
    }

    public boolean processFunctions(@Nullable String name, @NotNull Processor<? super OCFunctionSymbol> processor2) {
        return this.processMembers(name, new OCCommonProcessors.TypeFilteredProcessor(processor2, OCFunctionSymbol.class));
    }

    @Nullable
    public OCDeclaratorSymbol findField(String name) {
        MostlySingularMultiMap<String, OCSymbol> members = this.getMembers();
        if (members == null) {
            return null;
        }
        CommonProcessors.FindFirstProcessor<OCSymbol> finder = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(@NotNull OCSymbol symbol) {
                return symbol.getDelegate() instanceof OCDeclaratorSymbol;
            }
        };
        members.processForKey((Object)name, (Processor)finder);
        OCDeclaratorSymbol result2 = (OCDeclaratorSymbol)finder.getFoundValue();
        return result2 != null ? (OCDeclaratorSymbol)result2.getDelegate() : null;
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return this.mySymbolKind;
    }

    @Override
    @NotNull
    public OCStructType getType() {
        return new OCStructType(this);
    }

    @Override
    @Nullable
    public ComplexTextRange getScope() {
        return this.myScope;
    }

    @Override
    public void setScope(@NotNull ComplexTextRange scope) {
        this.myScope = scope;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return this.getType().getName();
    }

    @Override
    public Icon computeFullIconNow(@Nullable PsiElement symbolElement, @NotNull Project project2) {
        Icon result2 = super.computeFullIconNow(symbolElement, project2);
        if (result2 == null) {
            return null;
        }
        return OCTestFrameworks.isTestClassOrStruct(this, symbolElement, project2) ? OCIcons.getTestIcon(result2) : result2;
    }

    private boolean processAllMembersWithName(String name, Processor<OCSymbol> processor2, @NotNull Project project2) {
        if (!this.isGlobal()) {
            return this.processMembers(name, (Processor<? super OCSymbol>)processor2);
        }
        OCSymbol definition = this.getDefinitionSymbol(project2);
        Processor _processor = symbol -> {
            if (!symbol.getClass().equals(OCFunctionSymbol.class)) {
                return true;
            }
            OCSymbolWithQualifiedName resolvedQualifiedName = ((OCSymbolWithQualifiedName)symbol).getResolvedOwner(OCResolveContext.forSymbol(symbol, project2));
            if (resolvedQualifiedName == null || !resolvedQualifiedName.equals(definition)) {
                return true;
            }
            return processor2.process(symbol);
        };
        return OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project2, (Processor<? super OCSymbol>)_processor, name);
    }

    public boolean processConstructors(Processor<? super OCFunctionSymbol> processor2) {
        return this.processConstructors(processor2, false, false, false, null);
    }

    public boolean processConstructors(Processor<? super OCFunctionSymbol> processor2, @NotNull OCResolveContext context2) {
        return this.processConstructors(processor2, false, true, false, context2);
    }

    public boolean processConstructors(Processor<? super OCFunctionSymbol> processor2, boolean includeOutOfClassDefinitions, @NotNull OCResolveContext context2) {
        return this.processConstructors(processor2, includeOutOfClassDefinitions, false, false, context2);
    }

    private boolean processConstructors(Processor<? super OCFunctionSymbol> processor2, boolean includeOutOfClassDefinitions, boolean includeUsingBaseConstructors, boolean includeImplicitCtors, @Nullable OCResolveContext context2) {
        Processor memberProcessor = symbol -> {
            if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppConstructor()) {
                return processor2.process((Object)((OCFunctionSymbol)symbol));
            }
            return true;
        };
        if (includeUsingBaseConstructors && context2 != null && !this.processConstructorsFromUsings((Processor<? super OCSymbol>)memberProcessor, context2)) {
            return false;
        }
        if (includeImplicitCtors && context2 != null && this.processConstructors((Processor<? super OCFunctionSymbol>)new CommonProcessors.FindFirstProcessor(), context2) && !processor2.process((Object)new OCCompilerGeneratedConstructorSymbol(this, OCCompilerGeneratedConstructorSymbol.Kind.DefaultCtor, context2.getProject()))) {
            return false;
        }
        if (includeOutOfClassDefinitions) {
            assert (context2 != null);
            return this.processAllMembersWithName(this.getName(), (Processor<OCSymbol>)memberProcessor, context2.getProject());
        }
        return this.processMembers(this.getName(), (Processor<? super OCSymbol>)memberProcessor);
    }

    public boolean processConstructorsFromUsings(@NotNull Processor<? super OCSymbol> processor2, @NotNull OCResolveContext context2) {
        return this.processMembers((String)null, (Processor<? super OCSymbol>)((Processor)symbol -> {
            if (symbol instanceof OCUsingSymbol) {
                OCSymbolReference reference = ((OCUsingSymbol)symbol).getSymbolReference();
                OCQualifiedName name = reference.getQualifiedName();
                OCQualifiedName qualifier = name.getQualifier();
                Set set = OCTypeUtils.newTypeSet();
                this.processConstructors((Processor<? super OCFunctionSymbol>)((Processor)c -> set.add(new OCFunctionType(this.getType(), c.getType().getParameterTypes()))), false, false, false, context2);
                Processor ctorProcessor = c -> {
                    OCFunctionSymbol ctor = this.mySubstitution.substitute(new OCCompilerGeneratedConstructorSymbol(this, c.getParameterSymbols()), context2);
                    return set.contains(ctor.getType()) || processor2.process((Object)ctor);
                };
                if (qualifier != null && qualifier.getNameWithParent().equals(name.getName())) {
                    for (OCSymbol baseClass : reference.getSymbolReferenceToQualifier().resolveToSymbols(true, true, true, context2.substitute(this.getSubstitution()))) {
                        if (!this.isSameSymbol(baseClass, context2) && (!(baseClass instanceof OCStructSymbol) || ((OCStructSymbol)baseClass).processConstructors((Processor<? super OCFunctionSymbol>)ctorProcessor, false, true, true, context2))) continue;
                        return false;
                    }
                }
                return reference.processPossibleSymbols((Processor<OCSymbol>)((Processor)s -> !(s instanceof OCFunctionSymbol) || !((OCFunctionSymbol)s).isCppConstructor() || ctorProcessor.process((Object)((OCFunctionSymbol)s))), context2.substitute(((OCUsingSymbol)symbol).getSubstitution()));
            }
            return true;
        }));
    }

    public boolean processDestructors(Processor<? super OCFunctionSymbol> processor2, boolean includeOutOfClassDefinitions, @NotNull OCResolveContext context2) {
        Processor memberProcessor = symbol -> {
            if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppDestructor()) {
                return processor2.process((Object)((OCFunctionSymbol)symbol));
            }
            return true;
        };
        if (includeOutOfClassDefinitions) {
            return this.processAllMembersWithName("~" + this.getName(), (Processor<OCSymbol>)memberProcessor, context2.getProject());
        }
        return this.processMembers("~" + this.getName(), (Processor<? super OCSymbol>)memberProcessor);
    }

    public boolean processDeductionGuides(Processor<? super OCDeductionGuideSymbol> processor2, @NotNull OCResolveContext context2) {
        Processor _processor = symbol -> {
            OCDeductionGuideSymbol deductionGuideSymbol;
            OCStructSymbol templateId;
            if (symbol instanceof OCDeductionGuideSymbol && (templateId = (deductionGuideSymbol = (OCDeductionGuideSymbol)symbol).getResolvedTemplateId(OCResolveContext.forSymbol(symbol, context2.getProject()))) != null && templateId.isSameSymbol(this, context2)) {
                return processor2.process((Object)deductionGuideSymbol);
            }
            return true;
        };
        return OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(context2.getProject(), (Processor<? super OCSymbol>)_processor, this.getName());
    }

    public boolean hasDefaultConstructor(@NotNull OCResolveContext context2) {
        class MyProcessor
        implements Processor<OCFunctionSymbol> {
            boolean wasConstructor;
            boolean wasDefaultConstructor;

            MyProcessor() {
            }

            public boolean process(OCFunctionSymbol symbol) {
                this.wasConstructor = true;
                this.wasDefaultConstructor |= symbol.canBeCalledWithoutArguments();
                return true;
            }

            public boolean hasDefaultConstructor() {
                return !this.wasConstructor || this.wasDefaultConstructor;
            }
        }
        MyProcessor processor2 = new MyProcessor();
        this.processConstructors(processor2, context2);
        return processor2.hasDefaultConstructor();
    }

    public boolean hasDeclaredConstructor(@NotNull OCResolveContext context2) {
        return !this.processConstructors((Processor<? super OCFunctionSymbol>)new CommonProcessors.FindFirstProcessor(), context2);
    }

    @Nullable
    public OCFunctionSymbol getDefaultConstructor(@NotNull OCResolveContext context2) {
        CommonProcessors.FindFirstProcessor<OCFunctionSymbol> finder = new CommonProcessors.FindFirstProcessor<OCFunctionSymbol>(){

            protected boolean accept(OCFunctionSymbol symbol) {
                return symbol.canBeCalledWithoutArguments();
            }
        };
        this.processConstructors((Processor<? super OCFunctionSymbol>)finder, context2);
        return (OCFunctionSymbol)finder.getFoundValue();
    }

    public boolean hasTrivialDestructor(@NotNull OCResolveContext context2) {
        PsiFile file2 = context2.getFile();
        Map<OCStructSymbol, Boolean> cache = OCStructSymbol.getTrivialDtorCache(file2);
        if (cache != null && cache.containsKey(this)) {
            return cache.get(this);
        }
        boolean hasTrivialDestructor = this.hasTrivialDestructor(new HashMap<OCStructSymbol, Optional<Boolean>>(), context2);
        if (cache != null) {
            cache.put(this, hasTrivialDestructor);
        }
        return hasTrivialDestructor;
    }

    private static Map<OCStructSymbol, Boolean> getTrivialDtorCache(@Nullable PsiFile file2) {
        if (file2 == null) {
            return null;
        }
        CachedValuesManager manager2 = CachedValuesManager.getManager((Project)file2.getProject());
        ModificationTracker modificationTracker = FileSymbolTablesCache.getInstance(file2.getProject()).getOutOfBlockModificationTracker();
        CachedValueProvider provider2 = () -> new CachedValueProvider.Result(OCTypeUtils.newDeepEqualityMap(), new Object[]{modificationTracker});
        return (Map)manager2.getCachedValue((UserDataHolder)file2, TRIVIAL_DTOR_CACHE, provider2, false);
    }

    private boolean hasTrivialDestructor(@NotNull HashMap<OCStructSymbol, Optional<Boolean>> processingSymbols, @NotNull OCResolveContext context2) {
        if (processingSymbols.containsKey(this)) {
            Optional<Boolean> hasTrivialDestructor = processingSymbols.get(this);
            return hasTrivialDestructor.orElse(false);
        }
        OCStructType myType = this.getType();
        OCSymbolKind kind = this.getKind();
        if (kind != OCSymbolKind.STRUCT && kind != OCSymbolKind.UNION) {
            return true;
        }
        Processor dtorProcessor = dtor -> !dtor.isVirtual() && dtor.isDefault();
        BaseClassProcessor baseClassProcessor = (symbol, visibility) -> {
            if (symbol instanceof OCStructSymbol) {
                return ((OCStructSymbol)symbol).hasTrivialDestructor(processingSymbols, context2);
            }
            return false;
        };
        Processor fieldsProcessor = field -> {
            OCType type = field.getType().resolve(context2);
            if (type instanceof OCStructType) {
                return ((OCStructType)type).getSymbol().hasTrivialDestructor(processingSymbols, context2);
            }
            return !type.isUnknown();
        };
        processingSymbols.put(this, Optional.empty());
        boolean hasTrivialDestructor = !this.isPredeclaration() && !myType.isMagicInside(context2) && this.processDestructors((Processor<? super OCFunctionSymbol>)dtorProcessor, false, context2) && this.processBaseClasses(context2, baseClassProcessor) && this.processFields((Processor<? super OCDeclaratorSymbol>)fieldsProcessor);
        processingSymbols.put(this, Optional.of(hasTrivialDestructor));
        return hasTrivialDestructor;
    }

    public boolean hasBaseClasses() {
        return !this.myBaseCppClasses.isEmpty();
    }

    public boolean isPOD(boolean checkInnerStructs, @NotNull OCResolveContext context2) {
        if (this.mySymbolKind != OCSymbolKind.STRUCT && this.mySymbolKind != OCSymbolKind.ENUM) {
            return false;
        }
        if (this.hasBaseClasses()) {
            return false;
        }
        return OCStructSymbol.isPOD(this, new HashSet<OCSymbol>(), checkInnerStructs, context2);
    }

    public boolean isPOD(@NotNull OCResolveContext context2) {
        return this.isPOD(true, context2);
    }

    private static boolean isPOD(OCStructSymbol symbol, Set<OCSymbol> processed, boolean checkInnerStructs, @NotNull OCResolveContext context2) {
        boolean[] pod = new boolean[]{true};
        symbol.processMembers((String)null, (Processor<? super OCSymbol>)((Processor)symbol12 -> {
            if (!processed.add((OCSymbol)symbol12)) {
                return true;
            }
            if (symbol12 instanceof OCStructSymbol) {
                if (checkInnerStructs && !OCStructSymbol.isPOD((OCStructSymbol)symbol12, processed, true, context2)) {
                    pod[0] = false;
                    return false;
                }
            } else if (symbol12 instanceof OCDeclaratorSymbol) {
                OCVisibility vis = ((OCDeclaratorSymbol)symbol12).getVisibility();
                if (vis != null && vis != OCVisibility.HACK_MORE_VISIBLE_THAN_PUBLIC && vis != OCVisibility.PUBLIC) {
                    pod[0] = false;
                    return false;
                }
                OCType type = symbol12.getType().resolve(context2);
                if (checkInnerStructs && type instanceof OCStructType && symbol12.getKind() != OCSymbolKind.TYPEDEF && ContainerUtil.exists(((OCStructType)type).getStructs(), symbol1 -> !OCStructSymbol.isPOD(symbol1, processed, true, context2))) {
                    pod[0] = false;
                    return false;
                }
            }
            return true;
        }));
        return pod[0];
    }

    public boolean hasMemberFunctions() {
        return !this.processFunctions(null, (Processor<? super OCFunctionSymbol>)new CommonProcessors.FindFirstProcessor());
    }

    @NotNull
    public Collection<OCType> getBaseCppClasses(@NotNull PsiElement context2) {
        return this.getBaseCppClasses(OCResolveContext.forPsi(context2));
    }

    @NotNull
    public Collection<OCType> getBaseCppClasses(@NotNull OCResolveContext context2) {
        return ContainerUtil.map(this.myBaseCppClasses, pair -> this.mySubstitution.substitute((OCType)pair.first, context2));
    }

    @NotNull
    public Collection<Pair<OCType, OCVisibility>> getBaseCppClassesWithVisibility(@NotNull OCResolveContext context2) {
        return ContainerUtil.map(this.myBaseCppClasses, pair -> {
            OCType type = this.mySubstitution.substitute((OCType)pair.first, context2);
            return new Pair((Object)type, pair.second);
        });
    }

    public boolean processBaseClasses(@NotNull OCResolveContext context2, BaseClassProcessor processor2) {
        for (Pair<OCType, OCVisibility> pair : this.myBaseCppClasses) {
            OCType type = this.mySubstitution.substitute((OCType)pair.first, context2);
            OCType resolved = type.accept(new OCTypeResolveVisitor(context2));
            if (OCStructSymbol.processBaseClass(resolved.isUnknown() ? type : resolved, (OCVisibility)((Object)pair.second), processor2, context2)) continue;
            return false;
        }
        return true;
    }

    private static boolean processBaseClass(OCType type, OCVisibility visibility, BaseClassProcessor processor2, @NotNull OCResolveContext context2) {
        block4: {
            block5: {
                block3: {
                    ProgressManager.checkCanceled();
                    if (!(type instanceof OCStructType)) break block3;
                    for (OCStructSymbol symbol : ((OCStructType)type).getStructs()) {
                        if (processor2.process(symbol, visibility)) continue;
                        return false;
                    }
                    break block4;
                }
                if (!(type instanceof OCReferenceType)) break block5;
                for (OCSymbol baseSymbol : context2.resolveToSymbols(((OCReferenceType)type).getReference(context2), true, true)) {
                    ProgressManager.checkCanceled();
                    if (processor2.process(baseSymbol, visibility)) continue;
                    return false;
                }
                break block4;
            }
            if (!(type instanceof OCExpansionPackType)) break block4;
            for (OCTypeArgument typeArgument : ((OCExpansionPackType)type).getExpansions()) {
                if (!(typeArgument instanceof OCType) || OCStructSymbol.processBaseClass((OCType)typeArgument, visibility, processor2, context2)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean processAllBaseClasses(BaseClassProcessor processor2, @NotNull OCResolveContext context2) {
        return this.processAllBaseClasses(context2, processor2, true);
    }

    public boolean processAllBaseClasses(@NotNull OCResolveContext context2, @NotNull BaseClassProcessor processor2, boolean skipFirstVisibility) {
        return this.processAllBaseClasses(context2, processor2, (Condition<OCStructSymbol>)Conditions.alwaysTrue(), skipFirstVisibility);
    }

    public boolean processAllBaseClasses(@NotNull OCResolveContext context2, @NotNull BaseClassProcessor processor2, @NotNull Condition<OCStructSymbol> filter, boolean skipFirstVisibility) {
        Set processed = OCTypeUtils.newSymbolWithSubstitutionSet();
        Stack structsWorkset = new Stack();
        Stack visibilityWorkset = new Stack();
        structsWorkset.add((Object)this);
        visibilityWorkset.add(null);
        while (!structsWorkset.isEmpty()) {
            OCStructSymbol symbol = (OCStructSymbol)structsWorkset.pop();
            OCVisibility visibility = (OCVisibility)((Object)visibilityWorkset.pop());
            if (processed.contains(symbol)) continue;
            processed.add(symbol);
            if (symbol.processBaseClasses(context2, (baseSymbol, baseVisibility) -> {
                baseVisibility = visibility == null ? (skipFirstVisibility ? OCVisibility.PUBLIC : baseVisibility) : OCVisibility.leastVisible(visibility, baseVisibility);
                if (!processor2.process(baseSymbol, baseVisibility)) {
                    return false;
                }
                if (baseSymbol instanceof OCStructSymbol && filter.value((Object)((OCStructSymbol)baseSymbol))) {
                    structsWorkset.push((Object)((OCStructSymbol)baseSymbol));
                    visibilityWorkset.push((Object)baseVisibility);
                }
                return true;
            })) continue;
            return false;
        }
        return true;
    }

    public boolean isAncestor(OCStructSymbol struct, @NotNull OCResolveContext context2) {
        return this.resolvedNamesEqual(struct, context2) || !struct.processAllBaseClasses((symbol, visibility) -> !(symbol instanceof OCStructSymbol) || !this.resolvedNamesEqual((OCSymbolWithQualifiedName)symbol, context2), context2);
    }

    @NotNull
    public List<OCTypeArgument> getTemplateArguments(@NotNull OCResolveContext context2) {
        ArrayList<OCTypeArgument> result2 = new ArrayList<OCTypeArgument>();
        List<OCTypeArgument> specialization = this.getTemplateSpecialization();
        if (specialization != null) {
            for (OCTypeArgument spec : specialization) {
                if (spec instanceof OCType) {
                    OCType substitution2 = ((OCType)spec).transformType(new OCTypeResolveVisitor(context2.substituteFirst(this.getSubstitution()), false));
                    if (substitution2 instanceof OCStructType && ((OCStructType)substitution2).getSymbol().equals(this)) continue;
                    result2.add(substitution2);
                    continue;
                }
                result2.add(spec);
            }
        } else {
            for (OCTypeParameterSymbol param : this.getTemplateParameters()) {
                OCTypeArgument argument = this.getSubstitution().getSubstitutionFor(param);
                if (argument instanceof OCExpansionPackType) {
                    result2.addAll(((OCExpansionPackType)argument).getExpansions());
                    continue;
                }
                if (argument != null) {
                    result2.add(argument);
                    continue;
                }
                result2.add(new OCTypeParameterType(param));
            }
        }
        return result2;
    }

    @NotNull
    public FindConstructorResult findConstructor(@NotNull OCArgumentsList<?> arguments, @NotNull OCResolveContext context2, @Nullable PsiElement localContext, boolean allowImplicitConversions, final @Nullable Supplier<Boolean> isExplicitCall, boolean isListInitialization, @NotNull OCStructType type) {
        CommonProcessors.CollectProcessor<OCSymbol> collector = new CommonProcessors.CollectProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return symbol instanceof OCFunctionSymbol;
            }
        };
        this.processConstructors((Processor<? super OCFunctionSymbol>)collector, context2);
        Collection symbols = collector.getResults();
        symbols.add(this);
        Collection filtered = isExplicitCall != null ? ContainerUtil.filter((Collection)symbols, (Condition)new Condition<OCSymbol>(){
            Boolean myExplicitConstructorCall;

            public boolean value(OCSymbol symbol) {
                if (!(symbol instanceof OCFunctionSymbol) || !((OCFunctionSymbol)symbol).isExplicit()) {
                    return true;
                }
                if (this.myExplicitConstructorCall == null) {
                    this.myExplicitConstructorCall = (Boolean)isExplicitCall.get();
                }
                return this.myExplicitConstructorCall;
            }
        }) : symbols;
        return OCResolveOverloadsUtil.resolveConstructorOverloads(type, filtered, arguments, allowImplicitConversions, isListInitialization, false, context2, localContext);
    }

    @Override
    @Nullable
    public Icon getBaseIcon() {
        if (this.myHasClassKeyword) {
            return this.isQualifiedContainer() ? CidrLangIcons.CodeAssistantClass : OCIcons.getVisibilityIcon(this.getVisibility(), CidrLangIcons.CodeAssistantClass);
        }
        return super.getBaseIcon();
    }

    @FunctionalInterface
    public static interface BaseClassProcessor {
        public boolean process(OCSymbol var1, OCVisibility var2);
    }

    public static final class Property
    extends Enum<Property> {
        public static final /* enum */ Property IS_ENUM_CLASS = new Property();
        public static final /* enum */ Property IS_QUALIFIED_CONTAINER = new Property();
        public static final int DEFAULT = 0;
        private static final /* synthetic */ Property[] $VALUES;

        public static Property[] values() {
            return (Property[])$VALUES.clone();
        }

        public static Property valueOf(String name) {
            return Enum.valueOf(Property.class, name);
        }

        public int getMask() {
            assert (this.ordinal() < 8);
            return 1 << 31 - this.ordinal();
        }

        static {
            $VALUES = new Property[]{IS_ENUM_CLASS, IS_QUALIFIED_CONTAINER};
        }
    }
}

