/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbolImpl;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCInitializerSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OCDeclaratorSymbol
extends OCSymbol,
OCSymbolWithQualifiedName,
OCTemplateSymbol {
    public boolean hasAttribute(@NotNull OCSymbolAttribute var1);

    public boolean hasProperty(@NotNull Property var1);

    @Nullable
    public OCInitializerSymbol getInitializer();

    @Nullable
    public OCExpressionSymbol getInitializerExpression();

    default public boolean isConstexpr() {
        return this.hasAttribute(OCSymbolAttribute.CONSTEXPR);
    }

    default public boolean isMutable() {
        return this.hasAttribute(OCSymbolAttribute.MUTABLE);
    }

    @Override
    default public boolean isStatic() {
        return this.hasAttribute(OCSymbolAttribute.STATIC);
    }

    @Override
    default public boolean isFriend() {
        return this.hasAttribute(OCSymbolAttribute.FRIEND);
    }

    default public boolean isExtern() {
        return this.hasAttribute(OCSymbolAttribute.EXTERN);
    }

    default public boolean isBlockModifiable() {
        return this.hasAttribute(OCSymbolAttribute.BLOCK_MODIFIABLE);
    }

    default public boolean isPassByReference() {
        return this.hasProperty(Property.IS_PASS_BY_REF);
    }

    @Override
    default public boolean isFromUsing() {
        return this.hasProperty(Property.IS_FROM_USING);
    }

    default public boolean hasInitializer() {
        return this.getInitializer() != null;
    }

    default public boolean hasInitializerExpression() {
        return this.getInitializerExpression() != null;
    }

    @Nullable
    default public OCDeclaratorSymbol getDeclarationInParent(@NotNull OCResolveContext context2) {
        return OCDeclaratorSymbolImpl.getDeclarationInParent(this, context2);
    }

    default public boolean resolveIsStatic(@NotNull OCResolveContext context2) {
        return OCDeclaratorSymbolImpl.resolveIsStatic(this, context2);
    }

    @Override
    default public Icon computeFullIconNow(@Nullable PsiElement symbolElement, @NotNull Project project2) {
        Icon result2 = this.getBaseIcon();
        if (result2 == null) {
            return null;
        }
        return this.getKind() == OCSymbolKind.GLOBAL_VARIABLE && OCTestFrameworks.isTestGlobalVar(this, symbolElement, project2) ? OCIcons.getTestIcon(result2) : result2;
    }

    @NotNull
    default public OCType getEffectiveType(@NotNull PsiElement context2) {
        return OCTypeUtils.changeTypeReferences(this.getEffectiveType(context2.getProject()), OCSymbolReference.getLocalReference(this.getName(), context2));
    }

    public static final class Property
    extends Enum<Property> {
        public static final /* enum */ Property IS_PASS_BY_REF = new Property();
        public static final /* enum */ Property IS_DECLARED_IN_LAMBDA_CAPTURE = new Property();
        public static final /* enum */ Property IS_SYNTHETIC = new Property();
        public static final /* enum */ Property IS_ENCODED_PARAM_INDEX = new Property();
        public static final /* enum */ Property IS_FROM_USING = new Property();
        public static final int DEFAULT = 0;
        private static final /* synthetic */ Property[] $VALUES;

        public static Property[] values() {
            return (Property[])$VALUES.clone();
        }

        public static Property valueOf(String name) {
            return Enum.valueOf(Property.class, name);
        }

        public int getMask() {
            assert (this.ordinal() < 8);
            return 1 << 31 - this.ordinal();
        }

        static {
            $VALUES = new Property[]{IS_PASS_BY_REF, IS_DECLARED_IN_LAMBDA_CAPTURE, IS_SYNTHETIC, IS_ENCODED_PARAM_INDEX, IS_FROM_USING};
        }
    }
}

