/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.symbols.MaybeVirtualFileOwner;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCSymbolBase
implements OCSymbol,
MaybeVirtualFileOwner {
    @Nullable
    protected transient VirtualFile myFile;
    protected long myComplexOffset;

    public OCSymbolBase(@Nullable VirtualFile file2, long complexOffset) {
        this.myFile = file2;
        this.myComplexOffset = complexOffset;
    }

    public OCSymbolBase() {
    }

    @NotNull
    public static String getSymbolName(@Nullable OCSymbol symbol) {
        return symbol == null ? "<unnamed>" : symbol.getName();
    }

    @NotNull
    public static String getTagOfStructLike(OCSymbol symbol) {
        String kind = symbol.getKind().getNameLowercase() + " ";
        String name = symbol.getPresentableName();
        if (name.startsWith(kind)) {
            return name.substring(kind.length());
        }
        return name;
    }

    @Nullable
    public static <T extends OCSymbol> T findSymbolDefinition(@Nullable String name, @NotNull OCSymbolKind symbolKind, @NotNull Project project2, @Nullable VirtualFile context2) {
        return OCSymbolBase.findSymbolDefinition(name, symbolKind, project2, context2, null);
    }

    @Nullable
    public static <T extends OCSymbol> T findSymbolDefinition(@Nullable String name, @NotNull OCSymbolKind symbolKind, @NotNull Project project2, @Nullable VirtualFile context2, @Nullable Condition<T> condition) {
        return (T)OCGlobalProjectSymbolsCache.findNearestTopLevelSymbol(project2, name, (Condition<? super OCSymbol>)((Condition)symbol -> symbol.getKind() == symbolKind && !symbol.isPredeclaration() && (condition == null || condition.value(symbol))), context2);
    }

    @Override
    public void init(@Nullable VirtualFile file2) {
        this.myFile = file2;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    protected Class<? extends PsiElement> getPsiElementClass() {
        return this.getKind().getPsiElementClass();
    }

    @Override
    @Nullable
    public PsiElement locateDefinition(@NotNull Project project2) {
        return OCSymbolBase.doLocateDefinition(this, project2, this.getPsiElementClass());
    }

    @Nullable
    public static <T extends PsiElement> T doLocateDefinition(@NotNull OCSymbol symbol, @NotNull Project project2, @NotNull Class<T> elementClass) {
        PsiFile file2 = symbol.getContainingPsiFile(project2);
        if (file2 == null || !file2.isValid()) {
            return null;
        }
        PsiElement cur = file2.findElementAt(symbol.getOffset());
        if (cur == null) {
            return null;
        }
        cur = PsiTreeUtil.getDeepestLast((PsiElement)cur);
        long symbolComplexOffset = symbol.getComplexOffset();
        do {
            long curComplexOffset;
            if ((curComplexOffset = OCSymbolOffsetUtil.getComplexOffset(cur)) == symbolComplexOffset) {
                T definitionAtPrev;
                T definitionAtCur = OCSymbolBase.findParentDefinition(cur, elementClass, symbolComplexOffset);
                if (definitionAtCur != null) {
                    return definitionAtCur;
                }
                if (symbol.isUnnamed() && (definitionAtPrev = OCSymbolBase.findParentDefinition(PsiTreeUtil.prevLeaf((PsiElement)cur), elementClass, symbolComplexOffset)) != null) {
                    return definitionAtPrev;
                }
                return null;
            }
            if (OCSymbolOffsetUtil.getTextOffset(curComplexOffset) == OCSymbolOffsetUtil.getTextOffset(symbolComplexOffset)) continue;
            return null;
        } while ((cur = PsiTreeUtil.prevLeaf((PsiElement)cur)) != null);
        return null;
    }

    @Nullable
    private static <T extends PsiElement> T findParentDefinition(@Nullable PsiElement cur, @NotNull Class<T> elementClass, long symbolComplexOffset) {
        if (cur == null) {
            return null;
        }
        PsiElement parent = cur;
        do {
            if (!elementClass.isInstance(parent) || OCSymbolOffsetUtil.getVirtualComplexOffset(parent) != symbolComplexOffset) continue;
            return (T)parent;
        } while ((parent = PsiTreeUtil.getParentOfType((PsiElement)parent, elementClass, (boolean)true)) != null);
        return null;
    }

    public String toString() {
        return (Object)((Object)this.getKind()) + "[" + this.getPresentableName() + "]@" + (this.getContainingFile() != null ? this.getContainingFile().getName() + ":" : "") + this.getOffset();
    }

    @Override
    @Nullable
    public VirtualFile getContainingFile() {
        return this.myFile;
    }

    @Override
    public long getComplexOffset() {
        return this.myComplexOffset;
    }

    @Override
    public void setComplexOffset(long complexOffset) {
        this.myComplexOffset = complexOffset;
    }

    public int hashCode() {
        int result2 = this.hashCodeExcludingOffset();
        result2 = 31 * result2 + (int)this.getComplexOffset();
        return result2;
    }
}

