/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.search.usages.OCReferencesSearchParameters;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import org.jetbrains.annotations.NotNull;

public class OCSameSymbolsSearch
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    public boolean execute(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        if (queryParameters instanceof OCReferencesSearchParameters && ((OCReferencesSearchParameters)queryParameters).findDeclarationReferences()) {
            return (Boolean)ReadAction.compute(() -> OCSameSymbolsSearch.doExecute(queryParameters, consumer));
        }
        return true;
    }

    @NotNull
    private static Boolean doExecute(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        PsiElement element = queryParameters.getElementToSearch();
        if (!(element instanceof OCSymbolDeclarator)) {
            return true;
        }
        Object symbol = ((OCSymbolDeclarator)element).getSymbol();
        if (symbol == null) {
            return true;
        }
        Project project2 = element.getProject();
        SearchScope scopeToFindIn = queryParameters.getEffectiveSearchScope();
        symbol.processSameSymbols((Processor<OCSymbol>)((Processor)sameSymbol -> {
            if (sameSymbol != null && sameSymbol != symbol) {
                PsiElement def;
                if (sameSymbol.isSynthetic() || sameSymbol instanceof OCNamespaceSymbol && ((OCNamespaceSymbol)sameSymbol).isSyntheticNamespace()) {
                    return true;
                }
                VirtualFile file2 = sameSymbol.getContainingFile();
                if (file2 != null && scopeToFindIn.contains(file2) && (def = sameSymbol.locateDefinition(project2)) != null && element != def) {
                    PsiReference reference = def.getReference();
                    if (reference != null) {
                        return consumer.process((Object)reference);
                    }
                    OCReferenceElement id = (OCReferenceElement)PsiTreeUtil.findChildOfType((PsiElement)def, OCReferenceElement.class);
                    if (id != null) {
                        return consumer.process((Object)id.getReference());
                    }
                }
            }
            return true;
        }), project2);
        return true;
    }
}

