/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.ide.util.DeleteNameDescriptionLocation;
import com.intellij.ide.util.DeleteTypeDescriptionLocation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.NonCodeSearchDescriptionLocation;
import com.intellij.usageView.UsageViewLongNameLocation;
import com.intellij.usageView.UsageViewNodeTextLocation;
import com.intellij.usageView.UsageViewShortNameLocation;
import com.intellij.usageView.UsageViewTypeLocation;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCForeignSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import org.jetbrains.annotations.NotNull;

public class OCElementDescriptionProvider
implements ElementDescriptionProvider {
    private static final String OPERATOR_NAME_PREFIX = OCTokenTypes.OPERATOR_CPP_KEYWORD.getName();
    private static final String UDL_NAME_PREFIX = OPERATOR_NAME_PREFIX + "\"\"";

    public String getElementDescription(@NotNull PsiElement element, @NotNull ElementDescriptionLocation location) {
        if (!(element instanceof OCSymbolDeclarator) || !element.isValid()) {
            return null;
        }
        Object symbol = ((OCSymbolDeclarator)element).getSymbol();
        if (symbol == null || symbol instanceof OCForeignSymbol) {
            return null;
        }
        OCCompilationContext compilationContext = OCCompilationContext.create(element);
        if (location instanceof UsageViewShortNameLocation || location instanceof UsageViewLongNameLocation || location instanceof DeleteNameDescriptionLocation || location instanceof NonCodeSearchDescriptionLocation) {
            String symbolName = symbol.getName();
            if (location instanceof UsageViewShortNameLocation && symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppOperator()) {
                String prefixToSkip;
                String string = prefixToSkip = ((OCFunctionSymbol)symbol).isUDL() ? UDL_NAME_PREFIX : OPERATOR_NAME_PREFIX;
                assert (StringUtil.startsWith((CharSequence)symbolName, (CharSequence)prefixToSkip));
                return symbolName.substring(prefixToSkip.length()).trim();
            }
            return symbolName;
        }
        if (location instanceof UsageViewTypeLocation) {
            return symbol.getKindLowercase(compilationContext);
        }
        if (location instanceof DeleteTypeDescriptionLocation) {
            String name = symbol.getKindLowercase(compilationContext);
            return ((DeleteTypeDescriptionLocation)location).isPlural() ? StringUtil.pluralize((String)name) : name;
        }
        if (location instanceof UsageViewNodeTextLocation) {
            String result2 = symbol.getNameWithKindLowercase(compilationContext);
            if (symbol instanceof OCMemberSymbol) {
                result2 = result2 + " of " + ((OCMemberSymbol)symbol).getParent().getNameWithKindLowercase(compilationContext);
            } else if (symbol.isPredeclaration()) {
                result2 = "predefinition of " + result2;
            }
            return result2;
        }
        return symbol.getNameWithKindLowercase(compilationContext);
    }
}

