/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.references;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.ui.PlatformColors;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionPriority;
import com.jetbrains.cidr.lang.editor.completion.SymbolLookupBuilderUtil;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCLocalizedString;
import com.jetbrains.cidr.lang.psi.OCStringsFile;
import com.jetbrains.cidr.lang.psi.impl.OCLiteralExpressionImpl;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.resolve.references.OCResourceFilesProvider;
import com.jetbrains.cidr.lang.resolve.references.OCResourceReference;
import com.jetbrains.cidr.lang.resolve.references.PsiCachingReferenceBase;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCStringResourceReference
extends PsiCachingReferenceBase<PsiElement>
implements OCResourceReference {
    public static final String DEFAULT_TABLE = "Localizable";
    private final String myTable;

    public OCStringResourceReference(PsiElement element, @Nullable String table) {
        super(element, false);
        this.myTable = table;
    }

    @Nullable
    public String getTableFileName() {
        return this.myTable != null ? this.myTable + ".strings" : null;
    }

    @NotNull
    public String getCanonicalText() {
        if (this.myElement instanceof OCLiteralExpression) {
            return StringUtil.unquoteString((String)((OCLiteralExpression)this.myElement).getRawLiteralText());
        }
        return StringUtil.unquoteString((String)this.myElement.getText());
    }

    private static int getLocalizationWeight(OCStringsFile file2) {
        String localizationName = StringUtil.toLowerCase((String)file2.getLocalizationName());
        return localizationName.equals("en") || localizationName.equals("english") || localizationName.equals("default") ? 1 : 0;
    }

    @Override
    public OCLocalizedString resolveInner() {
        String key = this.getCanonicalText();
        Ref result2 = Ref.create(null);
        this.processStringFiles((Processor<OCStringsFile>)((Processor)file2 -> {
            OCLocalizedString pair = file2.findStringPair(key);
            if (pair != null && (result2.isNull() || OCStringResourceReference.getLocalizationWeight(file2) > 0)) {
                result2.set((Object)pair);
            }
            return true;
        }));
        return (OCLocalizedString)result2.get();
    }

    public Object @NotNull [] getVariants() {
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @Override
    @NotNull
    public List<LookupElement> getLookupElements(boolean includeQuotes) {
        ArrayList<LookupElement> variants = new ArrayList<LookupElement>();
        HashMap weightsMap = new HashMap();
        HashMap pairsMap = new HashMap();
        this.processStringFiles((Processor<OCStringsFile>)((Processor)file2 -> {
            for (OCLocalizedString pair : file2.getStringPairs()) {
                int weight = OCStringResourceReference.getLocalizationWeight(file2);
                Integer existingWeight = (Integer)weightsMap.get(pair.getKey());
                if (existingWeight != null && existingWeight >= weight) continue;
                weightsMap.put(pair.getKey(), weight);
                pairsMap.put(pair.getKey(), pair);
            }
            return true;
        }));
        for (final OCLocalizedString pair : pairsMap.values()) {
            final String text = includeQuotes ? "@\"" + pair.getKey() + "\"" : pair.getKey();
            LookupElementBuilder builder2 = SymbolLookupBuilderUtil.forSymbol(pair.getSymbol(), text, pair.getProject());
            builder2 = builder2.withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

                public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                    presentation.setItemText(text);
                    presentation.setTailText("=" + pair.getValue(), PlatformColors.BLUE);
                    presentation.setTypeText(((OCStringsFile)pair.getContainingFile()).getLocalizationName(), AllIcons.FileTypes.Properties);
                }
            });
            variants.add(OCCompletionPriority.elementWithPriority((LookupElement)builder2, OCCompletionPriority.HIGHEST_PRIORITY));
        }
        return variants;
    }

    public boolean processStringFiles(Processor<OCStringsFile> processor2) {
        String tableFileName = this.getTableFileName();
        for (Map.Entry<String, VirtualFile> entry : OCResourceFilesProvider.getAccessibleResources(this.myElement).entrySet()) {
            OCStringsFile stringsFile;
            PsiFile psiFile;
            if (tableFileName != null && !tableFileName.equals(entry.getKey()) && !tableFileName.equals(OCResourceFilesProvider.withoutLocalization(entry.getKey())) || !((psiFile = this.myElement.getManager().findFile(entry.getValue())) instanceof OCStringsFile) || processor2.process((Object)(stringsFile = (OCStringsFile)psiFile))) continue;
            return false;
        }
        return true;
    }

    public boolean areAllLanguagesLocalized() {
        return this.getNotLocalizedLanguages().isEmpty();
    }

    public List<String> getNotLocalizedLanguages() {
        HashSet existing = new HashSet();
        HashSet missing = new HashSet();
        String key = this.getCanonicalText();
        this.processStringFiles((Processor<OCStringsFile>)((Processor)file2 -> {
            if (file2.findStringPair(key) == null) {
                missing.add(file2.getLocalizationName());
            } else {
                existing.add(file2.getLocalizationName());
            }
            return true;
        }));
        missing.removeAll(existing);
        if (missing.size() > 3) {
            Iterator itr = missing.iterator();
            return Arrays.asList((String)itr.next(), (String)itr.next(), (String)itr.next());
        }
        return new ArrayList<String>(missing);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public PsiElement getElement() {
        return this.myElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        PsiElement literal = this.getStringLiteral();
        if (literal != null && literal.getTextLength() >= 2) {
            int start = literal.getTextOffset() - this.myElement.getTextOffset();
            return new TextRange(start + 1, start + literal.getTextLength() - 1);
        }
        return new TextRange(0, this.myElement.getTextLength());
    }

    @Nullable
    private PsiElement getStringLiteral() {
        ASTNode node2 = this.myElement.getNode();
        if (this.myElement instanceof OCLiteralExpressionImpl) {
            List<ASTNode> nodes = ((OCLiteralExpressionImpl)this.myElement).findStringLiteralNodes();
            ASTNode aSTNode = node2 = nodes.isEmpty() ? null : nodes.get(0);
        }
        if (node2 != null && node2.getElementType() == OCTokenTypes.STRING_LITERAL && (node2.getStartOffset() > 0 || this.myElement.getContainingFile() instanceof OCStringsFile)) {
            return node2.getPsi();
        }
        return null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (!(element instanceof OCLocalizedString) || !((OCLocalizedString)element).getKey().equals(this.getCanonicalText())) {
            return false;
        }
        String table = this.getTableFileName();
        PsiFile file2 = element.getContainingFile();
        if (!(file2 instanceof OCStringsFile)) {
            return false;
        }
        if (!OCResourceFilesProvider.isAccessible(this.myElement, file2.getVirtualFile())) {
            return false;
        }
        String fileName = file2.getName();
        return table == null || table.equals(fileName);
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        PsiElement literal = this.getStringLiteral();
        if (literal != null && literal.getParent() instanceof OCLiteralExpression) {
            FileSymbolTablesCache.getInstance(this.myElement.getProject()).scheduleReparseFile((OCFile)this.myElement.getContainingFile());
            OCExpression literalExpr = OCElementFactory.expressionFromText("@\"" + newElementName + "\"", this.myElement);
            return OCChangeUtil.replaceHandlingMacros(literal.getParent(), literalExpr);
        }
        assert (false) : this.myElement.getClass();
        return this.myElement;
    }
}

