/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.psi.impl.OCImportModuleStatementImpl;
import com.jetbrains.cidr.lang.psi.impl.OCIncludeDirectiveImpl;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCImportManipulator
extends AbstractElementManipulator<OCIncludeDirectiveImpl> {
    public OCIncludeDirectiveImpl handleContentChange(@NotNull OCIncludeDirectiveImpl element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (element instanceof OCImportModuleStatementImpl) {
            PsiElement newElement = OCElementFactory.topLevelDeclarationFromText("@import " + newContent + ";", element);
            return (OCIncludeDirectiveImpl)OCChangeUtil.replaceHandlingMacros(element, newElement);
        }
        ASTNode oldContentNode = element.getNode().findChildByType((IElementType)OCTokenTypes.HEADER_PATH_LITERAL);
        if (oldContentNode != null) {
            LeafElement newContentNode = ASTFactory.leaf((IElementType)OCTokenTypes.HEADER_PATH_LITERAL, (CharSequence)newContent);
            CodeEditUtil.setNodeGenerated((ASTNode)newContentNode, (boolean)true);
            OCChangeUtil.replaceChild(element.getNode(), oldContentNode, (ASTNode)newContentNode);
        }
        return element;
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull OCIncludeDirectiveImpl element) {
        TextRange range;
        if (OCElementUtil.isPartOfMacroSubstitution(element)) {
            return TextRange.EMPTY_RANGE;
        }
        ASTNode node2 = element.getNode();
        if (element instanceof OCImportModuleStatementImpl) {
            int start;
            ASTNode child = node2.findChildByType((IElementType)OCTokenTypes.IDENTIFIER);
            if (child == null) {
                return TextRange.EMPTY_RANGE.shiftRight(node2.getTextLength());
            }
            int end = start = OCSymbolOffsetUtil.getTextOffsetInTopMacroSubstitution(child.getPsi()) - node2.getStartOffset();
            while (child != null) {
                if (child.getElementType() == OCTokenTypes.IDENTIFIER) {
                    end = OCSymbolOffsetUtil.getTextOffsetInTopMacroSubstitution(child.getPsi()) + child.getTextLength() - node2.getStartOffset();
                }
                child = child.getTreeNext();
            }
            return new TextRange(start, end);
        }
        ASTNode pathLiteral = node2.findChildByType((IElementType)OCTokenTypes.HEADER_PATH_LITERAL);
        if (pathLiteral == null) {
            return TextRange.EMPTY_RANGE.shiftRight(node2.getTextLength());
        }
        if (pathLiteral instanceof ForeignLeafPsiElement) {
            return ((TextRange)element.getContent((boolean)true).second).shiftRight(-node2.getStartOffset());
        }
        int offsetInDirective = pathLiteral.getStartOffset() - node2.getStartOffset();
        String pathContext = pathLiteral.getText();
        OCIncludeSymbol.IncludePath path = OCInclusionContext.extractPath(pathContext, false);
        int delta = pathContext.length() - path.getPath().length();
        switch (delta) {
            case 1: {
                range = new TextRange(1, pathContext.length());
                break;
            }
            case 2: {
                range = new TextRange(1, pathContext.length() - 1);
                break;
            }
            default: {
                range = TextRange.EMPTY_RANGE;
            }
        }
        return range.shiftRight(offsetInDirective);
    }
}

