/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve;

import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.resolve.OCCompilerGeneratedFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbolImpl;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeductionGuideSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDeductionCandidateSymbol
extends OCCompilerGeneratedFunctionSymbol {
    private final Kind myKind;

    @NotNull
    public static OCDeductionCandidateSymbol createCopyDeductionCandidate(@NotNull OCStructSymbol struct) {
        return new OCDeductionCandidateSymbol(struct, struct.getType(), Collections.emptyList(), Collections.singletonList(OCDeductionCandidateSymbol.createParameterSymbol(struct.getType())), Kind.CopyDeductionCandidate);
    }

    @NotNull
    public static OCDeductionCandidateSymbol createDefaultDeductionCandidate(@NotNull OCStructSymbol struct) {
        return new OCDeductionCandidateSymbol(struct, struct.getType(), Collections.emptyList(), Collections.emptyList(), Kind.DefaultDeductionCandidate);
    }

    @NotNull
    public static OCDeductionCandidateSymbol createFromConstructor(@NotNull OCStructSymbol struct, @NotNull OCFunctionSymbol constructor) {
        return new OCDeductionCandidateSymbol(struct, struct.getType(), constructor.getTemplateParameters(), constructor.getParameterSymbols(), Kind.FromConstructor);
    }

    @NotNull
    public static OCDeductionCandidateSymbol createFromDeductionGuide(@NotNull OCStructSymbol struct, @NotNull OCDeductionGuideSymbol guide) {
        return new OCDeductionCandidateSymbol(struct, guide.getGuidedType(), guide.getTemplateParameters(), guide.getParameterSymbols(), Kind.FromDeductionGuide);
    }

    public OCDeductionCandidateSymbol(@NotNull OCDeductionCandidateSymbol origin, @NotNull OCTypeSubstitution substitution2, @Nullable OCSymbolWithQualifiedName parent) {
        super(origin, substitution2, parent);
        this.myKind = origin.myKind;
    }

    private OCDeductionCandidateSymbol(@NotNull OCStructSymbol struct, @NotNull OCType returnType, @NotNull List<OCTypeParameterSymbol> templateParameters, @NotNull List<OCDeclaratorSymbol> parameterSymbols, @NotNull Kind kind) {
        super(struct, struct.getName(), returnType, templateParameters, parameterSymbols, OCSymbolKind.CPP_CTAD_DEDUCTION_CANDIDATE);
        this.myKind = kind;
    }

    private static OCDeclaratorSymbol createParameterSymbol(@NotNull OCType type) {
        return new OCDeclaratorSymbolImpl(null, Long.MAX_VALUE, null, OCQualifiedName.interned("<unnamed>"), Collections.emptyList(), type, OCSymbolKind.PARAMETER, null, Collections.emptyList(), Collections.emptyList(), OCDeclaratorSymbol.Property.IS_SYNTHETIC.ordinal(), 0, null, null);
    }

    public boolean isCopyDeductionCandidate() {
        return this.myKind == Kind.CopyDeductionCandidate;
    }

    public boolean isFromDeductionGuide() {
        return this.myKind == Kind.FromDeductionGuide;
    }

    @Override
    @NotNull
    public List<OCTypeParameterSymbol> getTemplateParameters() {
        if (this.myKind == Kind.FromDeductionGuide) {
            return super.getTemplateParameters();
        }
        return ContainerUtil.concat(((OCStructSymbol)this.getParent()).getTemplateParameters(), (List)super.getTemplateParameters());
    }

    @NotNull
    public List<OCTypeParameterSymbol> getCTADParameters() {
        if (this.myKind == Kind.FromDeductionGuide) {
            return Collections.emptyList();
        }
        return ((OCStructSymbol)this.getParent()).getTemplateParameters();
    }

    @Override
    public boolean isCppConstructor() {
        return true;
    }

    private static enum Kind {
        FromConstructor,
        FromDeductionGuide,
        DefaultDeductionCandidate,
        CopyDeductionCandidate;

    }
}

