/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.util;

import com.intellij.lang.ASTNode;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OCNormalizeUtil {
    private OCNormalizeUtil() {
    }

    @Nullable
    public static OCDeclaration normalizeDeclarator(OCDeclarator declarator) throws IncorrectOperationException {
        OCDeclaration declaration = (OCDeclaration)declarator.getParent();
        ASTNode declarationOrPropertyNode = declaration.getNode();
        int declarationIndex = declaration.getDeclarators().indexOf(declarator);
        if (declarationOrPropertyNode == null || declaration.getDeclarators().size() <= 1) {
            return declaration;
        }
        ASTNode parent = declarationOrPropertyNode.getTreeParent();
        if (parent.getElementType() == OCElementTypes.DECLARATION_STATEMENT || parent.getElementType() == OCElementTypes.PROPERTY) {
            declarationOrPropertyNode = parent;
            parent = declarationOrPropertyNode.getTreeParent();
        }
        ASTNode newDeclarationOrPropertyNode = declarationOrPropertyNode.copyElement();
        OCChangeUtil.addChild(parent, newDeclarationOrPropertyNode, declarationOrPropertyNode.getTreeNext());
        ASTNode newDeclarationNode = newDeclarationOrPropertyNode;
        if (newDeclarationNode.getElementType() != OCElementTypes.DECLARATION) {
            for (ASTNode child : newDeclarationNode.getChildren(null)) {
                if (child.getElementType() != OCElementTypes.DECLARATION) continue;
                newDeclarationNode = child;
                break;
            }
        }
        if (newDeclarationNode.getElementType() != OCElementTypes.DECLARATION) {
            return null;
        }
        OCDeclaration newDeclaration = (OCDeclaration)newDeclarationNode.getPsi(OCDeclaration.class);
        if (newDeclaration == null) {
            return null;
        }
        OCDeclarator newDeclarator = newDeclaration.getDeclarators().get(declarationIndex);
        OCChangeUtil.delete(declarator);
        for (OCDeclarator curDeclarator : newDeclaration.getDeclarators()) {
            if (curDeclarator == newDeclarator) continue;
            OCChangeUtil.delete(curDeclarator);
        }
        CodeEditUtil.markToReformat((ASTNode)newDeclarationOrPropertyNode, (boolean)true);
        OCChangeUtil.markNodeForPPAction(declarationOrPropertyNode, OCChangeUtil.PostponedFormatAction.Format);
        return newDeclaration;
    }

    public static List<OCDeclaration> normalizeDeclaration(OCDeclaration declaration) {
        ArrayList<OCDeclaration> newDeclarations = new ArrayList<OCDeclaration>();
        int declaratorsCnt = declaration.getDeclarators().size();
        for (int i2 = 0; i2 < declaratorsCnt; ++i2) {
            List<OCDeclarator> declarators = declaration.getDeclarators();
            newDeclarations.add(OCNormalizeUtil.normalizeDeclarator(declarators.get(declarators.size() - 1)));
        }
        return newDeclarations;
    }

    public static OCSynthesizePropertiesList normalizeSynthesizeStatement(OCSynthesizeProperty property) {
        OCSynthesizePropertiesList list = (OCSynthesizePropertiesList)property.getParent();
        ASTNode listNode = list.getNode();
        int propertyIndex = list.getProperties().indexOf(property);
        if (listNode == null || list.getProperties().size() <= 1) {
            return list;
        }
        ASTNode parent = listNode.getTreeParent();
        ASTNode newListNode = listNode.copyElement();
        OCChangeUtil.addChild(parent, newListNode, listNode.getTreeNext());
        OCSynthesizePropertiesList newList = (OCSynthesizePropertiesList)newListNode.getPsi();
        if (newList == null) {
            return null;
        }
        OCSynthesizeProperty newProperty = newList.getProperties().get(propertyIndex);
        OCChangeUtil.delete(property);
        for (OCSynthesizeProperty curProperty : newList.getProperties()) {
            if (curProperty == newProperty) continue;
            OCChangeUtil.delete(curProperty);
        }
        CodeEditUtil.markToReformat((ASTNode)newListNode, (boolean)true);
        OCChangeUtil.markNodeForPPAction(newListNode, OCChangeUtil.PostponedFormatAction.Format);
        return newList;
    }
}

