/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiFileProcessor;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCGroupedFileNaming;
import com.jetbrains.cidr.lang.OCGroupedFileNamings;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.refactoring.OCRenameProcessorExtension;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCRenameFileProcessor
extends RenamePsiFileProcessor {
    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        this.gatherRenames(element, newName, allRenames);
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        MultiMap cs = new MultiMap();
        this.findRenameConflicts(element, newName, (MultiMap<PsiElement, Conflict>)cs);
        for (Map.Entry entry : cs.entrySet()) {
            for (Conflict conflict : (Collection)entry.getValue()) {
                conflicts.putValue(entry.getKey(), (Object)conflict.toString());
            }
        }
        super.findExistingNameConflicts(element, newName, conflicts);
    }

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project2, @NotNull PsiElement element, PsiElement nameSuggestionContext, Editor editor) {
        return new RenamePsiFileProcessor.PsiFileRenameDialog(project2, element, nameSuggestionContext, editor){

            protected RenameProcessor createRenameProcessor(@NotNull String newName) {
                return new RenameProcessor(this.getProject(), this.getPsiElement(), newName, this.getRefactoringScope(), this.isSearchInComments(), this.isSearchInNonJavaFiles()){

                    @NotNull
                    protected ConflictsDialog createConflictsDialog(@NotNull MultiMap<PsiElement, String> conflicts, UsageInfo[] usages) {
                        return new ConflictsDialog(this.myProject, conflicts, null, false, false);
                    }
                };
            }
        };
    }

    public void gatherRenames(PsiElement root, String newRootName, Map<PsiElement, String> allRenames) {
        if (!(root instanceof PsiFileSystemItem)) {
            return;
        }
        HashMap<PsiFileSystemItem, String> result2 = new HashMap<PsiFileSystemItem, String>();
        LinkedList<Pair> processQueue = new LinkedList<Pair>();
        processQueue.addLast(Pair.create((Object)((PsiFileSystemItem)root), (Object)newRootName));
        while (!processQueue.isEmpty()) {
            Pair info = (Pair)processQueue.removeFirst();
            PsiFileSystemItem element = (PsiFileSystemItem)info.first;
            String newName = (String)info.second;
            result2.put(element, newName);
            ArrayList<PsiFileSystemItem> unprocessedVariants = new ArrayList<PsiFileSystemItem>();
            unprocessedVariants.add(element);
            OCRenameFileProcessor.iterateVariantsForRename(element, newName, (variant, newVariantName) -> {
                if (result2.put(variant, newVariantName) == null) {
                    unprocessedVariants.add(variant);
                }
            });
            for (PsiFileSystemItem variant2 : unprocessedVariants) {
                this.findExtraVariants(variant2, (String)result2.get(variant2), (version, newVersionName) -> {
                    if (result2.get(version) == null) {
                        processQueue.addLast(Pair.create((Object)version, (Object)newVersionName));
                    }
                });
            }
        }
        allRenames.putAll(result2);
    }

    protected void findExtraVariants(@NotNull PsiFileSystemItem variant, @NotNull String newRootName, @NotNull VariantProcessor localizedProcessor) {
        for (OCRenameProcessorExtension each : OCRenameProcessorExtension.EP.getExtensionList()) {
            each.findExtraVariants(variant, newRootName, localizedProcessor);
        }
    }

    private static void iterateVariantsForRename(PsiFileSystemItem element, String newName, VariantProcessor variantProcessor) {
        if (element instanceof PsiFile) {
            PsiDirectory parent = ((PsiFile)element).getParent();
            OCGroupedFileNaming groupedNaming = OCRenameFileProcessor.getGroupedNaming((PsiElement)element);
            if (parent != null && groupedNaming != null) {
                String newBaseName = FileUtilRt.getNameWithoutExtension((String)groupedNaming.getBaseName(newName));
                String name = element.getName();
                String baseNameExt = groupedNaming.getBaseName(name);
                String baseName = FileUtilRt.getNameWithoutExtension((String)baseNameExt);
                for (PsiElement variant : parent.getChildren()) {
                    OCGroupedFileNaming variantNaming;
                    PsiFile variantFile;
                    if (!(variant instanceof PsiFile) || (variantFile = (PsiFile)variant).equals(element) || (variantNaming = OCRenameFileProcessor.getGroupedNaming((PsiElement)variantFile)) == null || !baseNameExt.equals(variantNaming.getBaseName(variantFile.getName()))) continue;
                    String newVariantName = variantFile.getName().replace(baseName, newBaseName);
                    variantProcessor.processVariant((PsiFileSystemItem)variantFile, newVariantName);
                }
            }
        }
    }

    public void findRenameConflicts(PsiElement element, String newName, MultiMap<PsiElement, Conflict> conflicts) {
        HashMap<PsiElement, String> renames = new HashMap<PsiElement, String>();
        this.gatherRenames(element, newName, renames);
        if (renames.size() < 2) {
            return;
        }
        MultiMap pathsToElements = new MultiMap();
        for (Map.Entry<PsiElement, String> entry : renames.entrySet()) {
            PsiElement e = entry.getKey();
            OCLog.LOG.assertTrue(e instanceof PsiFileSystemItem);
            VirtualFile file2 = ((PsiFileSystemItem)e).getVirtualFile();
            OCLog.LOG.assertTrue(file2 != null);
            String newPath = new File(file2.getParent().getPath(), entry.getValue()).getPath();
            pathsToElements.putValue((Object)newPath, (Object)e);
        }
        if (pathsToElements.size() == renames.size()) {
            return;
        }
        for (Map.Entry<Object, String> entry : pathsToElements.entrySet()) {
            Collection elements = (Collection)((Object)entry.getValue());
            if (elements == null || elements.size() <= 1) continue;
            String newElementName = new File((String)entry.getKey()).getName();
            conflicts.putValue((Object)element, (Object)new Conflict(newElementName, elements));
        }
    }

    public boolean forcesShowPreview() {
        return false;
    }

    @Nullable
    private static OCGroupedFileNaming getGroupedNaming(PsiElement element) {
        if (!(element instanceof PsiFile)) {
            return null;
        }
        return OCGroupedFileNamings.getGroupedFileNaming(((PsiFile)element).getVirtualFile());
    }

    public static class Conflict {
        public final String name;
        public final Collection<PsiElement> elements;

        public Conflict(String name, Collection<PsiElement> elements) {
            this.name = name;
            this.elements = elements;
        }

        private static String quote(String string) {
            return StringUtil.wrapWithDoubleQuote((String)string);
        }

        public String toString() {
            List badElements = ContainerUtil.filter(this.elements, element -> {
                if (!(element instanceof PsiFileSystemItem)) {
                    return false;
                }
                return !((PsiFileSystemItem)element).getName().equals(this.name);
            });
            List oldNames = ContainerUtil.map((Collection)badElements, element -> {
                OCLog.LOG.assertTrue(element instanceof PsiFileSystemItem);
                return Conflict.quote(((PsiFileSystemItem)element).getName());
            });
            return "Trying to rename " + StringUtil.join((Collection)oldNames, (String)", ") + " to existing file name " + Conflict.quote(this.name);
        }
    }

    @FunctionalInterface
    public static interface VariantProcessor {
        public void processVariant(PsiFileSystemItem var1, String var2);
    }
}

