/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.ui.ComboBoxVisibilityPanel;
import com.intellij.ui.SimpleListCellRenderer;
import com.jetbrains.cidr.lang.actions.newFile.OCNewCategoryAction;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.refactoring.changeSignature.ClassSymbolOption;
import com.jetbrains.cidr.lang.refactoring.changeSignature.NewCategoryOption;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCGeneratedInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCTargetSymbolPanelOption;
import com.jetbrains.cidr.lang.refactoring.changeSignature.SeparatorOption;
import com.jetbrains.cidr.lang.refactoring.changeSignature.SymbolOption;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTargetSymbolPanel
extends ComboBoxVisibilityPanel<Object> {
    public static final Key<TargetSymbolsMode> VISIBILITY_KEY = Key.create((String)"VISIBILITY_KEY");
    private static final SeparatorOption SEPARATOR = new SeparatorOption();

    public OCTargetSymbolPanel() {
        super("Targets:", (Object[])new OCTargetSymbolPanelOption[0]);
    }

    protected ListCellRenderer<?> getRenderer() {
        final JSeparator separator = new JSeparator();
        return new SimpleListCellRenderer<OCTargetSymbolPanelOption>(){

            public Component getListCellRendererComponent(JList<? extends OCTargetSymbolPanelOption> list, OCTargetSymbolPanelOption value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value.isSeparator()) {
                    return separator;
                }
                return super.getListCellRendererComponent(list, (Object)value, index, isSelected, cellHasFocus);
            }

            public void customize(@NotNull JList<? extends OCTargetSymbolPanelOption> list, OCTargetSymbolPanelOption value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getText());
                this.setIcon(value.getIcon());
            }
        };
    }

    public void fillData(final OCGeneratedInfo info) {
        Project project2;
        OCClassSymbol parent = (OCClassSymbol)info.getMethodParent();
        OCInterfaceSymbol interfaceSymbol = parent.getInterface(project2 = info.getProject());
        if (OCSearchScope.isInProjectSources(interfaceSymbol, project2)) {
            String extensions = "  [" + OCTargetSymbolPanel.getExtension(interfaceSymbol, "h") + ", " + OCTargetSymbolPanel.getExtension(parent.getImplementation(project2), "m") + "]";
            this.addOption(new ClassSymbolOption(parent, TargetSymbolsMode.INTERFACE, extensions, project2));
        }
        if (parent instanceof OCImplementationSymbol && OCSearchScope.isInProjectSources(parent, project2)) {
            String extension = OCTargetSymbolPanel.getExtension(parent, "m");
            this.addOption(new ClassSymbolOption(parent, TargetSymbolsMode.IMPLEMENTATION, "  [" + (String)extension + "]", project2));
            this.addOption(new ClassSymbolOption(parent, TargetSymbolsMode.PRIVATE_CATEGORY, " + ()  [" + (String)extension + "]", project2));
        }
        if (this.myComboBox.getItemCount() > 0 && (info.getAuxParents().size() > 0 || info.isAllowChangeCategories())) {
            this.addOption(SEPARATOR);
        }
        for (OCSymbol oCSymbol : info.getAuxParents()) {
            if (!OCSearchScope.isInProjectSources(oCSymbol, project2)) continue;
            this.addOption(new SymbolOption(oCSymbol, project2));
        }
        if (info.isAllowChangeCategories()) {
            OCType type = parent.getType().resolve(OCResolveContext.forSymbol(parent, project2), true);
            if (type instanceof OCObjectType) {
                for (OCInterfaceSymbol category : ((OCObjectType)type).getCategoryInterfaces()) {
                    if (!OCSearchScope.isInProjectSources(category, project2) || "".equals(category.getCategoryName())) continue;
                    this.addOption(new SymbolOption(category, project2));
                }
            }
            if (this.myComboBox.getItemCount() > 0 && !SEPARATOR.equals(this.myComboBox.getItemAt(this.myComboBox.getItemCount() - 1))) {
                this.addOption(SEPARATOR);
            }
            this.addOption(new NewCategoryOption("New category of " + parent.getName() + "..."));
        }
        this.myComboBox.setSelectedIndex(this.getFirstSelectionIndex(parent));
        this.addListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Object item = OCTargetSymbolPanel.this.myComboBox.getSelectedItem();
                if (!(item instanceof OCTargetSymbolPanelOption)) {
                    return;
                }
                OCTargetSymbolPanelOption option = (OCTargetSymbolPanelOption)item;
                if (option.isNewCategory()) {
                    OCTargetSymbolPanel.this.createNewCategory(info);
                } else if (option.getTargetSymbolsMode() != null) {
                    info.setTargetSymbolsMode(option.getTargetSymbolsMode());
                    project2.putUserData(VISIBILITY_KEY, (Object)option.getTargetSymbolsMode());
                } else if (option.getSymbol() instanceof OCClassSymbol) {
                    info.setMethodParent(option.getSymbol());
                    info.setTargetSymbolsMode(TargetSymbolsMode.INTERFACE);
                }
            }
        });
        Object item = this.myComboBox.getSelectedItem();
        if (item instanceof OCTargetSymbolPanelOption) {
            OCTargetSymbolPanelOption oCTargetSymbolPanelOption = (OCTargetSymbolPanelOption)item;
            if (oCTargetSymbolPanelOption.getTargetSymbolsMode() != null) {
                info.setTargetSymbolsMode(oCTargetSymbolPanelOption.getTargetSymbolsMode());
            } else if (oCTargetSymbolPanelOption.getSymbol() != null) {
                info.setMethodParent(oCTargetSymbolPanelOption.getSymbol());
                info.setTargetSymbolsMode(TargetSymbolsMode.INTERFACE);
            }
        }
    }

    private int getFirstSelectionIndex(OCClassSymbol parent) {
        int selectionIndex = 0;
        for (int i2 = 0; i2 < this.myComboBox.getItemCount(); ++i2) {
            Object item = this.myComboBox.getItemAt(i2);
            if (!(item instanceof OCTargetSymbolPanelOption) || ((OCTargetSymbolPanelOption)item).getTargetSymbolsMode() != TargetSymbolsMode.IMPLEMENTATION) continue;
            selectionIndex = i2;
            break;
        }
        return selectionIndex;
    }

    public boolean isOnlyNewCategoryAllowed() {
        return this.myComboBox.getItemCount() == 1 && this.myComboBox.getItemAt(0).toString().startsWith("New category");
    }

    public boolean createNewCategory(OCGeneratedInfo info) {
        OCClassSymbol category;
        final OCClassSymbol parent = (OCClassSymbol)info.getMethodParent();
        OCFile file2 = OCSearchScope.isInProjectSources(parent, info.getProject()) ? parent.getContainingOCFile(info.getProject()) : (OCFile)info.getMethodReference().getContainingFile();
        if (file2 == null) {
            return false;
        }
        OCNewCategoryAction action = new OCNewCategoryAction(){

            @Override
            protected OCClassSymbol getBaseClass() {
                return parent;
            }
        };
        PsiFile[] elements = action.performAction(info.getProject(), file2.getParent(), file2, null);
        if (!this.isOnlyNewCategoryAllowed()) {
            this.myComboBox.setSelectedIndex(this.getFirstSelectionIndex(parent));
        }
        if (elements != null && elements.length > 0 && elements[0] instanceof OCFile && (category = OCCodeInsightUtil.getClassInFile((OCFile)elements[0])) != null) {
            this.addOption(this.myComboBox.getItemCount() == 1 ? 0 : this.myComboBox.getItemCount() - 2, new SymbolOption(category, info.getProject()), category.getPresentableName(), true);
            info.setMethodParent(category);
            info.setTargetSymbolsMode(TargetSymbolsMode.INTERFACE);
            return true;
        }
        return false;
    }

    private static String getExtension(@Nullable OCClassSymbol symbol, String defaultExtension) {
        VirtualFile file2;
        VirtualFile virtualFile = file2 = symbol != null ? symbol.getContainingFile() : null;
        if (file2 == null || defaultExtension.equals("h") && !OCFileImpl.isHeaderFile(file2.getName()) || defaultExtension.equals("m") && !OCFileImpl.isSourceCodeFile(file2.getName())) {
            return "." + defaultExtension;
        }
        return "." + FileUtilRt.getExtension((String)file2.getName());
    }

    public static enum TargetSymbolsMode {
        INTERFACE,
        PRIVATE_CATEGORY,
        IMPLEMENTATION;

    }
}

