/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureUsageProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.rename.ResolveSnapshotProvider;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCMethodDescriptor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCBlockDefinitionUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCFunctionDefinitionUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCGeneratedCallUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCGeneratedMethodUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCMethodCallUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCMethodDefinitionUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCParameterUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCSelectorExpressionUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCSelfSuperUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCUsageInfo;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.resolve.OCSelectorAdHocResolver;
import com.jetbrains.cidr.lang.search.OCMemberInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCChangeSignatureUsageProcessor
implements ChangeSignatureUsageProcessor {
    protected static final Logger LOG = Logger.getInstance(OCChangeSignatureUsageProcessor.class);

    public UsageInfo[] findUsages(ChangeInfo info) {
        if (!(info instanceof OCChangeInfo)) {
            return UsageInfo.EMPTY_ARRAY;
        }
        return OCChangeSignatureUsageProcessor.findUsages((OCChangeInfo)info, false);
    }

    private static UsageInfo[] findUsages(@NotNull OCChangeInfo info, boolean onlyCalls) {
        OCCallable method = info.getMethod();
        if (!method.isValid()) {
            return UsageInfo.EMPTY_ARRAY;
        }
        HashSet<UsageInfo> result2 = new HashSet<UsageInfo>();
        HashSet<OCCallable> visited = new HashSet<OCCallable>();
        if (info.getGenerated().getMethodReference() != null) {
            result2.add(new OCGeneratedMethodUsage(info.getGenerated().getMethodReference()));
            if (info.getGenerated().getCallString() != null) {
                result2.add(new OCGeneratedCallUsage(info.getGenerated().getMethodReference()));
            }
        }
        OCChangeSignatureUsageProcessor.findAllMethodUsages(info, method, onlyCalls, result2, visited, false);
        for (final Pair<Integer, Runnable> pair : info.getGenerated().getCallbacks()) {
            result2.add(new OCUsageInfo<PsiElement>(info.getContext()){

                @Override
                public boolean processUsage(@NotNull OCChangeInfo changeInfo, @NotNull PsiElement element, @NotNull Project project2) {
                    ((Runnable)pair.getSecond()).run();
                    return true;
                }

                @Override
                public int getUsageRank() {
                    return (Integer)pair.getFirst();
                }

                public int hashCode() {
                    return 0;
                }

                public boolean equals(Object o) {
                    return this == o;
                }
            });
        }
        new ArrayList<UsageInfo>(result2).sort((o1, o2) -> o1.compareToByStartOffset(o2));
        return result2.toArray(UsageInfo.EMPTY_ARRAY);
    }

    private static void findAllMethodUsages(@NotNull OCChangeInfo info, @NotNull OCCallable method, boolean onlyCalls, @NotNull Set<UsageInfo> result2, @NotNull Set<OCCallable> visited, boolean isInherited) {
        if (!visited.add(method)) {
            return;
        }
        OCChangeSignatureUsageProcessor.findOneMethodUsages(info, method, onlyCalls, result2, isInherited);
        if (method instanceof OCBlockExpression || !info.isChangeUsages()) {
            return;
        }
        OCSearchUtil.processMembersHierarchyPsi((OCSymbolWithParent)method.getSymbol(), new OCCommonProcessors.TypeFilteredProcessor(element -> {
            OCSymbol rootSymbol = info.getMethod().getSymbol();
            OCSymbol symbol = element.getSymbol();
            OCResolveContext context2 = OCResolveContext.forPsi(method);
            boolean curIsInherited = rootSymbol instanceof OCFunctionSymbol && symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)rootSymbol).getResolvedOwner(context2) != ((OCFunctionSymbol)symbol).getResolvedOwner(context2);
            OCChangeSignatureUsageProcessor.findAllMethodUsages(info, element, onlyCalls, result2, visited, curIsInherited);
            return true;
        }, OCCallable.class), info.isChangeAncestors(), true, method.getProject());
    }

    private static void findOneMethodUsages(@NotNull OCChangeInfo info, @NotNull OCCallable method, boolean onlyCalls, @NotNull Set<UsageInfo> result2, boolean isInherited) {
        List<PsiNamedElement> parameters;
        if (info.isChangeUsages()) {
            OCSearchUtil.findOneMethodUsages(method, result2);
            String oldName = info.getMethod().getName();
            if (oldName != null && !oldName.isEmpty()) {
                TextOccurrencesUtil.findNonCodeUsages((PsiElement)method, (SearchScope)GlobalSearchScope.projectScope((Project)method.getProject()), (String)oldName, (boolean)true, (boolean)true, (String)info.getNewName(), result2);
            }
        }
        if (onlyCalls) {
            return;
        }
        if (info.getGenerated().getMethodReference() == null) {
            if (method instanceof OCFunctionDeclaration) {
                result2.add(new OCFunctionDefinitionUsage((OCFunctionDeclaration)method, isInherited, method == info.getMethod() || isInherited));
            } else if (method instanceof OCBlockExpression) {
                result2.add(new OCBlockDefinitionUsage((OCBlockExpression)method));
            } else if (method instanceof OCMethod) {
                result2.add(new OCMethodDefinitionUsage((OCMethod)method, isInherited));
            }
        }
        if ((parameters = method.getParameters()) == null) {
            return;
        }
        for (OCParameterInfo newParam : info.getNewParameters()) {
            PsiNamedElement oldParam;
            if (newParam.getUsages() != null) {
                for (PsiReference usage : newParam.getUsages()) {
                    result2.add(new OCParameterUsage(usage, newParam, method, isInherited));
                }
            }
            if (newParam.getOldIndex() < 0 || newParam.getOldIndex() >= parameters.size() || Objects.equals((oldParam = parameters.get(newParam.getOldIndex())).getName(), newParam.getName())) continue;
            for (PsiReference ref : ReferencesSearch.search((PsiElement)oldParam, (SearchScope)oldParam.getUseScope())) {
                if (newParam.getName().isEmpty()) {
                    result2.add((UsageInfo)new UnresolvableCollisionUsageInfo(ref.getElement(), (PsiElement)oldParam){

                        public String getDescription() {
                            return OCBundle.message("changeSignature.usages.cantBeUnnamed", oldParam.getName());
                        }
                    });
                    continue;
                }
                result2.add(new OCParameterUsage(ref, newParam, method, isInherited));
            }
        }
        Set newIndices = ContainerUtil.map2Set((Object[])info.getNewParameters(), info1 -> info1.getOldIndex());
        for (int i2 = 0; i2 < parameters.size(); ++i2) {
            if (newIndices.contains(i2)) continue;
            final PsiNamedElement oldParam = parameters.get(i2);
            for (PsiReference ref : ReferencesSearch.search((PsiElement)oldParam, (SearchScope)oldParam.getUseScope())) {
                result2.add((UsageInfo)new UnresolvableCollisionUsageInfo(ref.getElement(), (PsiElement)oldParam){

                    public String getDescription() {
                        return OCBundle.message("changeSignature.usages.cantBeRemoved", oldParam.getName());
                    }
                });
            }
        }
        for (OCReferenceExpression expr : info.getOldMethodDescriptor().getSelfReferences()) {
            if (!expr.isValid()) continue;
            result2.add(new OCSelfSuperUsage(expr));
        }
    }

    public static boolean canProceedWithConflict(String conflict) {
        return !conflict.startsWith(OCChangeSignatureUsageProcessor.getBlockConflict());
    }

    public MultiMap<PsiElement, String> findConflicts(ChangeInfo info, Ref<UsageInfo[]> refUsages) {
        if (!(info instanceof OCChangeInfo)) {
            return MultiMap.empty();
        }
        MultiMap result2 = new MultiMap();
        PsiElement method = info.getMethod();
        OCChangeInfo changeInfo = (OCChangeInfo)info;
        String fullNewName = (Object)((Object)changeInfo.getNewCallableKind()) + " '" + changeInfo.getNewName() + "'";
        if (!changeInfo.willBeMethod()) {
            for (UsageInfo usage : (UsageInfo[])refUsages.get()) {
                PsiElement psiElement = usage.getElement();
                if (!(psiElement instanceof OCSelectorExpression)) continue;
                result2.putValue((Object)usage.getElement(), (Object)OCBundle.message("changeSignature.usages.cantConvertSelectorToFuncBlock", new Object[0]));
            }
            UsageInfo[] usages = OCChangeSignatureUsageProcessor.findUsages((OCChangeInfo)info, true);
            if (changeInfo.willBeBlock() && !(changeInfo.getMethod() instanceof OCBlockExpression) && changeInfo.getGenerated().getMethodReference() == null) {
                for (UsageInfo usageInfo : (UsageInfo[])refUsages.get()) {
                    PsiElement element = usageInfo.getElement();
                    if (element == null || OCLanguageUtils.getSlowLanguage().equals(element.getLanguage())) continue;
                    result2.putValue((Object)usageInfo.getElement(), (Object)OCBundle.message("changeSignature.usages.cantConvertLanguage", element.getLanguage().getDisplayName()));
                }
                if (usages.length == 0) {
                    result2.putValue((Object)method, (Object)(OCChangeSignatureUsageProcessor.getBlockConflict() + " " + OCBundle.message("changeSignature.usages.noUsagesFound", new Object[0])));
                } else if (usages.length > 1) {
                    result2.putValue((Object)method, (Object)(OCChangeSignatureUsageProcessor.getBlockConflict() + " " + OCBundle.message("changeSignature.usages.moreThan1Found", new Object[0])));
                } else if (PsiTreeUtil.isAncestor((PsiElement)changeInfo.getMethod(), (PsiElement)usages[0].getElement(), (boolean)true)) {
                    result2.putValue((Object)method, (Object)(OCChangeSignatureUsageProcessor.getBlockConflict() + " " + OCBundle.message("changeSignature.usages.usageInsideFunction", new Object[0])));
                }
            }
        }
        Project project2 = method.getProject();
        OCResolveContext context2 = OCResolveContext.forPsi(method);
        if (changeInfo.willBeFunction()) {
            OCQualifiedName parentName;
            OCSymbolWithQualifiedName originalSymbol;
            OCSymbolWithQualifiedName oCSymbolWithQualifiedName = originalSymbol = method instanceof OCFunctionDeclaration ? (OCSymbolWithQualifiedName)((OCFunctionDeclaration)method).getSymbol() : null;
            if (originalSymbol != null) {
                OCQualifiedName oCQualifiedName = originalSymbol.getResolvedQualifiedName(context2);
                OCQualifiedName qualifier = originalSymbol.getQualifiedName().getQualifier();
                parentName = oCQualifiedName != null ? oCQualifiedName.getQualifier() : (qualifier != null ? OCQualifiedName.GLOBAL.append(qualifier) : OCQualifiedName.GLOBAL);
            } else {
                parentName = OCQualifiedName.GLOBAL;
            }
            List list = ContainerUtil.map((Object[])changeInfo.getNewParameters(), info1 -> {
                OCType result1 = info1.getType();
                return result1 != null ? result1.resolve(changeInfo.getContext()) : OCUnknownType.INSTANCE;
            });
            OCFunctionType functionType = new OCFunctionType(OCVoidType.instance(), list);
            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project2, (Processor<? super OCSymbol>)((Processor)symbol -> {
                boolean conflict = false;
                if (symbol instanceof OCSymbolWithQualifiedName && (!symbol.isSameSymbol(originalSymbol, project2) || !method.isPhysical()) && OCResolveUtil.isDuplicate(OCSymbolKind.FUNCTION_DECLARATION, symbol.getKind())) {
                    OCQualifiedName name = ((OCSymbolWithQualifiedName)symbol).getResolvedQualifiedName(context2);
                    if (name != null && Comparing.equal((Object)parentName, (Object)name.getQualifier())) {
                        if (symbol instanceof OCFunctionSymbol && (((OCFile)method.getContainingFile()).isCpp() || symbol.getAttributes().contains("overloadable"))) {
                            OCResolveContext resolveContext = OCResolveContext.forPsi(method);
                            OCType type = symbol.getResolvedType(resolveContext);
                            OCTypeEqualityVisitor visitor = new OCTypeEqualityVisitor(type, false, resolveContext);
                            if (type instanceof OCFunctionType && visitor.isFunctionSignatureEqual(functionType)) {
                                conflict = true;
                            }
                        } else {
                            conflict = true;
                        }
                    }
                    if (conflict) {
                        String kind = symbol.getKindLowercase(OCCompilationContext.create(symbol, project2));
                        OCQualifiedName symbolName = ((OCSymbolWithQualifiedName)symbol).getResolvedQualifiedName(context2);
                        if (symbolName != null) {
                            String conflictWith = kind + " " + symbolName.dropSuperQualifier().toString() + (symbol instanceof OCFunctionSymbol ? ((OCFunctionSymbol)symbol).getParamsSignatureWithoutNames() : "");
                            result2.putValue((Object)method, (Object)OCBundle.message("changeSignature.usages.willConflictWith", fullNewName, conflictWith));
                        }
                    }
                }
                return true;
            }), info.getNewName());
            if (changeInfo.isParameterSetOrOrderChanged()) {
                boolean hasInitializers = false;
                for (OCParameterInfo oCParameterInfo : changeInfo.getNewParameters()) {
                    if (oCParameterInfo.getInitializer() != null) {
                        hasInitializers = true;
                        continue;
                    }
                    if (!hasInitializers) continue;
                    result2.putValue((Object)method, (Object)("Missing default value for parameter \"" + oCParameterInfo.getName() + "\""));
                }
                for (UsageInfo usageInfo : (UsageInfo[])refUsages.get()) {
                    List<OCDeclarator> parameters;
                    if (!(usageInfo instanceof OCFunctionDefinitionUsage) || ((OCFunctionDefinitionUsage)usageInfo).isAddInitializers()) continue;
                    OCFunctionDeclaration element = (OCFunctionDeclaration)usageInfo.getElement();
                    List<OCDeclarator> list2 = parameters = element != null ? element.getParameters() : null;
                    if (parameters == null || !ContainerUtil.exists(parameters, p -> p.getInitializer() != null)) continue;
                    result2.putValue((Object)element, (Object)"Default values for another function declaration will be removed");
                }
            }
        } else if (changeInfo.willBeMethod()) {
            OCClassSymbol oCClassSymbol;
            OCClassDeclaration parentClass;
            UsageInfo[] usages = (UsageInfo[])refUsages.get();
            int numOfFunctions = 0;
            for (UsageInfo usageInfo : usages) {
                if (!(usageInfo.getElement() instanceof OCFunctionDefinition)) continue;
                ++numOfFunctions;
            }
            if (numOfFunctions > 1) {
                for (UsageInfo usageInfo : usages) {
                    if (!(usageInfo.getElement() instanceof OCFunctionDefinition)) continue;
                    result2.putValue((Object)usageInfo.getElement(), (Object)OCBundle.message("changeSignature.usages.functionHasSeveralDefinitions", changeInfo.getNewName()));
                }
            }
            if ((parentClass = OCElementUtil.resolveClassDeclaration(oCClassSymbol = (OCClassSymbol)changeInfo.getGenerated().getMethodParent(), project2)) == null) {
                parentClass = changeInfo.getNewContainerClass();
            }
            if (parentClass != null && (changeInfo.isNameChanged() || oCClassSymbol != null)) {
                OCMemberInheritorsSearch.SearchParameters<OCMethodSymbol> parameters = OCMemberInheritorsSearch.getParameters(changeInfo.getNewName(), parentClass.getSymbol(), project2, OCMethodSymbol.class, changeInfo.getMethod() instanceof OCMethod && ((OCMethod)changeInfo.getMethod()).isInstanceMethod() ? OCObjectTypeContext.StaticMode.INSTANCE : OCObjectTypeContext.StaticMode.STATIC);
                parameters.setIncludeSelfImplementation(true);
                parameters.setAncestors(true);
                OCMemberInheritorsSearch.search(parameters).forEach(methodSymbol -> {
                    result2.putValue((Object)method, (Object)OCBundle.message("changeSignature.usages.willConflictWithMethod", fullNewName, methodSymbol.getParent().getNameWithKindLowercase(context2)));
                    return true;
                });
            }
        }
        OCBlockStatement body = ((OCCallable)info.getMethod()).getBody();
        HashSet<String> set = new HashSet<String>();
        for (ParameterInfo parameterInfo : info.getNewParameters()) {
            if (parameterInfo.getName().isEmpty() || set.add(parameterInfo.getName())) continue;
            result2.putValue((Object)method, (Object)OCBundle.message("changeSignature.usages.atLeasTwoParams", parameterInfo.getName()));
        }
        if (body != null) {
            for (ParameterInfo parameterInfo : info.getNewParameters()) {
                OCResolveUtil.processLocalSymbols(parameterInfo.getName(), body.getClosingBrace(), (Processor<OCSymbol>)((Processor)symbol -> {
                    if (symbol.getKind() == OCSymbolKind.LOCAL_VARIABLE && Comparing.equal((Object)symbol.getContainingFile(), (Object)body.getContainingFile().getVirtualFile())) {
                        result2.putValue((Object)method, (Object)OCBundle.message("changeSignature.usages.conflictsWithNewParameter", symbol.getNameWithKindUppercase(context2)));
                    }
                    return true;
                }), false);
            }
        }
        for (UsageInfo usageInfo : (UsageInfo[])refUsages.get()) {
            PsiElement element;
            if (usageInfo instanceof OCSelectorExpressionUsage) {
                PsiElement element2 = usageInfo.getElement();
                if (!(element2 instanceof OCSelectorExpression) || OCSelectorAdHocResolver.getActionTargetContext((OCExpression)element2) != null) continue;
                result2.putValue((Object)element2, (Object)OCBundle.message("changeSignature.usages.unrelatedSelector", new Object[0]));
                continue;
            }
            if (!(usageInfo instanceof OCMethodCallUsage) || !((element = usageInfo.getElement()) instanceof OCSendMessageExpression) || ((OCSendMessageExpression)element).getProbableResponders().getKnownResponder() != null) continue;
            result2.putValue((Object)element, (Object)OCBundle.message("changeSignature.usages.unrelatedSelector", new Object[0]));
        }
        return result2;
    }

    public boolean processUsage(ChangeInfo changeInfo, UsageInfo usageInfo, boolean beforeMethodChange, UsageInfo[] usages) {
        if (!(usageInfo instanceof OCUsageInfo)) {
            return false;
        }
        if (beforeMethodChange) {
            return true;
        }
        Project project2 = changeInfo.getMethod().getProject();
        PsiElement element = usageInfo.getElement();
        return ((OCUsageInfo)usageInfo).processUsage((OCChangeInfo)changeInfo, element, project2);
    }

    public static void processParameters(OCChangeInfo changeInfo, OCCallable function, OCParameterList parameters, Project project2, boolean isInherited) {
        int paramIndex = 0;
        if (parameters != null) {
            OCParameterInfo[] newParameters = changeInfo.getNewParameters();
            for (OCParameterDeclaration parameter : parameters.getParameterDeclarations()) {
                OCTypeElement typeElement = parameter.getTypeElement();
                if (paramIndex >= newParameters.length) {
                    if (paramIndex == 0 && newParameters.length == 0 && typeElement != null && typeElement.getType().isVoid()) break;
                    LOG.error("Invalid parameter is involved into rename procedure!");
                    break;
                }
                OCDeclarator declarator = parameter.getDeclarator();
                if (declarator != null) {
                    String declarationText;
                    OCParameterDeclaration parameterDeclaration;
                    OCSymbol symbol;
                    String oldTypeText;
                    PsiElement identifier = declarator.getNameIdentifier();
                    OCParameterInfo parameterInfo = newParameters[paramIndex];
                    if (typeElement != null && parameterInfo.isTypeChanged(oldTypeText = declarator.getType().getBestNameInContext(declarator, OCElementUtil.getTypeTextWithModifiers(parameter))) && (symbol = declarator.getSymbol()) != null) {
                        new OCChangeTypeIntentionAction(symbol, parameterInfo.getType(), OCCompilationContext.create(declarator)).invoke(project2, null, declarator.getContainingFile());
                    }
                    String newName = changeInfo.getNewParameterName(isInherited, function, parameterInfo);
                    boolean newNameEmpty = OCCallableUtil.isParameterNameEmpty(newName);
                    OCExpression initializer = parameterInfo.getInitializer();
                    if (identifier != null) {
                        if (newNameEmpty) {
                            OCChangeUtil.delete(identifier);
                        } else {
                            OCElementUtil.replaceWithIdentifier(identifier, newName, identifier);
                        }
                    } else if (!newNameEmpty && (parameterDeclaration = OCElementFactory.paramDeclarationFromText(declarationText = OCElementFactory.declarationText(Collections.emptyList(), newName, parameterInfo.getType(), initializer != null ? OCElementUtil.getTextWithMacros(initializer) : null, function, null, false), function)).getDeclarator() != null) {
                        OCChangeUtil.replaceHandlingMacros(declarator, parameterDeclaration.getDeclarator());
                    }
                    if (initializer != null && declarator.isValid() && declarator.getInitializer() != null) {
                        OCChangeUtil.replaceHandlingMacros(declarator.getInitializer(), initializer);
                    }
                }
                ++paramIndex;
            }
        }
    }

    public boolean setupDefaultValues(ChangeInfo changeInfo, Ref<UsageInfo[]> refUsages, Project project2) {
        return true;
    }

    public static void changeConstructorOrMethodCall(@Nullable OCElement callExpression, OCChangeInfo changeInfo) {
        PsiElement name = null;
        OCArgumentList oldArguments = null;
        if (callExpression instanceof OCCppNewExpression) {
            oldArguments = ((OCCppNewExpression)callExpression).getArgumentList();
        } else if (callExpression instanceof OCDeclarator) {
            oldArguments = (OCArgumentList)PsiTreeUtil.getChildOfType((PsiElement)callExpression, OCArgumentList.class);
            if (oldArguments == null) {
                OCCallExpression emptyCall = OCElementFactory.callExpression(changeInfo.getNewName(), Collections.emptyList(), changeInfo.getContext());
                oldArguments = (OCArgumentList)callExpression.add(emptyCall.getArgumentList());
            }
        } else if (callExpression instanceof OCConstructorFieldInitializer) {
            oldArguments = ((OCConstructorFieldInitializer)callExpression).getArgumentList();
        } else if (callExpression instanceof OCCallExpression) {
            oldArguments = ((OCCallExpression)callExpression).getArgumentList();
            OCExpression function = ((OCCallExpression)callExpression).getFunctionReferenceExpression();
            if (function instanceof OCReferenceExpression) {
                OCReferenceElement referenceElement = ((OCReferenceExpression)function).getReferenceElement();
                name = referenceElement != null ? referenceElement.getNameIdentifier() : null;
            } else if (function instanceof OCQualifiedExpression) {
                name = ((OCQualifiedExpression)function).getNameIdentifier();
            }
        }
        List<String> paramStubs = OCChangeSignatureUsageProcessor.getParamStubs(changeInfo.getNewParameters(), false, false, callExpression);
        OCCallExpression stubCall = OCElementFactory.callExpression(changeInfo.getNewName(), paramStubs, changeInfo.getContext());
        if (oldArguments != null) {
            OCChangeSignatureUsageProcessor.restoreOldArguments(changeInfo, oldArguments.getArguments(), stubCall);
            oldArguments = (OCArgumentList)OCChangeUtil.replaceHandlingMacros(oldArguments, stubCall.getArgumentList());
            OCImportSymbolFix.fixAllSymbolsRecursively(oldArguments);
        } else if (callExpression instanceof OCCppNewExpression) {
            oldArguments = OCChangeUtil.add(callExpression, stubCall.getArgumentList());
            OCImportSymbolFix.fixAllSymbolsRecursively(oldArguments);
        }
        if (name != null && changeInfo.isNameChanged()) {
            OCElementUtil.replaceWithIdentifier(name, changeInfo.getNewName(), stubCall);
        }
    }

    private static void restoreOldArguments(OCChangeInfo changeInfo, List<OCExpression> oldArguments, OCCallExpression callExpression) {
        int paramIndex = 0;
        for (OCExpression argument : callExpression.getArguments()) {
            OCParameterInfo parameterInfo = changeInfo.getNewParameters()[paramIndex++];
            if (OCChangeSignatureUsageProcessor.isNewParameter(parameterInfo, oldArguments)) continue;
            if (parameterInfo.getOldIndex() < oldArguments.size()) {
                OCExpression oldArgument = oldArguments.get(parameterInfo.getOldIndex());
                OCChangeUtil.replaceCallArgument(argument, oldArgument);
                continue;
            }
            if (parameterInfo.getInitializer() == null) continue;
            OCChangeUtil.delete(argument);
        }
    }

    @Nullable
    public static OCCallable generateMethodDefinition(@NotNull OCChangeInfo changeInfo, @NotNull OCCallable oldMethod, boolean needBody, boolean needComments, boolean isInherited, boolean addInitializers) {
        String newSignature;
        OCCallable<OCMethodSymbol> result2 = null;
        OCBlockStatement body = oldMethod.getBody();
        PsiFile context2 = oldMethod.getContainingFile();
        String string = newSignature = isInherited ? changeInfo.getNewInheritedSignature(oldMethod, addInitializers) : changeInfo.getNewSignature(addInitializers);
        if (changeInfo.willBeMethod()) {
            result2 = OCElementFactory.methodFromSignature(newSignature, (PsiElement)context2, needBody && (body != null || oldMethod instanceof OCFunctionDeclaration), false);
        } else if (changeInfo.willBeFunction()) {
            OCMethodDescriptor methodDescriptor = changeInfo.getOldMethodDescriptor();
            OCDeclaration declaration = methodDescriptor.isConstructor() ? OCElementFactory.constructorFromText(newSignature + (needBody && body != null ? "{\n}" : ""), (PsiElement)context2) : OCElementFactory.declarationFromText(newSignature + (needBody && body != null ? "{\n}" : ""), (PsiElement)context2);
            OCLog.LOG.assertTrue(declaration instanceof OCCallable, (Object)declaration.getTextWithMacros());
            result2 = (OCCallable)((Object)declaration);
        } else if (changeInfo.willBeBlock()) {
            result2 = body != null ? (OCBlockExpression)OCElementFactory.expressionFromText(newSignature + "{\n}", (PsiElement)context2) : null;
        } else assert (false);
        if (result2 == null) {
            return null;
        }
        if (needBody && body != null && body.isValid()) {
            OCChangeUtil.replaceHandlingMacros(result2.getBody(), body);
        }
        OCElementUtil.replaceDeclarationQualifiers(result2, oldMethod);
        if (needComments) {
            OCElementUtil.replaceComments(result2, oldMethod);
        }
        return OCChangeUtil.markElementForPPAction(result2, OCChangeUtil.PostponedFormatAction.Format);
    }

    public boolean processPrimaryMethod(ChangeInfo changeInfo) {
        return changeInfo instanceof OCChangeInfo;
    }

    public boolean shouldPreviewUsages(ChangeInfo changeInfo, UsageInfo[] usages) {
        return false;
    }

    public static PsiElement generateCall(@Nullable OCExpression receiver, List<OCExpression> arguments, OCChangeInfo changeInfo) {
        OCCallable block;
        OCCallable parentCallable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)receiver, OCCallable.class);
        boolean isSelfSuperCall = changeInfo.getMethod().equals(parentCallable) || receiver instanceof OCReferenceExpression && ((OCReferenceExpression)receiver).getSelfSuperToken() != null && parentCallable instanceof OCMethod && Objects.equals(changeInfo.getMethod().getName(), parentCallable.getName());
        List<String> paramStubs = OCChangeSignatureUsageProcessor.getParamStubs(changeInfo.getNewParameters(), changeInfo.willBeMethod(), isSelfSuperCall, changeInfo.getContext());
        if (changeInfo.willBeMethod()) {
            OCSendMessageExpression sendMessageExpression = OCElementFactory.sendMessageExpression(paramStubs, changeInfo.getContext());
            int paramIndex = 0;
            for (OCExpression stubArgument : sendMessageExpression.getArgumentExpressions()) {
                OCParameterInfo parameterInfo = changeInfo.getNewParameters()[paramIndex++];
                if (OCChangeSignatureUsageProcessor.isNewParameter(parameterInfo, arguments) || parameterInfo.getOldIndex() >= arguments.size()) continue;
                OCExpression oldArgument = arguments.get(parameterInfo.getOldIndex());
                OCChangeUtil.replaceHandlingMacros(stubArgument, oldArgument);
            }
            if (changeInfo.getOldMethodDescriptor().getCallableKind() != OCCallableKind.METHOD) {
                receiver = OCElementFactory.expressionFromText(changeInfo.getNewContainerClass().getName(), changeInfo.getContext());
            }
            OCChangeUtil.replaceHandlingMacros(sendMessageExpression.getReceiverExpression(), receiver);
            return sendMessageExpression;
        }
        OCCallExpression callExpression = OCElementFactory.callExpression(changeInfo.willBeBlock() ? "block" : changeInfo.getNewName(), paramStubs, changeInfo.getContext());
        OCChangeSignatureUsageProcessor.restoreOldArguments(changeInfo, arguments, callExpression);
        if (changeInfo.willBeBlock() && (block = OCChangeSignatureUsageProcessor.generateMethodDefinition(changeInfo, changeInfo.getMethod(), true, true, false, false)) != null) {
            OCChangeUtil.replaceHandlingMacros(callExpression.getFunctionReferenceExpression(), block);
            changeInfo.setNewMethod(block);
        }
        return callExpression;
    }

    public void registerConflictResolvers(List<ResolveSnapshotProvider.ResolveSnapshot> snapshots, @NotNull ResolveSnapshotProvider resolveSnapshotProvider, UsageInfo[] usages, ChangeInfo changeInfo) {
    }

    private static List<String> getParamStubs(OCParameterInfo @NotNull [] parameters, boolean appendSelectors, boolean isSelfSuperCall, @Nullable PsiElement context2) {
        OCParameterInfo parameter;
        ArrayList<String> paramStubs = new ArrayList<String>(parameters.length);
        if (parameters.length == 1 && (parameter = parameters[0]).getType() instanceof OCVoidType && StringUtil.isEmpty((String)parameter.getName())) {
            paramStubs.add("");
            return paramStubs;
        }
        for (OCParameterInfo parameter2 : parameters) {
            paramStubs.add(parameter2.getParameterStubText(appendSelectors, isSelfSuperCall, context2));
        }
        return paramStubs;
    }

    private static boolean isNewParameter(@NotNull OCParameterInfo parameterInfo, @Nullable List<OCExpression> oldArguments) {
        return oldArguments == null || parameterInfo.getOldIndex() < 0;
    }

    private static String getBlockConflict() {
        return OCBundle.message("changeSignature.usages.cantConvertToBlock", new Object[0]);
    }
}

