/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.daemon.OCPragmaSuppressionUtils;
import com.jetbrains.cidr.lang.daemon.OCSuppressionGroup;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForCallable;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForFile;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForStatement;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSuppressClangDiagnosticIntentionAction
extends SuppressIntentionAction {
    private SmartPsiElementPointer<PsiElement> myElementPtr;
    private String myCompiler;
    private String mySuppressOption;
    private String mySuppressScope;

    protected OCSuppressClangDiagnosticIntentionAction(@Nullable PsiElement element, @Nullable OCSuppressionGroup suppressionGroup, String suppressScope) {
        this.myElementPtr = OCElementUtil.createPsiElementPointer(element);
        this.myCompiler = suppressionGroup == null ? null : suppressionGroup.compiler;
        this.mySuppressOption = suppressionGroup == null ? null : suppressionGroup.suppressionOption;
        this.mySuppressScope = suppressScope;
    }

    @NotNull
    public String getFamilyName() {
        return OCBundle.message("intentions.suppress.for", this.mySuppressScope);
    }

    @NotNull
    public String getText() {
        return OCBundle.message("intentions.suppress.option.for", this.mySuppressOption, this.mySuppressScope);
    }

    @Nullable
    protected TextRange getSuppressionRange(OCFile file2) {
        PsiElement element = OCElementUtil.getPsiElementByPointer(this.myElementPtr);
        return element != null ? OCElementUtil.getRangeWithMacros(element) : null;
    }

    public boolean isAvailable(@NotNull Project project2, @Nullable Editor editor, @NotNull PsiElement element) {
        return element.isValid() && this.myElementPtr != null && this.mySuppressOption != null;
    }

    public void invoke(@NotNull Project project2, @Nullable Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCFile file2 = (OCFile)element.getContainingFile();
        Document document2 = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument((PsiFile)file2);
        int elementOffset = OCElementUtil.getRangeWithMacros(element).getStartOffset();
        TextRange suppressionRange = this.getSuppressionRange(file2);
        if (document2 == null || suppressionRange == null) {
            return;
        }
        if (OCPragmaSuppressionUtils.getDiagnosticMode(file2, elementOffset, this.mySuppressOption) == OCPragma.Mode.IGNORE) {
            return;
        }
        int startLine = document2.getLineNumber(suppressionRange.getStartOffset());
        int endLine = document2.getLineNumber(suppressionRange.getEndOffset());
        if (startLine >= 0 && startLine < document2.getLineCount() && endLine >= 0 && endLine < document2.getLineCount()) {
            int startOffset = document2.getLineStartOffset(startLine);
            int endOffset = document2.getLineEndOffset(endLine);
            boolean pushToStack = true;
            if (OCPragmaSuppressionUtils.findExactScope(file2, startOffset, endOffset) != null) {
                pushToStack = false;
            }
            if (pushToStack) {
                document2.insertString(endOffset, (CharSequence)"\n#pragma clang diagnostic pop");
            }
            document2.insertString(startOffset, (CharSequence)("#pragma " + this.myCompiler + " diagnostic ignored \"" + this.mySuppressOption + "\"\n"));
            if (pushToStack) {
                document2.insertString(startOffset, (CharSequence)"#pragma clang diagnostic push\n");
            }
            PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(document2);
        }
    }

    public static class SuppressFixForFile
    extends SuppressFix {
        public SuppressFixForFile(@Nullable OCSuppressionGroup suppressionGroup) {
            super(suppressionGroup);
        }

        @Override
        @NotNull
        protected OCSuppressClangDiagnosticIntentionAction createFix(PsiElement element) {
            return new OCSuppressClangForFile((OCFile)element.getContainingFile(), OCElementUtil.getRangeWithMacros(element), this.mySuppressionGroup);
        }

        @NotNull
        public String getName() {
            return OCBundle.message("intentions.suppress.for.file", new Object[0]);
        }
    }

    public static class SuppressFixForCallable
    extends SuppressFix {
        public SuppressFixForCallable(@Nullable OCSuppressionGroup suppressionGroup) {
            super(suppressionGroup);
        }

        @Override
        @NotNull
        protected OCSuppressClangDiagnosticIntentionAction createFix(PsiElement element) {
            return new OCSuppressClangForCallable(element.getContainingFile(), OCElementUtil.getRangeWithMacros(element), this.mySuppressionGroup);
        }

        @NotNull
        public String getName() {
            return OCBundle.message("intentions.suppress.for.method", new Object[0]);
        }
    }

    public static class SuppressFixForStatement
    extends SuppressFix {
        public SuppressFixForStatement(@Nullable OCSuppressionGroup suppressionGroup) {
            super(suppressionGroup);
        }

        @Override
        @NotNull
        protected OCSuppressClangDiagnosticIntentionAction createFix(PsiElement element) {
            return new OCSuppressClangForStatement(element.getContainingFile(), OCElementUtil.getRangeWithMacros(element), this.mySuppressionGroup);
        }

        @NotNull
        public String getName() {
            return OCBundle.message("intentions.suppress.for.statement", new Object[0]);
        }
    }

    private static abstract class SuppressFix
    implements SuppressQuickFix {
        @Nullable
        protected OCSuppressionGroup mySuppressionGroup;

        protected SuppressFix(@Nullable OCSuppressionGroup suppressionGroup) {
            this.mySuppressionGroup = suppressionGroup;
        }

        @NotNull
        protected abstract OCSuppressClangDiagnosticIntentionAction createFix(PsiElement var1);

        public boolean isAvailable(@NotNull Project project2, @NotNull PsiElement context2) {
            return this.createFix(context2).isAvailable(project2, null, context2);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            this.createFix(descriptor.getPsiElement()).invoke(project2, null, descriptor.getPsiElement());
        }

        public boolean isSuppressAll() {
            return false;
        }
    }
}

